/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client;

import com.flansmod.physics.common.util.Maths;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RecoilManager {
    private float RecoilPendingYaw = 0.0f;
    private float RecoilPendingPitch = 0.0f;
    private float RecoilStacksYaw = 0.0f;
    private float RecoilStacksPitch = 0.0f;
    private float RecoilStacksYawLast = 0.0f;
    private float RecoilStacksPitchLast = 0.0f;

    public float GetRecoilYaw(float dt) {
        return Maths.lerpF(this.RecoilStacksYawLast, this.RecoilStacksYaw, dt);
    }

    public float GetRecoilPitch(float dt) {
        return Maths.lerpF(this.RecoilStacksPitchLast, this.RecoilStacksPitch, dt);
    }

    public RecoilManager() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void AddRecoil(float magYaw, float magPitch) {
        this.RecoilPendingYaw += magYaw;
        this.RecoilPendingPitch += magPitch;
    }

    public void OnPlayerLookInput(Vec2 delta) {
    }

    @SubscribeEvent
    public void OnCameraEvent(@Nonnull ViewportEvent.ComputeCameraAngles event) {
        event.setYaw(event.getYaw() + this.GetRecoilYaw(Minecraft.m_91087_().getPartialTick()));
        event.setPitch(event.getPitch() - this.GetRecoilPitch(Minecraft.m_91087_().getPartialTick()));
    }

    @SubscribeEvent
    public void OnRenderTick(@Nonnull TickEvent.RenderTickEvent event) {
    }

    @SubscribeEvent
    public void OnClientTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.RecoilStacksYawLast = this.RecoilStacksYaw;
            this.RecoilStacksPitchLast = this.RecoilStacksPitch;
            float dYaw = this.RecoilPendingYaw * 0.5f;
            float dPitch = this.RecoilPendingPitch * 0.5f;
            this.RecoilStacksYaw += dYaw;
            this.RecoilStacksPitch += dPitch;
            this.RecoilStacksYaw *= 0.75f;
            this.RecoilStacksPitch *= 0.75f;
            this.RecoilPendingYaw -= dYaw;
            this.RecoilPendingPitch -= dPitch;
        }
    }
}

