/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.infrastructure;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum FlashMode implements StringRepresentable
{
    OFF("off"),
    ON("on"),
    AUTO("auto");

    private final String id;

    private FlashMode(String id) {
        this.id = id;
    }

    public static FlashMode byIdOrOff(String id) {
        for (FlashMode guide : FlashMode.values()) {
            if (!guide.id.equals(id)) continue;
            return guide;
        }
        return OFF;
    }

    public String getId() {
        return this.id;
    }

    @NotNull
    public String m_7912_() {
        return this.id;
    }

    public Component translate() {
        return Component.m_237115_((String)("gui.exposure.flash_mode." + this.id));
    }

    public void toBuffer(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.getId());
    }

    public static FlashMode fromBuffer(FriendlyByteBuf buffer) {
        return FlashMode.byIdOrOff(buffer.m_130277_());
    }
}

