/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.capture.converter;

import com.mojang.blaze3d.platform.NativeImage;
import io.github.mortuusars.exposure.camera.capture.Capture;
import io.github.mortuusars.exposure.camera.capture.converter.IImageToMapColorsConverter;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.material.MapColor;

public class SimpleColorConverter
implements IImageToMapColorsConverter {
    private final double[] shadeCoeffs = new double[]{0.71, 0.86, 1.0, 0.53};

    public static MapColor[] getMapColors() {
        MapColor[] colors = new MapColor[64];
        for (int i = 0; i <= 63; ++i) {
            colors[i] = MapColor.m_284175_((int)i);
        }
        return colors;
    }

    @Override
    public byte[] convert(Capture capture, NativeImage image) {
        return this.convert(image);
    }

    @Override
    public byte[] convert(NativeImage image) {
        int width = image.m_84982_();
        int height = image.m_85084_();
        MapColor[] mapColors = (MapColor[])Arrays.stream(SimpleColorConverter.getMapColors()).filter(Objects::nonNull).toArray(MapColor[]::new);
        byte[] bytes = new byte[width * height];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                byte mapColorIndex;
                int pixelRGBA = image.m_84985_(x, y);
                int R = FastColor.ABGR32.m_266313_((int)pixelRGBA);
                int G = FastColor.ABGR32.m_266446_((int)pixelRGBA);
                int B = FastColor.ABGR32.m_266247_((int)pixelRGBA);
                int A = FastColor.ABGR32.m_266503_((int)pixelRGBA);
                bytes[x + y * width] = A == 0 ? (byte)MapColor.f_283808_.f_283805_ : (mapColorIndex = (byte)this.nearestColor(mapColors, R, G, B, A));
            }
        }
        return bytes;
    }

    private double[] applyShade(double[] color, int shadeIndex) {
        double coeff = this.shadeCoeffs[shadeIndex];
        return new double[]{color[0] * coeff, color[1] * coeff, color[2] * coeff};
    }

    private int nearestColor(MapColor[] colors, int r, int g, int b, int a) {
        double[] imageVector = new double[]{(double)r / 255.0, (double)g / 255.0, (double)b / 255.0};
        int best_color = 0;
        double lowest_distance = 10000.0;
        for (int colorIndex = 0; colorIndex < colors.length; ++colorIndex) {
            int mapColor = colors[colorIndex].f_283871_;
            int mapR = FastColor.ARGB32.m_13665_((int)mapColor);
            int mapG = FastColor.ARGB32.m_13667_((int)mapColor);
            int mapB = FastColor.ARGB32.m_13669_((int)mapColor);
            double[] mcColorVector = new double[]{(double)mapR / 255.0, (double)mapG / 255.0, (double)mapB / 255.0};
            for (int shadeInd = 0; shadeInd < this.shadeCoeffs.length; ++shadeInd) {
                double distance = this.distance(imageVector, this.applyShade(mcColorVector, shadeInd));
                if (!(distance < lowest_distance)) continue;
                lowest_distance = distance;
                best_color = colorIndex == 0 && a == 255 ? 119 : colorIndex * this.shadeCoeffs.length + shadeInd;
            }
        }
        return best_color;
    }

    private double distance(double[] vectorA, double[] vectorB) {
        return Math.sqrt(Math.pow(vectorA[0] - vectorB[0], 2.0) + Math.pow(vectorA[1] - vectorB[1], 2.0) + Math.pow(vectorA[2] - vectorB[2], 2.0));
    }
}

