/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.core.mixin;

import com.google.common.base.Suppliers;
import gg.moonflower.etched.api.record.AlbumCover;
import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.client.sound.EntityRecordSoundInstance;
import java.net.Proxy;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={RecordItem.class})
public abstract class RecordItemMixin
extends Item
implements PlayableRecord {
    @Unique
    private final Supplier<TrackData[]> etched$track = Suppliers.memoize(() -> {
        MutableComponent desc = Component.m_237115_((String)(this.m_5524_() + ".desc"));
        String[] parts = desc.getString().split("-", 2);
        if (parts.length < 2) {
            return new TrackData[]{new TrackData(this.m_43051_().m_11660_().toString(), "Minecraft", (Component)desc)};
        }
        return new TrackData[]{new TrackData(this.m_43051_().m_11660_().toString(), parts[0].trim(), (Component)Component.m_237113_((String)parts[1].trim()).m_130948_(desc.m_7383_()))};
    });

    @Shadow
    public abstract SoundEvent m_43051_();

    private RecordItemMixin(Item.Properties properties) {
        super(properties);
    }

    @Override
    public boolean canPlay(ItemStack stack) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<? extends SoundInstance> createEntitySound(ItemStack stack, Entity entity, int track, int attenuationDistance) {
        Item item;
        if (track != 0 || !((item = stack.m_41720_()) instanceof RecordItem)) {
            return Optional.empty();
        }
        RecordItem record = (RecordItem)item;
        if (PlayableRecord.canShowMessage(entity.m_20185_(), entity.m_20186_(), entity.m_20189_())) {
            Minecraft.m_91087_().f_91065_.m_93055_((Component)record.m_43050_());
        }
        return Optional.of(new EntityRecordSoundInstance(record.m_43051_(), entity));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public CompletableFuture<AlbumCover> getAlbumCover(ItemStack stack, Proxy proxy, ResourceManager resourceManager) {
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)this);
        return resourceManager.m_213713_(new ResourceLocation(key.m_135827_(), "models/item/etched_album_cover/" + key.m_135815_() + ".json")).isPresent() ? CompletableFuture.completedFuture(AlbumCover.of(new ResourceLocation(key.m_135827_(), "etched_album_cover/" + key.m_135815_()))) : CompletableFuture.completedFuture(AlbumCover.EMPTY);
    }

    @Override
    public Optional<TrackData[]> getMusic(ItemStack stack) {
        return Optional.of(this.etched$track.get());
    }

    @Override
    public Optional<TrackData> getAlbum(ItemStack stack) {
        return Optional.empty();
    }

    @Override
    public int getTrackCount(ItemStack stack) {
        return 1;
    }
}

