/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.network.play.handler;

import gg.moonflower.etched.common.item.SimpleMusicLabelItem;
import gg.moonflower.etched.common.menu.AlbumJukeboxMenu;
import gg.moonflower.etched.common.menu.EtchingMenu;
import gg.moonflower.etched.common.menu.RadioMenu;
import gg.moonflower.etched.common.network.EtchedMessages;
import gg.moonflower.etched.common.network.play.ServerboundEditMusicLabelPacket;
import gg.moonflower.etched.common.network.play.ServerboundSetUrlPacket;
import gg.moonflower.etched.common.network.play.SetAlbumJukeboxTrackPacket;
import gg.moonflower.etched.core.registry.EtchedItems;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class EtchedServerPlayPacketHandler {
    public static void handleSetUrl(ServerboundSetUrlPacket pkt, NetworkEvent.Context ctx) {
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof EtchingMenu) {
            EtchingMenu menu = (EtchingMenu)abstractContainerMenu;
            ctx.enqueueWork(() -> menu.setUrl(pkt.url()));
        } else {
            abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof RadioMenu) {
                RadioMenu menu = (RadioMenu)abstractContainerMenu;
                ctx.enqueueWork(() -> menu.setUrl(pkt.url()));
            }
        }
    }

    public static void handleEditMusicLabel(ServerboundEditMusicLabelPacket pkt, NetworkEvent.Context ctx) {
        int slot = pkt.slot();
        if (!Inventory.m_36045_((int)slot) && slot != 40) {
            return;
        }
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        ItemStack labelStack = player.m_150109_().m_8020_(slot);
        if (!labelStack.m_150930_(EtchedItems.MUSIC_LABEL.get())) {
            return;
        }
        ctx.enqueueWork(() -> {
            SimpleMusicLabelItem.setTitle(labelStack, StringUtils.normalizeSpace((String)pkt.title()));
            SimpleMusicLabelItem.setAuthor(labelStack, StringUtils.normalizeSpace((String)pkt.author()));
        });
    }

    public static void handleSetAlbumJukeboxTrack(SetAlbumJukeboxTrackPacket pkt, NetworkEvent.Context ctx) {
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof AlbumJukeboxMenu) {
            AlbumJukeboxMenu menu = (AlbumJukeboxMenu)abstractContainerMenu;
            ctx.enqueueWork(() -> {
                ServerLevel level = player.m_284548_();
                if (menu.setPlayingTrack((Level)level, pkt)) {
                    EtchedMessages.PLAY.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(menu.getPos())), (Object)new SetAlbumJukeboxTrackPacket(pkt.playingIndex(), pkt.track()));
                }
            });
        }
    }
}

