/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.delicacy.registries;

import auviotre.enigmatic.addon.handlers.SuperAddonHandler;
import auviotre.enigmatic.addon.registries.AbstractRegistry;
import auviotre.enigmatic.addon.registries.EnigmaticAddonDamageTypes;
import auviotre.enigmatic.delicacy.EnigmaticDelicacy;
import auviotre.enigmatic.delicacy.contents.effects.AbyssCorruptionEffect;
import auviotre.enigmatic.delicacy.contents.effects.AstralDrunkennessEffect;
import auviotre.enigmatic.delicacy.contents.effects.FadingEffect;
import auviotre.enigmatic.delicacy.contents.effects.HealthCurseEffect;
import auviotre.enigmatic.delicacy.contents.effects.PerseveranceEffect;
import auviotre.enigmatic.delicacy.contents.effects.RedemptionEffect;
import auviotre.enigmatic.delicacy.contents.effects.XPBoostEffect;
import auviotre.enigmatic.delicacy.contents.items.AbyssalStew;
import auviotre.enigmatic.delicacy.contents.items.FadingScroll;
import auviotre.enigmatic.delicacy.packets.client.PacketAbyssCorruption;
import auviotre.enigmatic.delicacy.registries.EnigmaticDelightItems;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.items.ForbiddenFruit;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.living.PotionColorCalculationEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ObjectHolder;

public class EnigmaticDelightEffects
extends AbstractRegistry<MobEffect> {
    @ObjectHolder(value="enigmaticdelicacy:astral_drunkenness", registryName="mob_effect")
    public static final AstralDrunkennessEffect ASTRAL_DRUNKENNESS_EFFECT = null;
    @ObjectHolder(value="enigmaticdelicacy:xp_boost", registryName="mob_effect")
    public static final XPBoostEffect XP_BOOST_EFFECT = null;
    @ObjectHolder(value="enigmaticdelicacy:fading", registryName="mob_effect")
    public static final FadingEffect FADING_EFFECT = null;
    @ObjectHolder(value="enigmaticdelicacy:perseverance", registryName="mob_effect")
    public static final PerseveranceEffect PERSEVERANCE_EFFECT = null;
    @ObjectHolder(value="enigmaticdelicacy:redemption", registryName="mob_effect")
    public static final RedemptionEffect REDEMPTION_EFFECT = null;
    @ObjectHolder(value="enigmaticdelicacy:health_curse", registryName="mob_effect")
    public static final HealthCurseEffect HEALTH_CURSE_EFFECT = null;
    @ObjectHolder(value="enigmaticdelicacy:abyss_corruption", registryName="mob_effect")
    public static final AbyssCorruptionEffect ABYSS_CORRUPTION_EFFECT = null;
    private static final EnigmaticDelightEffects INSTANCE = new EnigmaticDelightEffects();

    protected EnigmaticDelightEffects() {
        super(ForgeRegistries.MOB_EFFECTS, "enigmaticdelicacy");
        this.register("astral_drunkenness", AstralDrunkennessEffect::new);
        this.register("xp_boost", XPBoostEffect::new);
        this.register("fading", FadingEffect::new);
        this.register("perseverance", PerseveranceEffect::new);
        this.register("redemption", RedemptionEffect::new);
        this.register("health_curse", HealthCurseEffect::new);
        this.register("abyss_corruption", AbyssCorruptionEffect::new);
    }

    @Mod.EventBusSubscriber(modid="enigmaticdelicacy", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class DelightEffectEvents {
        public static final List<String> NO_REMOVABLE_EFFECTS = List.of("enigmaticdelicacy:astral_drunkenness", "enigmaticdelicacy:abyss_corruption", "enigmaticdelicacy:health_curse", "enigmaticdelicacy:redemption");

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onEffectRemove(MobEffectEvent.Remove event) {
            LivingEntity entity = event.getEntity();
            MobEffect effect = event.getEffect();
            if (effect.equals((Object)HEALTH_CURSE_EFFECT) && entity.getPersistentData().m_128471_("ClearHealthCurse")) {
                return;
            }
            if (NO_REMOVABLE_EFFECTS.stream().anyMatch(location -> effect.equals(ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(location))))) {
                event.setCanceled(true);
                event.setResult(Event.Result.DENY);
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
        public static void onEffectRemoveLow(MobEffectEvent.Remove event) {
            LivingEntity entity = event.getEntity();
            MobEffect effect = event.getEffect();
            if (effect.equals((Object)HEALTH_CURSE_EFFECT) && entity.getPersistentData().m_128471_("ClearHealthCurse")) {
                return;
            }
            if (NO_REMOVABLE_EFFECTS.stream().anyMatch(location -> effect.equals(ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(location))))) {
                event.setCanceled(true);
                event.setResult(Event.Result.DENY);
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
        public static void onEffectApply(MobEffectEvent.Applicable event) {
            MobEffect effect = event.getEffectInstance().m_19544_();
            if (NO_REMOVABLE_EFFECTS.stream().anyMatch(location -> effect.equals(ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(location))))) {
                event.setResult(Event.Result.ALLOW);
            }
        }

        @SubscribeEvent(receiveCanceled=true)
        public static void setEffectColor(PotionColorCalculationEvent event) {
            LivingEntity entity = event.getEntity();
            Collection effects = event.getEffects();
            if (effects.stream().anyMatch(effectInstance -> effectInstance.m_19544_().equals((Object)ASTRAL_DRUNKENNESS_EFFECT))) {
                event.setColor(Mth.m_14169_((float)entity.m_217043_().m_188501_(), (float)1.0f, (float)1.0f));
                entity.m_147215_(entity.m_21124_((MobEffect)ASTRAL_DRUNKENNESS_EFFECT), null);
            }
        }

        @SubscribeEvent
        public static void onAttacked(LivingAttackEvent event) {
            LivingEntity entity = event.getEntity();
            if (entity.m_21023_((MobEffect)FADING_EFFECT) && event.getSource().m_7640_() != entity) {
                Level level;
                event.setCanceled(true);
                entity.m_21195_((MobEffect)FADING_EFFECT);
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (SuperpositionHandler.hasCurio((LivingEntity)entity, (Item)EnigmaticDelightItems.FADING_SCROLL)) {
                        player.m_36335_().m_41524_((Item)EnigmaticDelightItems.FADING_SCROLL, FadingScroll.cooldown.getValue());
                    }
                }
                if ((level = entity.m_9236_()) instanceof ServerLevel) {
                    ServerLevel level2 = (ServerLevel)level;
                    level2.m_8767_((ParticleOptions)ParticleTypes.f_123796_, entity.m_20185_(), entity.m_20188_(), entity.m_20189_(), 5, 0.0, 0.0, 0.0, 0.05);
                }
            }
        }

        @SubscribeEvent
        public static void onHurt(LivingHurtEvent event) {
            LivingEntity living;
            Entity entity = event.getSource().m_7640_();
            if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21023_((MobEffect)FADING_EFFECT)) {
                Level level;
                living.m_21195_((MobEffect)FADING_EFFECT);
                event.setAmount(event.getAmount() * 2.0f);
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (SuperpositionHandler.hasCurio((LivingEntity)living, (Item)EnigmaticDelightItems.FADING_SCROLL)) {
                        player.m_36335_().m_41524_((Item)EnigmaticDelightItems.FADING_SCROLL, FadingScroll.cooldown.getValue());
                    }
                }
                if ((level = entity.m_9236_()) instanceof ServerLevel) {
                    ServerLevel level2 = (ServerLevel)level;
                    level2.m_8767_((ParticleOptions)ParticleTypes.f_123796_, entity.m_20185_(), entity.m_20188_(), entity.m_20189_(), 5, 0.0, 0.0, 0.0, 0.05);
                }
            }
            if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21023_((MobEffect)ASTRAL_DRUNKENNESS_EFFECT)) {
                int amplifier = living.m_21124_((MobEffect)ASTRAL_DRUNKENNESS_EFFECT).m_19564_() + 1;
                float modifier = amplifier < 5 ? 0.05f * (float)amplifier : 0.4f;
                event.setAmount(event.getAmount() * (1.0f - modifier));
            }
        }

        @SubscribeEvent
        public static void onDamaged(LivingDamageEvent event) {
            Player player;
            Entity entity;
            LivingEntity victim = event.getEntity();
            if (victim.m_21023_((MobEffect)PERSEVERANCE_EFFECT)) {
                MobEffectInstance effect = victim.m_21124_((MobEffect)PERSEVERANCE_EFFECT);
                victim.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 400, effect.m_19564_()));
            }
            if ((entity = event.getSource().m_7639_()) instanceof Player && AbyssalStew.getAbyssTick(player = (Player)entity) > 0) {
                victim.m_7292_(new MobEffectInstance((MobEffect)ABYSS_CORRUPTION_EFFECT, 400));
            }
        }

        @SubscribeEvent
        public static void onDeath(LivingDeathEvent event) {
            LivingEntity victim = event.getEntity();
            if (victim.m_21023_((MobEffect)ABYSS_CORRUPTION_EFFECT)) {
                List entities = victim.m_9236_().m_45976_(LivingEntity.class, victim.m_20191_().m_82400_(4.2));
                for (LivingEntity entity : entities) {
                    Player player;
                    if (!entity.m_6084_() || entity.m_7306_((Entity)victim) || entity instanceof Player && AbyssalStew.getAbyssTick(player = (Player)entity) > 0) continue;
                    entity.m_147207_(victim.m_21124_((MobEffect)ABYSS_CORRUPTION_EFFECT), (Entity)victim);
                    entity.m_6469_(SuperAddonHandler.damageSource((Entity)entity, (ResourceKey)EnigmaticAddonDamageTypes.ABYSS, (Entity)victim), victim.m_21233_() * 0.8f);
                }
                if (!victim.m_9236_().f_46443_) {
                    EnigmaticDelicacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), 64.0, victim.m_9236_().m_46472_())), (Object)new PacketAbyssCorruption(victim.m_20185_(), victim.m_20186_(), victim.m_20189_()));
                }
            }
        }

        @SubscribeEvent
        public static void onEXPPick(PlayerXpEvent.XpChange event) {
            int amount = event.getAmount();
            Player player = event.getEntity();
            if (player.m_21023_((MobEffect)XP_BOOST_EFFECT)) {
                int amplifier = player.m_21124_((MobEffect)XP_BOOST_EFFECT).m_19564_() + 1;
                event.setAmount(Mth.m_14107_((double)((double)amount * (1.0 + (double)amplifier * 0.5))));
                if (player.m_217043_().m_188503_(6) < amplifier) {
                    player.m_5634_(0.5f);
                }
            }
        }

        @SubscribeEvent
        public void onLivingHeal(LivingHealEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (event.getAmount() <= 2.0f && RedemptionEffect.enable(player)) {
                    float modifier = ForbiddenFruit.regenerationSubtraction.getValue().asModifier() / 2.0f;
                    event.setAmount(event.getAmount() * (1.0f - modifier));
                }
            }
        }
    }
}

