/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.packets.clients;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class PacketExtradimensionParticles {
    private final double x;
    private final double y;
    private final double z;
    private final double width;
    private final double height;
    private final int mode;

    public PacketExtradimensionParticles(double x, double y, double z, double width, double height, int mode) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.width = width;
        this.height = height;
        this.mode = mode;
    }

    public static void encode(PacketExtradimensionParticles msg, FriendlyByteBuf buf) {
        buf.writeDouble(msg.x);
        buf.writeDouble(msg.y);
        buf.writeDouble(msg.z);
        buf.writeDouble(msg.width);
        buf.writeDouble(msg.height);
        buf.writeInt(msg.mode);
    }

    public static PacketExtradimensionParticles decode(FriendlyByteBuf buf) {
        return new PacketExtradimensionParticles(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readInt());
    }

    public static void handle(PacketExtradimensionParticles msg, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            Level level = player.m_9236_();
            if (msg.mode == 1) {
                BlockPos blockPos = new BlockPos(Mth.m_14107_((double)msg.x), Mth.m_14107_((double)msg.y), Mth.m_14107_((double)msg.z));
                int i = 0;
                while ((double)i < 24.0 + msg.height * 2.0 + msg.width * 5.0) {
                    double xOffset = msg.width * (double)(0.5f - player.m_217043_().m_188501_());
                    double yOffset = msg.height * (double)player.m_217043_().m_188501_();
                    double zOffset = msg.width * (double)(0.5f - player.m_217043_().m_188501_());
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123771_, msg.x + xOffset, msg.y + yOffset, msg.z + zOffset, 0.0, 0.0, 0.0);
                    if (i % 2 == 0) {
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123796_, msg.x + xOffset, msg.y + yOffset, msg.z + zOffset, 0.0, 0.0, 0.0);
                    }
                    if (i % 8 == 0) {
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123813_, msg.x + xOffset * 2.0, msg.y + yOffset, msg.z + zOffset * 2.0, 0.0, 0.0, 0.0);
                    }
                    ++i;
                }
            }
        });
        context.get().setPacketHandled(true);
    }
}

