/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.handlers;

import auviotre.enigmatic.addon.api.events.LivingCurseBoostEvent;
import auviotre.enigmatic.addon.contents.enchantments.RedemptionCurseEnchantment;
import auviotre.enigmatic.addon.contents.objects.bookbag.AntiqueBagCapability;
import auviotre.enigmatic.addon.contents.objects.bookbag.IAntiqueBagHandler;
import auviotre.enigmatic.addon.handlers.AddonHookHandler;
import auviotre.enigmatic.addon.handlers.OmniconfigAddonHandler;
import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;

public class SuperAddonHandler {
    public static final UUID SCROLL_SLOT_UUID = UUID.fromString("36e2f84d-a453-467d-8836-41e2f42db78a");

    public static boolean isCurseBoosted(LivingEntity entity) {
        if (!OmniconfigAddonHandler.EnableCurseBoost.getValue()) {
            return false;
        }
        return entity.getPersistentData().m_128471_("CurseBoost");
    }

    public static void setCurseBoosted(LivingEntity entity, Boolean flag, Player player) {
        Mob mob;
        if (!OmniconfigAddonHandler.EnableCurseBoost.getValue()) {
            return;
        }
        if (entity instanceof Mob && (mob = (Mob)entity).m_21525_()) {
            return;
        }
        LivingCurseBoostEvent event = AddonHookHandler.onLivingCurseBoosted(entity, player);
        if (!event.isCanceled()) {
            entity.getPersistentData().m_128379_("CurseBoost", flag.booleanValue());
        }
    }

    @Nullable
    public static <T> LazyOptional<T> getCapability(Player player, Capability<T> capability) {
        return player == null ? null : player.getCapability(capability);
    }

    public static boolean unlockSpecialSlot(String slot, Player player) {
        if (!slot.equals("scroll")) {
            throw new IllegalArgumentException("Slot type '" + slot + "' is not supported!");
        }
        MutableBoolean success = new MutableBoolean(false);
        UUID id = SCROLL_SLOT_UUID;
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> handler.getStacksHandler(slot).ifPresent(stacks -> {
            if (!stacks.getModifiers().containsKey(id)) {
                stacks.addPermanentModifier(new AttributeModifier(id, "MasterSlot", 1.0, AttributeModifier.Operation.ADDITION));
                success.setTrue();
            }
        }));
        return success.getValue();
    }

    @Nullable
    public static ItemStack getChaosElytra(LivingEntity living) {
        ItemStack stack = living.m_6844_(EquipmentSlot.CHEST);
        return stack.m_150930_((Item)EnigmaticAddonItems.CHAOS_ELYTRA) ? stack : SuperpositionHandler.getCurioStack((LivingEntity)living, (Item)EnigmaticAddonItems.CHAOS_ELYTRA);
    }

    public static ItemStack getItem(Player player, Item item) {
        for (NonNullList stacks : player.m_150109_().f_35979_) {
            for (ItemStack itemstack : stacks) {
                if (itemstack.m_41619_() || !itemstack.m_150930_(item)) continue;
                return itemstack;
            }
        }
        return ItemStack.f_41583_;
    }

    public static List<ItemStack> getAllItem(Player player, Item item) {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        for (NonNullList stacks : player.m_150109_().f_35979_) {
            for (ItemStack itemstack : stacks) {
                if (itemstack.m_41619_() || !itemstack.m_150930_(item)) continue;
                outputs.add(itemstack);
            }
        }
        return outputs;
    }

    public static DamageSource simpleSource(@NotNull Entity target, ResourceKey<DamageType> type) {
        return target.m_269291_().m_269298_(type, null);
    }

    public static DamageSource damageSource(@NotNull Entity target, ResourceKey<DamageType> type, Entity source) {
        return target.m_269291_().m_269298_(type, source);
    }

    public static DamageSource damageSource(@NotNull Entity target, ResourceKey<DamageType> type, Entity direct, Entity source) {
        return target.m_269291_().m_268998_(type, direct, source);
    }

    private static boolean hasBlessRing(Player player) {
        return player.getPersistentData().m_128471_("BlessNextSpawn") || SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.BLESS_RING);
    }

    public static boolean isTheBlessedOne(Player player) {
        return SuperAddonHandler.hasBlessRing(player) && !SuperpositionHandler.isTheCursedOne((Player)player);
    }

    public static boolean isOKOne(Player player) {
        return SuperAddonHandler.hasBlessRing(player) || SuperpositionHandler.isTheCursedOne((Player)player);
    }

    public static boolean isPunishedOne(LivingEntity entity) {
        Player player;
        return entity instanceof Player && SuperAddonHandler.hasBlessRing(player = (Player)entity) && SuperpositionHandler.isTheCursedOne((Player)player);
    }

    public static boolean isAbyssBoost(Player player) {
        return false;
    }

    public static int getEnderDragonBoostLevel(EnderDragon dragon) {
        int level = 2;
        List nearbyPlayers = dragon.m_9236_().m_45955_(TargetingConditions.f_26872_, (LivingEntity)dragon, dragon.m_20191_().m_82400_(100.0));
        for (Player nearbyPlayer : nearbyPlayers) {
            int heartsGained = SuperpositionHandler.getPersistentInteger((Player)nearbyPlayer, (String)"AbyssalHeartsGained", (int)0);
            level += heartsGained;
        }
        return Math.min(level, 20);
    }

    public static ItemStack findBookInBag(Player player, Item book) {
        if (!SuperpositionHandler.hasItem((Player)player, (Item)EnigmaticAddonItems.ANTIQUE_BAG) && !player.m_36327_().m_18949_(Set.of(EnigmaticAddonItems.ANTIQUE_BAG))) {
            return ItemStack.f_41583_;
        }
        LazyOptional<IAntiqueBagHandler> capability = SuperAddonHandler.getCapability(player, AntiqueBagCapability.INVENTORY);
        if (capability != null && capability.isPresent()) {
            IAntiqueBagHandler bagHandler = (IAntiqueBagHandler)capability.orElseThrow(() -> new IllegalArgumentException("Lazy optional must not be empty"));
            return bagHandler.findBook(book);
        }
        return ItemStack.f_41583_;
    }

    public static AABB getBoundingBoxAroundEntity(Entity entity, double x, double y, double z) {
        return new AABB(entity.m_20185_() - x, entity.m_20186_() - y, entity.m_20189_() - z, entity.m_20185_() + x, entity.m_20186_() + y, entity.m_20189_() + z);
    }

    public static int getRedemptionCurseAmount(ItemStack stack) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        int totalCurses = 0;
        for (Enchantment enchantment : enchantments.keySet()) {
            if (!(enchantment instanceof RedemptionCurseEnchantment) || (Integer)enchantments.get(enchantment) <= 0) continue;
            ++totalCurses;
        }
        return totalCurses;
    }

    public static long encodeUUID(UUID uuid) {
        AtomicLong code = new AtomicLong();
        uuid.toString().chars().forEach(c -> code.set(code.get() * 3L + (long)c));
        return code.get();
    }

    @Nullable
    public static LootPoolSingletonContainer.Builder<?> createOptionalLootEntry(Item item, int weight, float minCount, float maxCount) {
        return !OmniconfigAddonHandler.isItemEnabled(item) ? null : LootItem.m_79579_((ItemLike)item).m_79707_(weight).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)minCount, (float)maxCount)));
    }

    @Nullable
    public static LootPoolSingletonContainer.Builder<?> createOptionalLootEntry(Item item, int weight) {
        return !OmniconfigAddonHandler.isItemEnabled(item) ? null : LootItem.m_79579_((ItemLike)item).m_79707_(weight);
    }

    public static List<ResourceLocation> getIceDungeons() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(BuiltInLootTables.f_78688_);
        lootChestList.add(BuiltInLootTables.f_230877_);
        return lootChestList;
    }

    public static List<ResourceLocation> getLeafDungeons() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(BuiltInLootTables.f_78686_);
        return lootChestList;
    }

    public static List<ResourceLocation> getEngineDungeons() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(BuiltInLootTables.f_78742_);
        lootChestList.add(BuiltInLootTables.f_78690_);
        lootChestList.add(BuiltInLootTables.f_78691_);
        lootChestList.add(BuiltInLootTables.f_78763_);
        lootChestList.add(BuiltInLootTables.f_78762_);
        return lootChestList;
    }

    public static List<ResourceLocation> getSoulDungeons() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(BuiltInLootTables.f_78698_);
        lootChestList.add(BuiltInLootTables.f_78697_);
        return lootChestList;
    }
}

