/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.handlers;

import auviotre.enigmatic.addon.contents.items.TotemOfMalice;
import auviotre.enigmatic.addon.handlers.OmniconfigAddonHandler;
import auviotre.enigmatic.addon.helpers.JEIBrewingHelper;
import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import com.aizistral.enigmaticlegacy.crafting.HiddenRecipe;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class AddonJEIPlugin
implements IModPlugin {
    public static final RecipeType<CraftingRecipe> HIDDEN_CRAFTING = RecipeType.create((String)"enigmaticlegacy", (String)"hidden_crafting", CraftingRecipe.class);
    private static final ResourceLocation ID = new ResourceLocation("enigmaticaddons", "common_plugin");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new HiddenRecipeCategory(guiHelper)});
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)EnigmaticItems.COMMON_POTION, (IIngredientSubtypeInterpreter)JEIBrewingHelper.SubtypeInterpreter.LEGACY_INSTANCE);
        registration.registerSubtypeInterpreter((Item)EnigmaticItems.COMMON_POTION_SPLASH, (IIngredientSubtypeInterpreter)JEIBrewingHelper.SubtypeInterpreter.LEGACY_INSTANCE);
        registration.registerSubtypeInterpreter((Item)EnigmaticItems.COMMON_POTION_LINGERING, (IIngredientSubtypeInterpreter)JEIBrewingHelper.SubtypeInterpreter.LEGACY_INSTANCE);
        registration.registerSubtypeInterpreter((Item)EnigmaticItems.ULTIMATE_POTION, (IIngredientSubtypeInterpreter)JEIBrewingHelper.SubtypeInterpreter.LEGACY_INSTANCE);
        registration.registerSubtypeInterpreter((Item)EnigmaticItems.ULTIMATE_POTION_SPLASH, (IIngredientSubtypeInterpreter)JEIBrewingHelper.SubtypeInterpreter.LEGACY_INSTANCE);
        registration.registerSubtypeInterpreter((Item)EnigmaticItems.ULTIMATE_POTION_LINGERING, (IIngredientSubtypeInterpreter)JEIBrewingHelper.SubtypeInterpreter.LEGACY_INSTANCE);
        registration.registerSubtypeInterpreter((Item)EnigmaticAddonItems.COMMON_POTION, (IIngredientSubtypeInterpreter)JEIBrewingHelper.SubtypeInterpreter.ADDON_INSTANCE);
        registration.registerSubtypeInterpreter((Item)EnigmaticAddonItems.COMMON_POTION_SPLASH, (IIngredientSubtypeInterpreter)JEIBrewingHelper.SubtypeInterpreter.ADDON_INSTANCE);
        registration.registerSubtypeInterpreter((Item)EnigmaticAddonItems.COMMON_POTION_LINGERING, (IIngredientSubtypeInterpreter)JEIBrewingHelper.SubtypeInterpreter.ADDON_INSTANCE);
        registration.registerSubtypeInterpreter((Item)EnigmaticAddonItems.ULTIMATE_POTION, (IIngredientSubtypeInterpreter)JEIBrewingHelper.SubtypeInterpreter.ADDON_INSTANCE);
        registration.registerSubtypeInterpreter((Item)EnigmaticAddonItems.ULTIMATE_POTION_SPLASH, (IIngredientSubtypeInterpreter)JEIBrewingHelper.SubtypeInterpreter.ADDON_INSTANCE);
        registration.registerSubtypeInterpreter((Item)EnigmaticAddonItems.ULTIMATE_POTION_LINGERING, (IIngredientSubtypeInterpreter)JEIBrewingHelper.SubtypeInterpreter.ADDON_INSTANCE);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        IVanillaRecipeFactory vanillaRecipeFactory = registration.getVanillaRecipeFactory();
        List<IJeiBrewingRecipe> brewingRecipes = JEIBrewingHelper.getBrewingRecipes(vanillaRecipeFactory);
        brewingRecipes.sort(Comparator.comparingInt(IJeiBrewingRecipe::getBrewingSteps));
        registration.addRecipes(RecipeTypes.BREWING, brewingRecipes);
        ItemStack stack = EnigmaticAddonItems.TOTEM_OF_MALICE.m_7968_();
        TotemOfMalice.setTotemPower(stack, 3);
        IJeiAnvilRecipe totemRecipe = vanillaRecipeFactory.createAnvilRecipe(EnigmaticAddonItems.TOTEM_OF_MALICE.m_7968_(), List.of(EnigmaticItems.EVIL_ESSENCE.m_7968_()), List.of(stack), new ResourceLocation("enigmaticaddons", "material_repair.totem_of_malice"));
        stack = EnigmaticAddonItems.EXTRADIMENSIONAL_SCEPTER.m_7968_();
        stack.m_41721_(stack.m_41776_());
        ItemStack output = EnigmaticAddonItems.EXTRADIMENSIONAL_SCEPTER.m_7968_();
        output.m_41721_(Mth.m_14165_((double)((double)output.m_41776_() * 0.75)));
        IJeiAnvilRecipe scepterRecipe = vanillaRecipeFactory.createAnvilRecipe(stack, List.of(EnigmaticItems.EXTRADIMENSIONAL_EYE.m_7968_()), List.of(output), new ResourceLocation("enigmaticaddons", "material_repair.extradimensional_scepter"));
        registration.addRecipes(RecipeTypes.ANVIL, List.of(totemRecipe, scepterRecipe));
        if (OmniconfigAddonHandler.HiddenRecipeJEIDisplay.getValue()) {
            registration.addRecipes(HIDDEN_CRAFTING, this.getHiddenRecipe());
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50091_), new RecipeType[]{HIDDEN_CRAFTING});
    }

    private List<CraftingRecipe> getHiddenRecipe() {
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
        ForgeRegistries.ITEMS.forEach(item -> {
            ResourceLocation itemKey = ForgeRegistries.ITEMS.getKey(item);
            Map.Entry recipe = HiddenRecipe.getRecipe((ResourceLocation)itemKey);
            if (!((ItemStack)recipe.getValue()).m_41619_()) {
                ItemStack[][] inputs = (ItemStack[][])recipe.getKey();
                NonNullList ingredients = NonNullList.m_122780_((int)9, (Object)Ingredient.f_43901_);
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        ingredients.set(3 * i + j, (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{inputs[i][j]}));
                    }
                }
                ShapedRecipe shapedRecipe = new ShapedRecipe(itemKey, "", CraftingBookCategory.MISC, 3, 3, ingredients, item.m_7968_());
                recipes.add((CraftingRecipe)shapedRecipe);
            }
        });
        return recipes;
    }

    public static class HiddenRecipeCategory
    extends AbstractRecipeCategory<CraftingRecipe> {
        private final IDrawable background;

        public HiddenRecipeCategory(IGuiHelper guiHelper) {
            super(HIDDEN_CRAFTING, (Component)Component.m_237115_((String)"gui.jei.enigmaticlegacy.category.hidden_crafting"), guiHelper.createDrawableItemStack(new ItemStack((ItemLike)Blocks.f_50091_)), 116, 54);
            ResourceLocation location = new ResourceLocation("enigmaticaddons", "textures/gui/jei_hidden_crafting.png");
            this.background = guiHelper.createDrawable(location, 0, 0, 116, 54);
        }

        public void draw(CraftingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
            this.background.draw(guiGraphics);
        }

        public void setRecipe(IRecipeLayoutBuilder builder, CraftingRecipe recipe, IFocusGroup focuses) {
            NonNullList ingredients = recipe.m_7527_();
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 3; ++x) {
                    builder.addSlot(RecipeIngredientRole.INPUT, x * 18 + 1, y * 18 + 1).addIngredients((Ingredient)ingredients.get(y * 3 + x));
                }
            }
            builder.addSlot(RecipeIngredientRole.OUTPUT, 95, 19).addItemStack(recipe.m_8043_(null));
        }
    }
}

