/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.handlers;

import auviotre.enigmatic.addon.contents.brewing.AddonBrewingRecipe;
import auviotre.enigmatic.addon.contents.brewing.AstralBrewingRecipe;
import com.aizistral.enigmaticlegacy.brewing.AbstractBrewingRecipe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class AddonBrewingRecipeProcessor
implements IComponentProcessor {
    private AbstractBrewingRecipe recipe;

    public static List<IVariable> wrapStackList(ItemStack ... stackList) {
        ArrayList<IVariable> variableList = new ArrayList<IVariable>();
        for (ItemStack catalyst : stackList) {
            variableList.add(IVariable.from((Object)catalyst));
        }
        return variableList;
    }

    public static List<IVariable> wrapIngredientSet(Iterable<Ingredient> ingredientSet) {
        ArrayList<IVariable> variableList = new ArrayList<IVariable>();
        for (Ingredient ingredient : ingredientSet) {
            variableList.addAll(AddonBrewingRecipeProcessor.wrapStackList(ingredient.m_43908_()));
        }
        return variableList;
    }

    public void setup(Level level, IVariableProvider variables) {
        ResourceLocation recipeId = new ResourceLocation(variables.get("recipe").asString());
        int index = variables.get("index").asNumber().intValue();
        this.recipe = AbstractBrewingRecipe.recipeMap.containsKey(recipeId) ? (AbstractBrewingRecipe)((List)AbstractBrewingRecipe.recipeMap.get(recipeId)).get(index) : AbstractBrewingRecipe.EMPTY_RECIPE;
    }

    public IVariable process(Level level, String key) {
        AbstractBrewingRecipe abstractBrewingRecipe = this.recipe;
        if (abstractBrewingRecipe instanceof AstralBrewingRecipe) {
            AstralBrewingRecipe astral = (AstralBrewingRecipe)abstractBrewingRecipe;
            if (key.startsWith("catalyst")) {
                return IVariable.wrapList(AddonBrewingRecipeProcessor.wrapStackList(astral.getIngredient().m_43908_()));
            }
            if (key.startsWith("input")) {
                return IVariable.wrapList(AddonBrewingRecipeProcessor.wrapStackList(astral.getInput().m_43908_()));
            }
            if (key.startsWith("output")) {
                return IVariable.from((Object)astral.getOutput());
            }
        } else {
            abstractBrewingRecipe = this.recipe;
            if (abstractBrewingRecipe instanceof AddonBrewingRecipe) {
                AddonBrewingRecipe addon = (AddonBrewingRecipe)abstractBrewingRecipe;
                HashMap<Ingredient, Ingredient> processingMappings = addon.getProcessingMappings();
                if (key.startsWith("catalyst")) {
                    return IVariable.wrapList(AddonBrewingRecipeProcessor.wrapIngredientSet(processingMappings.values()));
                }
                if (key.startsWith("input")) {
                    return IVariable.wrapList(AddonBrewingRecipeProcessor.wrapIngredientSet(processingMappings.keySet()));
                }
                if (key.startsWith("output")) {
                    return IVariable.from((Object)addon.getOutput());
                }
            }
        }
        return null;
    }
}

