/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import auviotre.enigmatic.addon.EnigmaticAddons;
import auviotre.enigmatic.addon.handlers.SuperAddonHandler;
import auviotre.enigmatic.addon.packets.clients.PacketExtradimensionParticles;
import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.entities.PermanentItemEntity;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBase;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import com.aizistral.enigmaticlegacy.registries.EnigmaticSounds;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class ExtradimensionalScepter
extends ItemBase {
    public static Omniconfig.IntParameter transportingCooldown;
    public static Omniconfig.IntParameter overheatingCooldown;
    public static Omniconfig.IntParameter maxCombatCount;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public ExtradimensionalScepter() {
        super(ItemBase.getDefaultProperties().m_41497_(Rarity.EPIC).m_41487_(1).m_41503_(240).m_41486_());
        MinecraftForge.EVENT_BUS.register((Object)this);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 1.5, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)-1.6f, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("ScepterofExtradimensional");
        transportingCooldown = builder.comment("The cooldown of Transporting Mode. Measured in ticks.").min(200.0).getInt("TransportingCooldown", 280);
        overheatingCooldown = builder.comment("The cooldown of Combat Mode when using continuously to long. Measured in ticks.").min(100.0).getInt("OverheatCooldown", 150);
        maxCombatCount = builder.comment("The max count to transporting enemies of Combat Mode.").getInt("MaxCombatCount", 5);
        builder.popPrefix();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        CompoundTag storeEntityTag;
        if (!Helper.isCombatMode(stack)) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.extradimensionalScepter1");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.extradimensionalScepterCooldown", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{transportingCooldown.getValue() / 20});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.extradimensionalScepterModeS");
        } else {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.extradimensionalScepter2");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.extradimensionalScepter3");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.extradimensionalScepterCooldown", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{overheatingCooldown.getValue() / 20});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.extradimensionalScepterModeC");
        }
        if (Helper.isValid(stack) && !Helper.isCombatMode(stack) && (storeEntityTag = Helper.getInfo(stack)) != null) {
            String customName = storeEntityTag.m_128461_("CustomName");
            MutableComponent type = Component.m_237115_((String)Helper.getType(stack).m_20675_());
            if (customName.isEmpty()) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.extradimensionalScepterInfo", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{type});
            } else {
                MutableComponent custom = Component.Serializer.m_130701_((String)customName);
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.extradimensionalScepterInfo_alt", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{custom, type});
            }
        }
        if (stack.m_41793_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        }
    }

    public boolean m_7579_(ItemStack stack, LivingEntity entity, LivingEntity user) {
        stack.m_41622_(2, user, consumer -> consumer.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        if (Helper.validScepter(player, itemInHand)) {
            if (player.m_6047_()) {
                Helper.switchMode(itemInHand, player);
                return InteractionResultHolder.m_19090_((Object)itemInHand);
            }
            if (Helper.isCombatMode(itemInHand)) {
                player.m_6672_(hand);
                return InteractionResultHolder.m_19096_((Object)itemInHand);
            }
        }
        return super.m_7203_(level, player, hand);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity user) {
        if (user instanceof Player) {
            Player player = (Player)user;
            int pass = this.m_8105_(stack);
            stack.m_41622_(this.m_8105_(stack) / 8, (LivingEntity)player, consumer -> consumer.m_21190_(player.m_7655_()));
            player.m_36335_().m_41524_((Item)this, Helper.getOverheatCooldown(player));
            player.m_9236_().m_247517_(null, player.m_20183_(), SoundEvents.f_11914_, SoundSource.PLAYERS);
            player.m_6674_(player.m_7655_());
        }
        return stack;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int tick) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int pass = this.m_8105_(stack) - tick;
            stack.m_41622_(pass / 8, (LivingEntity)player, consumer -> consumer.m_21190_(player.m_7655_()));
            player.m_36335_().m_41524_((Item)this, Helper.getOverheatCooldown(player) / 5 + pass / 5);
            player.m_6674_(player.m_7655_());
        }
    }

    public void m_5929_(Level level, LivingEntity user, ItemStack stack, int tick) {
        Vec3 view = user.m_20252_(0.0f).m_82490_(0.4);
        List entities = new ArrayList();
        double x = user.m_20185_();
        double z = user.m_20189_();
        double y = user.m_20188_() - 0.25;
        AABB box = new AABB(x - 0.2, y - 0.2, z - 0.2, x + 0.2, y + 0.2, z + 0.2);
        float rand = user.m_217043_().m_188501_();
        x += view.f_82479_ * (double)rand;
        z += view.f_82481_ * (double)rand;
        y += view.f_82480_ * (double)rand;
        for (int i = 1; i < 56 && (entities = level.m_6443_(LivingEntity.class, box, living -> living != user && user.m_6779_(living) && Helper.validTarget(user, living, 5.0))).isEmpty(); ++i) {
            box = box.m_82383_(view);
            x = ((view.f_82479_ + x) * 2.0 + (double)((user.m_217043_().m_188501_() - 0.5f) * 0.5f)) / 2.0;
            z = ((view.f_82481_ + z) * 2.0 + (double)((user.m_217043_().m_188501_() - 0.5f) * 0.5f)) / 2.0;
            y = ((view.f_82480_ + y) * 2.0 + (double)((user.m_217043_().m_188501_() - 0.5f) * 0.5f)) / 2.0;
            if (user.f_19797_ % 4 == 0) {
                if (level.m_5776_()) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123771_, x, y, z, 0.0, -0.5, 0.0);
                } else {
                    level.m_5594_(null, user.m_20183_(), SoundEvents.f_276532_, SoundSource.PLAYERS, 0.4f, 1.2f + 0.2f * user.m_217043_().m_188501_());
                }
            }
            if (level.m_8055_(BlockPos.m_274561_((double)x, (double)y, (double)z)).m_60815_()) break;
        }
        if (!entities.isEmpty() && !level.m_5776_()) {
            for (LivingEntity entity : entities) {
                int counter = entity.getPersistentData().m_128451_("ExtradimensionCounter");
                int add = 2 * Mth.m_14107_((double)Math.sqrt(Math.max(((double)user.m_21223_() + user.m_21051_(Attributes.f_22281_).m_22135_()) * 5.0, 0.0)));
                entity.getPersistentData().m_128405_("ExtradimensionCounter", counter + add);
                int healthCounter = Math.max(Mth.m_14143_((float)(entity.m_21223_() * 20.0f)), 200);
                if (counter <= healthCounter / 2) continue;
                entity.m_6469_(SuperAddonHandler.damageSource((Entity)entity, (ResourceKey<DamageType>)DamageTypes.f_268724_, (Entity)user), (float)(user.m_21204_().m_22181_(Attributes.f_22281_) / 4.0));
            }
        }
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        if (Helper.validTarget((LivingEntity)player, entity, 2.5) && Helper.validScepter(player, itemInHand)) {
            if (Helper.isCombatMode(stack) || player.m_6047_()) {
                return InteractionResult.PASS;
            }
            Level level = player.m_9236_();
            EntityType<?> type = Helper.getType(itemInHand);
            if (type == null) {
                return InteractionResult.FAIL;
            }
            if (!level.m_5776_()) {
                if (Helper.isValid(itemInHand)) {
                    return InteractionResult.FAIL;
                }
                CompoundTag storedEntityInfo = Helper.getInfo(itemInHand);
                Helper.setAll(itemInHand, storedEntityInfo, entity);
                entity.m_146870_();
                level.m_247517_(null, player.m_20183_(), SoundEvents.f_11757_, SoundSource.PLAYERS);
                itemInHand.m_41622_(2, (LivingEntity)player, consumer -> consumer.m_21190_(player.m_7655_()));
                player.m_36335_().m_41524_((Item)this, Helper.getTransCooldown(player));
                EnigmaticAddons.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 16.0, level.m_46472_())), (Object)new PacketExtradimensionParticles(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.m_20205_(), entity.m_20206_(), 1));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6880_(stack, player, entity, hand);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        ItemStack itemInHand = context.m_43722_();
        if (!Helper.isCombatMode(itemInHand) && context.m_43719_().equals((Object)Direction.UP) && Helper.validScepter(player, itemInHand)) {
            if (!Helper.isValid(itemInHand) || player.m_6047_()) {
                return InteractionResult.PASS;
            }
            EntityType<?> type = Helper.getType(itemInHand);
            if (type == null) {
                return InteractionResult.FAIL;
            }
            if (!level.m_5776_()) {
                player.m_36335_().m_41524_((Item)this, Helper.getTransCooldown(player));
                itemInHand.m_41622_(2, (LivingEntity)player, consumer -> consumer.m_21190_(player.m_7655_()));
                Entity entity = type.m_20615_(level);
                entity.m_20258_(Helper.getInfo(itemInHand));
                entity.m_146884_(context.m_43720_());
                entity.m_20256_(Vec3.f_82478_);
                level.m_7967_(entity);
                Helper.setValid(itemInHand, false);
                player.m_9236_().m_247517_(null, player.m_20183_(), SoundEvents.f_11757_, SoundSource.PLAYERS);
                EnigmaticAddons.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 16.0, level.m_46472_())), (Object)new PacketExtradimensionParticles(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.m_20205_(), entity.m_20206_(), 1));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 100;
    }

    public boolean m_6832_(ItemStack self, ItemStack stack) {
        return stack.m_150930_((Item)EnigmaticItems.EXTRADIMENSIONAL_EYE) || super.m_6832_(self, stack);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 24;
    }

    @SubscribeEvent
    public void onTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.m_9236_();
        if (!entity.m_6084_() || level.m_5776_()) {
            return;
        }
        int threshold = Math.max(Mth.m_14143_((float)(entity.m_21223_() * 20.0f)), 200);
        int counter = entity.getPersistentData().m_128451_("ExtradimensionCounter");
        if (counter > 0) {
            if (counter > threshold) {
                List entities = level.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(10.0), living -> entity.m_6779_(living) && Helper.validTarget(entity, living, 1.4) && !(living instanceof Player));
                entities.sort((living1, living2) -> Float.compare(living2.m_21223_(), living1.m_21223_()));
                List<LivingEntity> subList = entities.subList(0, Math.min(maxCombatCount.getValue(), entities.size()));
                if (!subList.contains(entity)) {
                    subList.add(entity);
                }
                level.m_5594_(null, entity.m_20183_(), SoundEvents.f_11757_, SoundSource.PLAYERS, 0.5f, 0.8f + 0.4f * entity.m_217043_().m_188501_());
                for (LivingEntity target : subList) {
                    PermanentItemEntity extra = new PermanentItemEntity(level, target.m_20185_(), target.m_20227_(0.5), target.m_20189_());
                    ItemStack stack = EnigmaticItems.EXTRADIMENSIONAL_EYE.m_7968_();
                    CompoundTag storedEntityInfo = Helper.getInfo(stack);
                    target.getPersistentData().m_128473_("ExtradimensionCounter");
                    Helper.setAll(stack, storedEntityInfo, target);
                    float damage = 0.0f;
                    LivingEntity lastAttacker = target.m_271686_();
                    if (lastAttacker != null && lastAttacker.m_21205_().m_150930_((Item)this)) {
                        damage = (float)lastAttacker.m_21051_(Attributes.f_22281_).m_22135_() / 2.0f;
                    }
                    float newHealth = Math.min(target.m_21223_() * 0.9f, target.m_21223_() - damage);
                    storedEntityInfo.m_128350_("Health", Math.max(newHealth, 0.5f));
                    stack.m_41784_().m_128365_("ExtradimensionalEntity", (Tag)storedEntityInfo);
                    extra.setItem(stack);
                    extra.m_6593_((Component)Component.m_237113_((String)"ExtradimensionalLockSpace"));
                    extra.getPersistentData().m_128405_("ExtradimensionalLockTimer", Mth.m_14107_((double)(Math.sqrt(threshold - 200) * 4.0)) + 120);
                    extra.m_20340_(false);
                    extra.setInfinitePickupDelay();
                    extra.m_20331_(true);
                    level.m_7967_((Entity)extra);
                    target.m_146870_();
                    EnigmaticAddons.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(target.m_20185_(), target.m_20186_(), target.m_20189_(), 16.0, level.m_46472_())), (Object)new PacketExtradimensionParticles(target.m_20185_(), target.m_20186_(), target.m_20189_(), target.m_20205_(), target.m_20206_(), 1));
                }
                return;
            }
            if ((counter = Math.max(0, counter - Math.max(1, Mth.m_14165_((double)Math.pow(threshold, 0.3))))) == 0) {
                entity.getPersistentData().m_128473_("ExtradimensionCounter");
            } else {
                entity.getPersistentData().m_128405_("ExtradimensionCounter", counter);
            }
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return slot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.getAttributeModifiers(slot, stack);
    }

    public static class Helper {
        public static int getTransCooldown(Player player) {
            return player.m_150110_().f_35937_ ? 5 : transportingCooldown.getValue();
        }

        public static int getOverheatCooldown(Player player) {
            return player.m_150110_().f_35937_ ? 20 : overheatingCooldown.getValue();
        }

        public static boolean validScepter(Player player, ItemStack stack) {
            return !player.m_36335_().m_41519_((Item)EnigmaticAddonItems.EXTRADIMENSIONAL_SCEPTER) && stack.m_41773_() < stack.m_41776_();
        }

        /*
         * Unable to fully structure code
         */
        public static boolean validTarget(LivingEntity from, LivingEntity to, double threshold) {
            if (!(from instanceof Player)) ** GOTO lbl-1000
            player = (Player)from;
            if (player.m_150110_().f_35937_) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            creative = v0;
            return to instanceof Player == false && (creative != false || (double)from.m_21223_() * threshold > (double)to.m_21223_());
        }

        public static boolean isCombatMode(ItemStack stack) {
            return stack.m_41782_() && stack.m_41783_().m_128471_("CombatMode");
        }

        public static void switchMode(ItemStack stack, Player player) {
            stack.m_41783_().m_128379_("CombatMode", !Helper.isCombatMode(stack));
            player.m_9236_().m_247517_(null, player.m_20183_(), Helper.isCombatMode(stack) ? EnigmaticSounds.CHARGED_ON : EnigmaticSounds.CHARGED_OFF, SoundSource.PLAYERS);
        }

        @Nullable
        public static EntityType<?> getType(ItemStack stack) {
            if (stack.m_41782_()) {
                String type = stack.m_41783_().m_128461_("ExtradimensionalType");
                EntityType value = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(type));
                if (value == null) {
                    Helper.setValid(stack, false);
                }
                return value;
            }
            return null;
        }

        public static CompoundTag getInfo(ItemStack stack) {
            return !stack.m_41782_() ? new CompoundTag() : stack.m_41783_().m_128469_("ExtradimensionalEntity");
        }

        public static boolean isValid(ItemStack stack) {
            return stack.m_41782_() && stack.m_41783_().m_128471_("ExtradimensionalValid");
        }

        public static void setValid(ItemStack stack, boolean valid) {
            stack.m_41784_().m_128379_("ExtradimensionalValid", valid);
            if (!valid) {
                stack.m_41783_().m_128473_("ExtradimensionalEntity");
            }
        }

        public static void setAll(ItemStack stack, CompoundTag tag, LivingEntity entity) {
            entity.m_20240_(tag);
            tag.m_128473_("UUID");
            stack.m_41784_().m_128365_("ExtradimensionalEntity", (Tag)tag);
            ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
            stack.m_41784_().m_128359_("ExtradimensionalType", key.toString());
            Helper.setValid(stack, true);
        }
    }
}

