/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import auviotre.enigmatic.addon.api.items.IBetrayed;
import auviotre.enigmatic.addon.handlers.SuperAddonHandler;
import auviotre.enigmatic.addon.registries.EnigmaticAddonDamageTypes;
import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import auviotre.enigmatic.addon.triggers.BlessRingEquippedTrigger;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.entities.PermanentItemEntity;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.CursedRing;
import com.aizistral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class BlessRing
extends ItemBaseCurio {
    public static final List<String> blessBetrayalList = new ArrayList<String>();
    public static final String CURSED_SPAWN = "CursedNextSpawn";
    public static final String BLESS_SPAWN = "BlessNextSpawn";
    public static final String WORTHY_SPAWN = "WorthyNextSpawn";
    public static final String BETRAYAL = "BlessBetrayal";
    public static final String BLESS_DURATION = "BlessDuration";
    public static final String CURSE_TIME_LEVEL = "SavedSevenCurseLevel";
    public static final int MAX_DURATION = 5;
    public static Omniconfig.PerhapsParameter damageResistance;
    public static Omniconfig.PerhapsParameter damageBoost;
    public static Omniconfig.IntParameter regenerationSpeed;

    public BlessRing() {
        super(ItemBaseCurio.getDefaultProperties().m_41497_(Rarity.EPIC).m_41486_());
        blessBetrayalList.add("enigmaticlegacy:astral_fruit");
        blessBetrayalList.add("enigmaticlegacy:twisted_mirror");
        blessBetrayalList.add("enigmaticlegacy:infernal_shield");
        blessBetrayalList.add("enigmaticlegacy:berserk_charm");
        blessBetrayalList.add("enigmaticlegacy:enchanter_pearl");
        blessBetrayalList.add("enigmaticlegacy:twisted_heart");
        blessBetrayalList.add("enigmaticlegacy:curse_transposer");
    }

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("RingofRedemption");
        damageResistance = builder.comment("The damage resistance of the Ring of Redemption. Measured in percentage.").min(0.0).max(100.0).getPerhaps("DamageResistance", 25);
        damageBoost = builder.comment("The damage boost of the Ring of Redemption. Measured in percentage.").min(0.0).max(500.0).getPerhaps("DamageBoost", 20);
        regenerationSpeed = builder.comment("The time required for each regeneration of Ring of Redemption. Measured in ticks.").min(5.0).getInt("RegenerationTick", 20);
        builder.popPrefix();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        if (Screen.m_96638_()) {
            int level = Helper.getBlessAttribute(stack, CURSE_TIME_LEVEL);
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.blessRing1");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.blessRing2");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.blessRing3", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{100.0f - (float)damageResistance.getValue().asPercentage() * Helper.getResistanceModifier(stack) + "%"});
            if (level > 1) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.blessRing4", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{(float)damageBoost.getValue().asPercentage() * Helper.getDamageModifier(stack) + "%"});
            }
            if (level > 1) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.blessRing5");
            }
            if (level > 2) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.blessRing6", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{Helper.getBonusLevel(stack, CursedRing.lootingBonus.getValue())});
            }
            if (level > 2) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.blessRing7", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{Helper.getBonusLevel(stack, CursedRing.fortuneBonus.getValue())});
            }
            if (level > 3) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.blessRing8");
            }
            if (level > 3) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.blessRing9");
            }
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            if (Helper.getBlessAttribute(stack, BLESS_DURATION) > 0) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.blessRingDuration", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{Helper.getBlessAttribute(stack, BLESS_DURATION)});
            }
            if (level > 4 && flagIn.m_7050_()) {
                list.add((Component)Component.m_237113_((String)(" [ " + Helper.getBlessAttribute(stack, BETRAYAL) + " / " + Helper.getMaxBetrayal(stack) + " ]")).m_130940_(ChatFormatting.GOLD));
            }
        } else {
            if (CursedRing.enableLore.getValue()) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.blessRingLore1");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.blessRingLore2");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.blessRingLore3");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.blessRingLore4");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            }
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.eternallyBound1");
            if (Minecraft.m_91087_().f_91074_ != null && SuperpositionHandler.canUnequipBoundRelics((Player)Minecraft.m_91087_().f_91074_)) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.eternallyBound2_creative");
            } else {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.eternallyBound2");
            }
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
        }
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, ItemStack stack) {
        tooltips.clear();
        return tooltips;
    }

    public boolean canUnequip(SlotContext context, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = context.entity();
        if (livingEntity instanceof Player && SuperpositionHandler.canUnequipBoundRelics((Player)(player = (Player)livingEntity))) {
            return super.canUnequip(context, stack);
        }
        return false;
    }

    public void onEquip(SlotContext context, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = context.entity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            BlessRingEquippedTrigger.INSTANCE.trigger(player);
        }
    }

    public void curioTick(SlotContext context, ItemStack stack) {
        Player player;
        boolean punish;
        LivingEntity entity = context.entity();
        if (Helper.getBlessAttribute(stack, CURSE_TIME_LEVEL) == 0) {
            if (entity instanceof Player) {
                Player player2 = (Player)entity;
                Helper.setBlessLevel(player2, stack);
            }
            Helper.setBlessAttribute(stack, CURSE_TIME_LEVEL, Math.min(6, Helper.getBlessAttribute(stack, CURSE_TIME_LEVEL) + 1));
        }
        boolean bl = punish = entity instanceof Player && SuperpositionHandler.hasCurio((LivingEntity)(player = (Player)entity), (Item)this) && SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticItems.CURSED_RING);
        if (entity instanceof Player && (SuperAddonHandler.isPunishedOne((LivingEntity)(player = (Player)entity)) || punish)) {
            SuperpositionHandler.setPersistentInteger((Player)player, (String)"Punishment", (int)(1 + SuperpositionHandler.getPersistentInteger((Player)player, (String)"Punishment", (int)0)));
            if (SuperpositionHandler.getPersistentInteger((Player)player, (String)"Punishment", (int)0) % 20 == 0) {
                player.m_5496_(SoundEvents.f_12513_, 0.6f, 0.0f);
                Level level = player.m_9236_();
                if (!level.m_5776_()) {
                    ServerPlayer serverPlayer;
                    LightningBolt lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_(player.m_9236_());
                    lightningBolt.m_20219_(Vec3.m_82539_((Vec3i)player.m_20183_()));
                    lightningBolt.setDamage(1.0f);
                    lightningBolt.m_20879_(player instanceof ServerPlayer ? (serverPlayer = (ServerPlayer)player) : null);
                    player.m_9236_().m_7967_((Entity)lightningBolt);
                    player.m_9236_().m_254951_((Entity)player, SuperAddonHandler.simpleSource((Entity)player, EnigmaticAddonDamageTypes.FALSE_JUSTICE), new ExplosionDamageCalculator(), player.m_20182_(), 2.0f, true, Level.ExplosionInteraction.BLOCK);
                }
                player.m_21153_(player.m_21233_());
                ItemStack soulCrystal = EnigmaticItems.SOUL_CRYSTAL.createCrystalFrom(player);
                PermanentItemEntity droppedSoulCrystal = new PermanentItemEntity(player.m_9236_(), player.m_20208_(10.0), player.m_20186_() + 1.5, player.m_20262_(10.0), soulCrystal);
                droppedSoulCrystal.setOwnerId(player.m_20148_());
                player.m_9236_().m_7967_((Entity)droppedSoulCrystal);
                player.m_150109_().m_6211_();
                CuriosApi.getCuriosInventory((LivingEntity)entity).ifPresent(curiosItemHandler -> {
                    IItemHandlerModifiable equippedCurios = curiosItemHandler.getEquippedCurios();
                    for (int i = 0; i < equippedCurios.getSlots(); ++i) {
                        if (equippedCurios.getStackInSlot(i).m_150930_((Item)this) || equippedCurios.getStackInSlot(i).m_150930_((Item)EnigmaticItems.CURSED_RING)) continue;
                        equippedCurios.setStackInSlot(i, ItemStack.f_41583_);
                    }
                });
            }
            if (SuperpositionHandler.getPersistentInteger((Player)player, (String)"Punishment", (int)0) > 100) {
                SuperpositionHandler.removePersistentTag((Player)player, (String)"Punishment");
                CuriosApi.getCuriosInventory((LivingEntity)entity).ifPresent(curiosItemHandler -> {
                    IItemHandlerModifiable equippedCurios = curiosItemHandler.getEquippedCurios();
                    for (int i = 0; i < equippedCurios.getSlots(); ++i) {
                        if (equippedCurios.getStackInSlot(i).m_150930_((Item)EnigmaticItems.CURSED_RING)) continue;
                        equippedCurios.setStackInSlot(i, ItemStack.f_41583_);
                    }
                });
                player.m_150109_().m_6211_();
                player.f_36080_ = 0.0f;
                player.f_36078_ = 0;
                int loss = EnigmaticItems.SOUL_CRYSTAL.getLostCrystals(player);
                for (int i = 0; i < 9 - loss; ++i) {
                    ItemStack soulCrystal = EnigmaticItems.SOUL_CRYSTAL.createCrystalFrom(player);
                    PermanentItemEntity droppedSoulCrystal = new PermanentItemEntity(player.m_9236_(), player.m_20208_(10.0), player.m_20186_() + 1.5, player.m_20262_(10.0), soulCrystal);
                    droppedSoulCrystal.setOwnerId(player.m_20148_());
                    player.m_9236_().m_7967_((Entity)droppedSoulCrystal);
                }
                player.m_6469_(player.m_269291_().m_269341_(), player.m_21233_() * 1000.0f);
                player.m_9236_().m_254951_((Entity)player, SuperAddonHandler.simpleSource((Entity)player, EnigmaticAddonDamageTypes.FALSE_JUSTICE), new ExplosionDamageCalculator(), player.m_20182_(), 32.0f, true, Level.ExplosionInteraction.BLOCK);
                player.m_6074_();
            }
        }
        if (entity instanceof Player) {
            player = (Player)entity;
            if (player.f_19797_ % 10 == 0 && !player.m_9236_().f_46443_) {
                AtomicInteger betrayal = new AtomicInteger(Helper.getBlessAttribute(stack, BETRAYAL));
                if (player.f_19797_ % 200 == 0 && betrayal.get() > 0) {
                    if (betrayal.get() > Helper.getMaxBetrayal(stack)) {
                        player.m_9236_().m_245747_(player.m_20183_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.6f, 0.8f, false);
                        player.m_213846_((Component)Component.m_237115_((String)"message.enigmaticaddons.blessRingBreak").m_130940_(ChatFormatting.GOLD));
                        Helper.setBlessAttribute(stack, BLESS_DURATION, Helper.getBlessAttribute(stack, BLESS_DURATION) + 1);
                        betrayal.set(0);
                    } else {
                        if (Helper.getBlessAttribute(stack, CURSE_TIME_LEVEL) == 6) {
                            betrayal.addAndGet(-player.m_217043_().m_188503_(2) - 2);
                        }
                        betrayal.addAndGet(-player.m_217043_().m_188503_(3) - 2);
                    }
                }
                if (Helper.isBetrayedItem(player.m_21205_())) {
                    betrayal.addAndGet(1);
                }
                if (Helper.isBetrayedItem(player.m_21206_())) {
                    betrayal.addAndGet(1);
                }
                CuriosApi.getCuriosInventory((LivingEntity)entity).ifPresent(curiosItemHandler -> {
                    IItemHandlerModifiable equippedCurios = curiosItemHandler.getEquippedCurios();
                    for (int i = 0; i < equippedCurios.getSlots(); ++i) {
                        ItemStack stackInSlot = equippedCurios.getStackInSlot(i);
                        if (!Helper.isBetrayedItem(stackInSlot)) continue;
                        betrayal.addAndGet(1);
                    }
                });
                Helper.setBlessAttribute(stack, BETRAYAL, Math.max(0, betrayal.get()));
            }
        }
        if (entity instanceof Player) {
            player = (Player)entity;
            if (Helper.getBlessAttribute(stack, BLESS_DURATION) >= 5) {
                player.m_5496_(SoundEvents.f_12513_, 0.6f, 0.0f);
                CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
                    IItemHandlerModifiable curios = handler.getEquippedCurios();
                    for (int i = 0; i < handler.getSlots() - 1; ++i) {
                        if (curios.getStackInSlot(i) == null || !curios.getStackInSlot(i).m_150930_((Item)this)) continue;
                        curios.setStackInSlot(i, EnigmaticAddonItems.BROKEN_RING.m_7968_());
                    }
                });
                SuperpositionHandler.destroyCurio((LivingEntity)player, (Item)EnigmaticAddonItems.BLESS_RING);
            }
        }
        if (Helper.getBlessAttribute(stack, CURSE_TIME_LEVEL) > 1 && entity.f_19797_ % regenerationSpeed.getValue() == 0 && entity.m_21223_() < entity.m_21233_() * 0.9f) {
            float delta = entity.m_21233_() * 0.9f - entity.m_21223_();
            entity.m_5634_(Math.max(delta / 20.0f * Helper.getRegenerationModifier(stack), 0.5f));
        }
    }

    public boolean canEquip(SlotContext context, ItemStack stack) {
        if (super.canEquip(context, stack)) {
            Player player;
            LivingEntity livingEntity = context.entity();
            return livingEntity instanceof Player && !SuperpositionHandler.isTheCursedOne((Player)(player = (Player)livingEntity)) && !SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.BROKEN_RING);
        }
        return false;
    }

    public boolean canEquipFromUse(SlotContext context, ItemStack stack) {
        return false;
    }

    public ICurio.DropRule getDropRule(SlotContext slotContext, DamageSource source, int lootingLevel, boolean recentlyHit, ItemStack stack) {
        return ICurio.DropRule.ALWAYS_KEEP;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        Map list = EnchantmentHelper.m_44831_((ItemStack)book);
        return !list.containsKey(Enchantments.f_44963_) && super.isBookEnchantable(stack, book);
    }

    public int getFortuneLevel(SlotContext slotContext, LootContext lootContext, ItemStack curio) {
        return super.getFortuneLevel(slotContext, lootContext, curio) + Helper.getBonusLevel(curio, CursedRing.fortuneBonus.getValue());
    }

    public int getLootingLevel(SlotContext slotContext, DamageSource source, LivingEntity target, int baseLooting, ItemStack curio) {
        return super.getLootingLevel(slotContext, source, target, baseLooting, curio) + Helper.getBonusLevel(curio, CursedRing.lootingBonus.getValue());
    }

    public boolean m_142522_(ItemStack stack) {
        return Helper.getBlessAttribute(stack, BETRAYAL) > 0;
    }

    public int m_142158_(ItemStack stack) {
        int max = Helper.getMaxBetrayal(stack);
        return Math.round(Math.max((float)(max - Helper.getBlessAttribute(stack, BETRAYAL)) * 13.0f / (float)max, 0.0f));
    }

    public int m_142159_(ItemStack stack) {
        return ChatFormatting.GOLD.m_126665_();
    }

    public static class Helper {
        public static final float[] BLESS_PROGRESSES = new float[]{0.0f, 10.0f, 25.0f, 45.0f, 75.0f, 99.5f, 200.0f};

        public static void setBlessLevel(Player player, ItemStack stack) {
            double suffering = SuperpositionHandler.getSufferingFraction((Player)player) * 100.0;
            int level = 0;
            while (suffering >= (double)BLESS_PROGRESSES[level]) {
                ++level;
            }
            Helper.setBlessAttribute(stack, BlessRing.CURSE_TIME_LEVEL, level);
        }

        public static boolean isBetrayedItem(ItemStack item) {
            ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)item.m_41720_());
            return item.m_41720_() instanceof IBetrayed || blessBetrayalList.contains(key.m_135827_() + ":" + key.m_135815_());
        }

        public static void addBetrayal(Player player, int count) {
            ItemStack stack = SuperpositionHandler.getCurioStack((LivingEntity)player, (Item)EnigmaticAddonItems.BLESS_RING);
            if (stack != null && !stack.m_41619_()) {
                Helper.setBlessAttribute(stack, BlessRing.BETRAYAL, count + Helper.getBlessAttribute(stack, BlessRing.BETRAYAL));
            }
        }

        public static int getMaxBetrayal(ItemStack stack) {
            int extra = 0;
            if (Helper.getBlessAttribute(stack, BlessRing.CURSE_TIME_LEVEL) == 6) {
                extra += 350;
            }
            return 1250 - Helper.getBlessAttribute(stack, BlessRing.BLESS_DURATION) * 100 + extra;
        }

        public static int getBlessAttribute(ItemStack stack, String id) {
            if (stack == null || stack.m_41619_()) {
                return 0;
            }
            return !stack.m_41782_() ? 0 : stack.m_41783_().m_128451_(id);
        }

        public static void setBlessAttribute(ItemStack stack, String id, int value) {
            stack.m_41784_().m_128405_(id, value);
        }

        public static float getResistanceModifier(ItemStack stack) {
            int level = Helper.getBlessAttribute(stack, BlessRing.CURSE_TIME_LEVEL);
            return Math.min(0.2f * (float)level, 1.0f);
        }

        public static float getDamageModifier(ItemStack stack) {
            int level = Helper.getBlessAttribute(stack, BlessRing.CURSE_TIME_LEVEL);
            if (level > 1) {
                return Math.min(0.25f * (float)(level - 1), 1.0f);
            }
            return 0.0f;
        }

        public static int getBonusLevel(ItemStack stack, int origin) {
            int level = Helper.getBlessAttribute(stack, BlessRing.CURSE_TIME_LEVEL);
            if (level == 6) {
                return origin;
            }
            if (level > 2) {
                return (origin + 1) / 2;
            }
            return 0;
        }

        public static float getRegenerationModifier(ItemStack stack) {
            int level = Helper.getBlessAttribute(stack, BlessRing.CURSE_TIME_LEVEL);
            if (level > 1) {
                return Math.min(0.25f * (float)(level - 1), 1.25f);
            }
            return 0.0f;
        }

        public static boolean specialLooting(Player player) {
            if (!SuperAddonHandler.isTheBlessedOne(player)) {
                return false;
            }
            ItemStack stack = SuperpositionHandler.getCurioStack((LivingEntity)player, (Item)EnigmaticAddonItems.BLESS_RING);
            if (stack != null && !stack.m_41619_()) {
                return Helper.getBlessAttribute(stack, BlessRing.CURSE_TIME_LEVEL) > 3;
            }
            return false;
        }

        public static boolean blessAvailable(Player player) {
            if (!SuperAddonHandler.isTheBlessedOne(player)) {
                return false;
            }
            ItemStack blessRing = SuperpositionHandler.getCurioStack((LivingEntity)player, (Item)EnigmaticAddonItems.BLESS_RING);
            return Helper.getBlessAttribute(blessRing, BlessRing.CURSE_TIME_LEVEL) > 3;
        }

        public static boolean betrayalAvailable(Player player) {
            if (!SuperAddonHandler.isTheBlessedOne(player)) {
                return false;
            }
            ItemStack blessRing = SuperpositionHandler.getCurioStack((LivingEntity)player, (Item)EnigmaticAddonItems.BLESS_RING);
            return Helper.getBlessAttribute(blessRing, BlessRing.CURSE_TIME_LEVEL) > 4;
        }
    }

    public static class Broken
    extends ItemBaseCurio {
        public Broken() {
            super(ItemBaseCurio.getDefaultProperties().m_41497_(Rarity.RARE).m_41486_());
        }

        @OnlyIn(value=Dist.CLIENT)
        public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedFormattedString(list, (String)"curios.modifiers.ring", (ChatFormatting)ChatFormatting.GOLD);
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.blessRing3", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{"90%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.cursedRing9");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.eternallyBound1");
            if (Minecraft.m_91087_().f_91074_ != null && SuperpositionHandler.canUnequipBoundRelics((Player)Minecraft.m_91087_().f_91074_)) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.eternallyBound2_creative");
            } else {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.eternallyBound2");
            }
        }

        public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
            Map list = EnchantmentHelper.m_44831_((ItemStack)book);
            return !list.containsKey(Enchantments.f_44963_) && super.isBookEnchantable(stack, book);
        }

        public boolean canUnequip(SlotContext context, ItemStack stack) {
            Player player;
            LivingEntity livingEntity = context.entity();
            if (livingEntity instanceof Player && SuperpositionHandler.canUnequipBoundRelics((Player)(player = (Player)livingEntity))) {
                return super.canUnequip(context, stack);
            }
            return false;
        }

        public boolean canEquip(SlotContext context, ItemStack stack) {
            if (super.canEquip(context, stack)) {
                Player player;
                LivingEntity livingEntity = context.entity();
                return livingEntity instanceof Player && !SuperAddonHandler.isTheBlessedOne(player = (Player)livingEntity);
            }
            return false;
        }

        public CreativeModeTab getCreativeTab() {
            return null;
        }
    }
}

