/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import auviotre.enigmatic.addon.contents.entities.ThrownAstralSpear;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.api.materials.EnigmaticMaterials;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBase;
import com.aizistral.enigmaticlegacy.registries.EnigmaticEnchantments;
import com.aizistral.enigmaticlegacy.registries.EnigmaticSounds;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;

public class AstralSpear
extends ItemBase
implements Vanishable {
    public static Omniconfig.DoubleParameter poweredModifier;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;
    private boolean soundPlayed1 = false;
    private boolean soundPlayed2 = false;
    private boolean soundPlayed3 = false;

    public AstralSpear() {
        super(ItemBase.getDefaultProperties().m_41497_(Rarity.EPIC).m_41487_(1).m_41503_(3000).m_41486_());
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 13.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)-3.1f, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    @SubscribeConfig
    public static void onConfig(@NotNull OmniconfigWrapper builder) {
        builder.pushPrefix("AstralSpear");
        poweredModifier = builder.comment("The damage modifier when spear is powered.").max(100.0).min(0.0).getDouble("PoweredModifier", 2.5);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.astralSpear1");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.astralSpear2");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.astralSpear3");
        } else {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
        }
        if (stack.m_41793_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        }
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack stack, int tickCount) {
        if (!level.f_46443_) {
            int duration = this.m_8105_(stack) - tickCount;
            if (duration >= 60 && !this.soundPlayed3) {
                this.soundPlayed3 = true;
                level.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), EnigmaticSounds.CHARGED_ON, SoundSource.PLAYERS, 2.5f, 1.5f);
            }
            if (duration >= 50 && !this.soundPlayed2) {
                this.soundPlayed2 = true;
                level.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), EnigmaticSounds.CHARGED_ON, SoundSource.PLAYERS, 2.5f, 1.25f);
            }
            if (duration >= 38 && !this.soundPlayed1) {
                this.soundPlayed1 = true;
                level.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), EnigmaticSounds.CHARGED_ON, SoundSource.PLAYERS, 2.5f, 1.0f);
            }
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int tickCount) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int duration = this.m_8105_(stack) - tickCount;
            if (duration >= 12) {
                stack.m_41622_(duration >= 60 ? 5 : 2, (LivingEntity)player, consumer -> consumer.m_21190_(entity.m_7655_()));
                if (!level.f_46443_) {
                    ThrownAstralSpear spear = new ThrownAstralSpear((LivingEntity)player, level, stack);
                    float strength = Mth.m_14036_((float)((float)(duration - 8) / 12.0f), (float)0.0f, (float)1.0f);
                    spear.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
                    if (duration >= 60) {
                        spear.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 4.5f, 1.1f);
                        spear.setPowered(true);
                    } else {
                        spear.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 2.5f + strength, 1.0f);
                    }
                    level.m_7967_((Entity)spear);
                }
                level.m_6269_(null, (Entity)entity, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.5f);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                player.m_6674_(player.m_7655_());
            }
        }
        this.soundPlayed3 = false;
        this.soundPlayed2 = false;
        this.soundPlayed1 = false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        if (itemInHand.m_41773_() >= itemInHand.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemInHand);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemInHand);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity entity, LivingEntity user) {
        stack.m_41622_(2, user, consumer -> consumer.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        if (state.m_60800_((BlockGetter)level, pos) != 0.0f) {
            stack.m_41622_(2, entity, p_43276_ -> p_43276_.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return slot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.getAttributeModifiers(slot, stack);
    }

    public boolean m_6832_(ItemStack stack, ItemStack material) {
        return EnigmaticMaterials.getEtheriumConfig().getRepairMaterial().test(material);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        boolean curse = enchantment == Enchantments.f_44963_ || enchantment == EnigmaticEnchantments.NEMESIS;
        return enchantment == Enchantments.f_44961_ || curse || super.canApplyAtEnchantingTable(Items.f_42383_.m_7968_(), enchantment);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 20;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return super.canPerformAction(stack, toolAction) || ToolActions.DEFAULT_SWORD_ACTIONS.contains(toolAction);
    }

    @NotNull
    public AABB getSweepHitBox(@NotNull ItemStack stack, @NotNull Player player, @NotNull Entity target) {
        return target.m_20191_().m_82377_(2.0, 0.3, 2.0);
    }
}

