/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.api.spells.SignSequence;
import elucent.eidolon.api.spells.Spell;
import elucent.eidolon.registries.EidolonRecipes;
import elucent.eidolon.registries.Signs;
import elucent.eidolon.registries.Spells;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChantRecipe
implements Recipe<Container> {
    ResourceLocation id;
    List<Sign> signs;

    public ChantRecipe(ResourceLocation id, List<Sign> signs) {
        this.id = id;
        this.signs = signs;
    }

    public boolean m_5818_(@NotNull Container container, @NotNull Level level) {
        return false;
    }

    @NotNull
    public ItemStack m_5874_(@NotNull Container container, @NotNull RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int i, int i1) {
        return false;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)EidolonRecipes.CHANT_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)EidolonRecipes.CHANT_TYPE.get();
    }

    public Spell getChant() {
        return Spells.find(this.id);
    }

    public boolean matches(@NotNull SignSequence signs) {
        return signs.equals(new SignSequence(this.signs));
    }

    public Sign[] signs() {
        return this.signs.toArray(new Sign[0]);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.m_6671_().toString());
        JsonArray signsArray = new JsonArray();
        for (Sign sign : this.signs) {
            signsArray.add(sign.getRegistryName().toString());
        }
        json.add("signs", (JsonElement)signsArray);
        return json;
    }

    public static class Serializer
    implements RecipeSerializer<ChantRecipe> {
        @NotNull
        public ChantRecipe fromJson(@NotNull ResourceLocation resourceLocation, @NotNull JsonObject jsonObject) {
            JsonArray signsArray = jsonObject.getAsJsonArray("signs");
            ArrayList<Sign> signs = new ArrayList<Sign>();
            for (JsonElement sign : signsArray) {
                signs.add(Signs.find(new ResourceLocation(sign.getAsString())));
            }
            return new ChantRecipe(resourceLocation, signs);
        }

        @Nullable
        public ChantRecipe fromNetwork(@NotNull ResourceLocation resourceLocation, @NotNull FriendlyByteBuf friendlyByteBuf) {
            int n = friendlyByteBuf.readInt();
            ArrayList<Sign> signs = new ArrayList<Sign>();
            for (int i = 0; i < n; ++i) {
                signs.add(Signs.find(friendlyByteBuf.m_130281_()));
            }
            return new ChantRecipe(resourceLocation, signs);
        }

        public void toNetwork(@NotNull FriendlyByteBuf friendlyByteBuf, @NotNull ChantRecipe chantRecipe) {
            friendlyByteBuf.writeInt(chantRecipe.signs.size());
            for (Sign sign : chantRecipe.signs) {
                friendlyByteBuf.m_130085_(sign.getRegistryName());
            }
        }
    }
}

