/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.network;

import elucent.eidolon.capability.IPlayerData;
import elucent.eidolon.network.FeatherEffectPacket;
import elucent.eidolon.network.Networking;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class WingsFlapPacket {
    final UUID uuid;

    public WingsFlapPacket(Player player) {
        this.uuid = player.m_20148_();
    }

    public WingsFlapPacket(UUID uuid) {
        this.uuid = uuid;
    }

    public static void encode(WingsFlapPacket object, FriendlyByteBuf buffer) {
        buffer.m_130077_(object.uuid);
    }

    public static WingsFlapPacket decode(FriendlyByteBuf buffer) {
        return new WingsFlapPacket(buffer.m_130259_());
    }

    public static void consume(WingsFlapPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            assert (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_SERVER);
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender == null) {
                return;
            }
            Level world = sender.f_19853_;
            Player player = world.m_46003_(packet.uuid);
            if (player != null) {
                player.getCapability(IPlayerData.INSTANCE).ifPresent(d -> d.tryFlapWings(player));
                BlockPos pos = player.m_20097_();
                Networking.sendToTracking(world, pos, new FeatherEffectPacket(pos));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

