/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.network;

import elucent.eidolon.Eidolon;
import java.util.function.Supplier;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class ChilledEffectPacket {
    final double x;
    final double y;
    final double z;

    public ChilledEffectPacket(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void encode(ChilledEffectPacket object, FriendlyByteBuf buffer) {
        buffer.writeDouble(object.x);
        buffer.writeDouble(object.y);
        buffer.writeDouble(object.z);
    }

    public static ChilledEffectPacket decode(FriendlyByteBuf buffer) {
        return new ChilledEffectPacket(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
    }

    public static void consume(ChilledEffectPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            assert (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT);
            Player player = Eidolon.proxy.getPlayer();
            if (player != null) {
                Level world = player.f_19853_;
                world.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11983_, SoundSource.PLAYERS, 1.0f, 1.0f);
                for (int i = 0; i < 5; ++i) {
                    world.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50126_.m_49966_()), packet.x, packet.y, packet.z, (double)0.05f * world.f_46441_.m_188583_(), (double)0.05f * world.f_46441_.m_188583_(), (double)0.05f * world.f_46441_.m_188583_());
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

