/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.item;

import elucent.eidolon.client.ClientRegistry;
import elucent.eidolon.common.item.model.TopHatModel;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public class TopHatItem
extends ArmorItem {
    private static final int[] MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
    String loreTag = null;

    public Item setLore(String tag) {
        this.loreTag = tag;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        if (this.loreTag != null) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.DARK_PURPLE) + String.valueOf(ChatFormatting.ITALIC) + I18n.m_118938_((String)this.loreTag, (Object[])new Object[0]))));
        }
    }

    public TopHatItem(Item.Properties builderIn) {
        super((ArmorMaterial)Material.INSTANCE, ArmorItem.Type.HELMET, builderIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            @NotNull
            public TopHatModel getHumanoidArmorModel(LivingEntity entity, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel _default) {
                float pticks = Minecraft.m_91087_().m_91296_();
                float f = Mth.m_14189_((float)pticks, (float)entity.f_20884_, (float)entity.f_20883_);
                float f1 = Mth.m_14189_((float)pticks, (float)entity.f_20886_, (float)entity.f_20885_);
                float netHeadYaw = f1 - f;
                float netHeadPitch = Mth.m_14179_((float)pticks, (float)entity.f_19860_, (float)entity.m_146909_());
                ClientRegistry.TOP_HAT_MODEL.slot = TopHatItem.this.m_40402_();
                ClientRegistry.TOP_HAT_MODEL.copyFromDefault(_default);
                ClientRegistry.TOP_HAT_MODEL.m_6973_(entity, entity.f_267362_.m_267756_(), entity.f_267362_.m_267731_(), (float)entity.f_19797_ + pticks, netHeadYaw, netHeadPitch);
                return ClientRegistry.TOP_HAT_MODEL;
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "eidolon:textures/entity/hat.png";
    }

    public static class Material
    implements ArmorMaterial {
        public static final Material INSTANCE = new Material();

        public int m_266425_(ArmorItem.Type slot) {
            return MAX_DAMAGE_ARRAY[slot.m_266308_().m_20749_()] * 7;
        }

        public int m_7366_(@NotNull ArmorItem.Type slot) {
            return 1;
        }

        public int m_6646_() {
            return 12;
        }

        @NotNull
        public SoundEvent m_7344_() {
            return ArmorMaterials.LEATHER.m_7344_();
        }

        @NotNull
        public Ingredient m_6230_() {
            return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_41938_)});
        }

        @NotNull
        public String m_6082_() {
            return "eidolon:top_hat";
        }

        public float m_6651_() {
            return 0.0f;
        }

        public float m_6649_() {
            return 0.0f;
        }
    }
}

