/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.block;

import elucent.eidolon.common.block.BlockBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class CandlestickBlock
extends BlockBase {
    public static final DirectionProperty FACING = DirectionProperty.m_61546_((String)"facing", d -> d != Direction.DOWN);
    protected static final VoxelShape UP_SHAPE = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)14.0, (double)10.0);
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.m_49796_((double)5.5, (double)3.0, (double)11.0, (double)10.5, (double)16.0, (double)16.0), Block.m_49796_((double)5.5, (double)3.0, (double)0.0, (double)10.5, (double)16.0, (double)5.0), Block.m_49796_((double)11.0, (double)3.0, (double)5.5, (double)16.0, (double)16.0, (double)10.5), Block.m_49796_((double)0.0, (double)3.0, (double)5.5, (double)5.0, (double)16.0, (double)10.5)};

    public CandlestickBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static VoxelShape getShapeForState(BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        if (dir == Direction.UP) {
            return UP_SHAPE;
        }
        return SHAPES[dir.ordinal() - 2];
    }

    @Override
    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return CandlestickBlock.getShapeForState(state);
    }

    @Override
    @NotNull
    public VoxelShape m_5939_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Shapes.m_83040_();
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockpos = pos.m_121945_(direction.m_122424_());
        BlockState blockstate = worldIn.m_8055_(blockpos);
        return blockstate.m_60783_((BlockGetter)worldIn, blockpos, direction);
    }

    @NotNull
    public BlockState m_7417_(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        if (direction == Direction.UP) {
            return facing == Direction.DOWN && !this.m_7898_(state, (LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, worldIn, currentPos, facingPos);
        }
        return facing.m_122424_() == state.m_61143_((Property)FACING) && !state.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : state;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction[] adirection;
        BlockState blockstate = this.m_49966_();
        Level iworldreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        for (Direction direction : adirection = context.m_6232_()) {
            Direction direction1;
            if (direction == Direction.UP || !(blockstate = (BlockState)blockstate.m_61124_((Property)FACING, (Comparable)(direction1 = direction.m_122424_()))).m_60710_((LevelReader)iworldreader, blockpos)) continue;
            return blockstate;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, @NotNull Level worldIn, BlockPos pos, @NotNull RandomSource rand) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        double d0 = (double)pos.m_123341_() + 0.5;
        double d1 = (double)pos.m_123342_() + 0.925;
        double d2 = (double)pos.m_123343_() + 0.5;
        if (direction != Direction.UP) {
            d0 -= 0.3 * (double)direction.m_122429_();
            d1 += 0.125;
            d2 -= 0.3 * (double)direction.m_122431_();
        }
        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 0.0, 0.0);
        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    @NotNull
    public BlockState m_6843_(BlockState state, @NotNull Rotation rot) {
        return state.m_61143_((Property)FACING) != Direction.UP ? (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING))) : state;
    }

    @NotNull
    public BlockState m_6943_(BlockState state, @NotNull Mirror mirrorIn) {
        return state.m_61143_((Property)FACING) != Direction.UP ? state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING))) : state;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }
}

