/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.codex;

import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.api.spells.Spell;
import elucent.eidolon.codex.ChantPage;
import elucent.eidolon.codex.Chapter;
import elucent.eidolon.codex.CraftingPage;
import elucent.eidolon.codex.CruciblePage;
import elucent.eidolon.codex.EntityPage;
import elucent.eidolon.codex.ListPage;
import elucent.eidolon.codex.Page;
import elucent.eidolon.codex.SignPage;
import elucent.eidolon.codex.SmeltingPage;
import elucent.eidolon.codex.TextPage;
import elucent.eidolon.codex.TitlePage;
import elucent.eidolon.codex.TitledRitualPage;
import elucent.eidolon.codex.WorktablePage;
import elucent.eidolon.recipe.CrucibleRecipe;
import elucent.eidolon.recipe.WorktableRecipe;
import elucent.eidolon.util.RegistryUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CodexBuilder {
    private String titleKey;
    private final List<Page> pages = new ArrayList<Page>();
    private Level level;

    public CodexBuilder(Level level) {
        this.level = level;
    }

    public CodexBuilder() {
    }

    public CodexBuilder addSupportedRecipePages(ItemLike item) {
        ResourceLocation key = RegistryUtil.getRegistryName(item);
        if (key == null) {
            return this;
        }
        return this.addSupportedRecipePages(key);
    }

    public CodexBuilder addSupportedRecipePages(ResourceLocation recipeId) {
        if (this.level == null) {
            throw new IllegalStateException("Level is not initialized. Use the constructor with Level parameter.");
        }
        RecipeManager recipeManager = this.level.m_7465_();
        recipeManager.m_44043_(recipeId).ifPresent(recipe -> {
            if (recipe instanceof CraftingRecipe) {
                this.pages.add(new CraftingPage(recipe.m_8043_(this.level.m_9598_()), recipe.m_6423_()));
            } else if (recipe instanceof SmeltingRecipe) {
                SmeltingRecipe smeltingRecipe = (SmeltingRecipe)recipe;
                this.pages.add(new SmeltingPage(recipe.m_8043_(this.level.m_9598_()), ((Ingredient)smeltingRecipe.m_7527_().get(0)).m_43908_()[0], recipe.m_6423_()));
            } else if (recipe instanceof WorktableRecipe) {
                this.pages.add(new WorktablePage(recipe.m_8043_(this.level.m_9598_())));
            } else if (recipe instanceof CrucibleRecipe) {
                CrucibleRecipe crucibleRecipe = (CrucibleRecipe)recipe;
                this.pages.add(new CruciblePage(recipe.m_8043_(this.level.m_9598_()), crucibleRecipe.m_6423_()));
            }
        });
        return this;
    }

    public CodexBuilder title(String titleKey) {
        this.titleKey = titleKey;
        return this;
    }

    public CodexBuilder titlePage(String textKey) {
        this.addTextPages(textKey, ItemStack.f_41583_, true);
        return this;
    }

    public CodexBuilder titlePage(String textKey, ItemStack reference) {
        this.addTextPages(textKey, reference, true);
        return this;
    }

    public CodexBuilder entityPage(EntityType<?> entity) {
        this.pages.add(new EntityPage(entity));
        return this;
    }

    public CodexBuilder craftingPage(ItemLike output) {
        this.pages.add(new CraftingPage(output.m_5456_().m_7968_()));
        return this;
    }

    public CodexBuilder craftingPage(ItemStack output) {
        this.pages.add(new CraftingPage(output));
        return this;
    }

    public CodexBuilder craftingPage(ItemStack output, ResourceLocation recipeId) {
        this.pages.add(new CraftingPage(output, recipeId));
        return this;
    }

    public CodexBuilder smeltingPage(ItemStack output, ItemStack input) {
        this.pages.add(new SmeltingPage(output, input));
        return this;
    }

    public CodexBuilder smeltingPage(ItemStack output, ItemStack input, ResourceLocation recipeId) {
        this.pages.add(new SmeltingPage(output, input, recipeId));
        return this;
    }

    public CodexBuilder worktablePage(ItemLike output) {
        this.pages.add(new WorktablePage(output.m_5456_().m_7968_()));
        return this;
    }

    public CodexBuilder worktablePage(ItemStack output) {
        this.pages.add(new WorktablePage(output));
        return this;
    }

    public CodexBuilder cruciblePage(ItemLike output) {
        this.pages.add(new CruciblePage(output.m_5456_().m_7968_()));
        return this;
    }

    public CodexBuilder cruciblePage(ItemStack output) {
        this.pages.add(new CruciblePage(output));
        return this;
    }

    public CodexBuilder cruciblePage(ItemStack output, ResourceLocation recipeId) {
        this.pages.add(new CruciblePage(output, recipeId));
        return this;
    }

    public CodexBuilder chantPage(String textKey, Spell spell) {
        this.pages.add(new ChantPage(textKey, spell));
        return this;
    }

    public CodexBuilder titledRitualPage(String textKey, ResourceLocation ritualId) {
        this.pages.add(new TitledRitualPage(textKey, ritualId));
        return this;
    }

    public CodexBuilder titledRitualPage(String textKey, ItemStack ritualResult) {
        this.pages.add(new TitledRitualPage(textKey, ritualResult));
        return this;
    }

    public CodexBuilder titledRitualPage(String textKey, Ritual ritual) {
        this.pages.add(new TitledRitualPage(textKey, ritual));
        return this;
    }

    public CodexBuilder listPage(String textKey, ListPage.ListEntry ... entries) {
        this.pages.add(new ListPage(textKey, entries));
        return this;
    }

    public CodexBuilder signPage(Sign sign) {
        this.pages.add(new SignPage(sign));
        return this;
    }

    public Chapter build() {
        if (this.titleKey == null) {
            throw new IllegalStateException("Chapter must have a title.");
        }
        return new Chapter(this.titleKey, this.pages.toArray(new Page[0]));
    }

    public CodexBuilder textPage(String translationKey) {
        this.addTextPages(translationKey, ItemStack.f_41583_, false);
        return this;
    }

    private void addTextPages(String translationKey, ItemStack icon, boolean isTitlePage) {
        MutableComponent text = Component.m_237115_((String)translationKey);
        String rawText = text.getString();
        String[] sentences = rawText.split("(?<=[.!?])\\s+");
        ArrayList<String> lines = new ArrayList<String>();
        for (String sentence : sentences) {
            List<String> sentenceLines = Page.wrapTextToLines(sentence, 120);
            lines.addAll(sentenceLines);
        }
        int linesPerPage = isTitlePage ? 12 : 13;
        int totalLines = lines.size();
        int pagesNeeded = (int)Math.ceil((double)totalLines / (double)linesPerPage);
        for (int i = 0; i < pagesNeeded; ++i) {
            int startLine = i * linesPerPage;
            int endLine = Math.min((i + 1) * linesPerPage, totalLines);
            List pageLines = lines.subList(startLine, endLine);
            String pageText = String.join((CharSequence)" ", pageLines);
            if (i == 0 && isTitlePage) {
                this.pages.add(icon.m_41619_() ? new TitlePage(pageText, translationKey + ".title") : new TitlePage(pageText, icon));
                continue;
            }
            this.pages.add(new TextPage(pageText));
        }
    }
}

