/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.deathlog.storage;

import com.glisco.deathlog.client.DeathInfo;
import com.glisco.deathlog.storage.DeathLogStorage;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseDeathLogStorage
implements DeathLogStorage {
    private static final int FORMAT_REVISION = 2;
    public static final Logger LOGGER = LogManager.getLogger();
    private boolean errored = false;
    private String errorCondition = "";

    protected CompletableFuture<List<DeathInfo>> load(File file) {
        CompletableFuture<List<DeathInfo>> future = new CompletableFuture<List<DeathInfo>>();
        class_156.method_27958().submit(() -> {
            class_2487 deathNbt;
            block6: {
                if (this.errored) {
                    LOGGER.warn("Attempted to load DeathLog database even though disk operations are disabled");
                    future.complete(null);
                    return;
                }
                if (file.exists()) {
                    try {
                        deathNbt = class_2507.method_10633((File)file);
                        if (deathNbt.method_10550("FormatRevision") != 2) {
                            this.raiseError("Incompatible format");
                            LOGGER.error("Incompatible DeathLog database format detected. Database not loaded and further disk operations disabled");
                            future.complete(null);
                            return;
                        }
                        break block6;
                    }
                    catch (IOException e) {
                        this.raiseError("Disk access failed");
                        e.printStackTrace();
                        LOGGER.error("Failed to load DeathLog database, further disk operations have been disabled");
                        future.completeExceptionally(e);
                        return;
                    }
                }
                deathNbt = new class_2487();
            }
            ArrayList<DeathInfo> list = new ArrayList<DeathInfo>();
            class_2499 infoList = deathNbt.method_10554("Deaths", 9);
            for (int i = 0; i < infoList.size(); ++i) {
                list.add(DeathInfo.readFromNbt(infoList.method_10603(i)));
            }
            future.complete(list);
        });
        return future;
    }

    protected void save(File file, List<DeathInfo> listIn) {
        ImmutableList list = ImmutableList.copyOf(listIn);
        class_156.method_27958().submit(() -> {
            if (this.errored) {
                LOGGER.warn("Attempted to save DeathLog database even though disk operations are disabled");
                return;
            }
            class_2487 deathNbt = new class_2487();
            class_2499 infoList = new class_2499();
            list.forEach(deathInfo -> infoList.add((Object)deathInfo.writeNbt()));
            deathNbt.method_10566("Deaths", (class_2520)infoList);
            deathNbt.method_10569("FormatRevision", 2);
            try {
                class_2507.method_10630((class_2487)deathNbt, (File)file);
            }
            catch (IOException e) {
                e.printStackTrace();
                LOGGER.error("Failed to save DeathLog database");
            }
        });
    }

    @Override
    public boolean isErrored() {
        return this.errored;
    }

    @Override
    public String getErrorCondition() {
        return this.errorCondition;
    }

    protected void raiseError(String error) {
        this.errored = true;
        this.errorCondition = error;
    }
}

