/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.deathlog.network;

import com.glisco.deathlog.client.DeathInfo;
import com.glisco.deathlog.network.DeathLogPackets;
import com.glisco.deathlog.storage.BaseDeathLogStorage;
import com.glisco.deathlog.storage.DirectDeathLogStorage;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class RemoteDeathLogStorage
extends BaseDeathLogStorage
implements DirectDeathLogStorage {
    private final List<DeathInfo> deathInfoList;
    private final UUID profileId;

    public RemoteDeathLogStorage(List<DeathInfo> deathInfoList, UUID profileId) {
        this.deathInfoList = deathInfoList;
        this.profileId = profileId;
    }

    public static RemoteDeathLogStorage read(class_2540 buffer) {
        List infos = buffer.method_34066(DeathInfo::read);
        UUID id = buffer.method_10790();
        return new RemoteDeathLogStorage(infos, id);
    }

    @Override
    public List<DeathInfo> getDeathInfoList(@Nullable UUID profile) {
        return this.deathInfoList;
    }

    @Override
    public void delete(DeathInfo info, @Nullable UUID profile) {
        int index = this.deathInfoList.indexOf(info);
        DeathLogPackets.Client.requestDeletion(this.profileId, index);
        this.deathInfoList.remove(info);
    }

    @Override
    public void store(class_2561 deathMessage, class_1657 player) {
    }

    @Override
    public void restore(int index, @Nullable UUID profile) {
        DeathLogPackets.Client.requestRestore(this.profileId, index);
    }

    public void fetchCompleteInfo(DeathInfo info) {
        if (!info.isPartial()) {
            return;
        }
        int idx = this.getDeathInfoList().indexOf(info);
        DeathLogPackets.Client.fetchInfo(this.profileId, idx);
    }

    @Override
    public String getDefaultFilter() {
        return "Server";
    }
}

