/*
 * Decompiled with CFR 0.152.
 */
package net.pttheta.loveandwar.recipe;

import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeSerializer;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.pttheta.loveandwar.recipe.petrochemical.FractionalDistillationRecipe;
import net.pttheta.loveandwar.recipe.petrochemical.ReactionRecipe;
import org.jetbrains.annotations.Nullable;

public enum RecipeRegister implements IRecipeTypeInfo
{
    REACTION(ReactionRecipe::new),
    FRACTIONAL_DISTILLATION(FractionalDistillationRecipe::new);

    private final ResourceLocation id = new ResourceLocation("createloveandwar");
    private final RegistryObject<RecipeSerializer<?>> serializerObject;
    @Nullable
    private final RegistryObject<RecipeType<?>> typeObject;
    private final Supplier<RecipeType<?>> type;

    private RecipeRegister(Supplier serializerSupplier) {
        String name = CreateLang.asId((String)this.name());
        this.serializerObject = Registers.SERIALIZER_REGISTER.register(name, serializerSupplier);
        this.typeObject = Registers.TYPE_REGISTER.register(name, () -> RecipeType.simple((ResourceLocation)this.id));
        this.type = this.typeObject;
    }

    private RecipeRegister(ProcessingRecipeBuilder.ProcessingRecipeFactory processingFactory) {
        this(() -> new ProcessingRecipeSerializer(processingFactory));
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public <T extends RecipeSerializer<?>> T getSerializer() {
        return (T)((RecipeSerializer)this.serializerObject.get());
    }

    public <T extends RecipeType<?>> T getType() {
        return (T)this.type.get();
    }

    public static void register(IEventBus modEventBus) {
        Registers.SERIALIZER_REGISTER.register(modEventBus);
        Registers.TYPE_REGISTER.register(modEventBus);
    }

    private static class Registers {
        private static final DeferredRegister<RecipeSerializer<?>> SERIALIZER_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"createloveandwar");
        private static final DeferredRegister<RecipeType<?>> TYPE_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)"createloveandwar");

        private Registers() {
        }
    }
}

