/*
 * Decompiled with CFR 0.152.
 */
package net.pttheta.loveandwar.datagen;

import java.util.LinkedHashMap;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.pttheta.loveandwar.blocks.ModBlocks;
import net.pttheta.loveandwar.item.ModItems;

public class ModItemModelProvider
extends ItemModelProvider {
    private static LinkedHashMap<ResourceKey<TrimMaterial>, Float> trimMaterials = new LinkedHashMap();

    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "createloveandwar", existingFileHelper);
    }

    protected void registerModels() {
        this.simpleItem(ModItems.CIGARETTE);
        this.simpleItem(ModItems.RAW_SULPHUR);
        this.simpleItem(ModItems.SULPHUR);
        this.simpleItem(ModItems.RAW_TUNGSTEN);
        this.simpleItem(ModItems.TUNGSTEN);
        this.simpleItem(ModItems.TUNGSTEN_NUGGET);
        this.simpleItem(ModItems.TUNGSTEN_SHEET);
        this.simpleBlockItem(ModBlocks.TUNGSTEN_DOOR);
        this.fenceItem(ModBlocks.TUNGSTEN_FENCE, ModBlocks.TUNGSTEN_BLOCK);
        this.buttonItem(ModBlocks.TUNGSTEN_BUTTON, ModBlocks.TUNGSTEN_BLOCK);
        this.wallItem(ModBlocks.TUNGSTEN_WALL, ModBlocks.TUNGSTEN_BLOCK);
        this.evenSimplerBlockItem(ModBlocks.TUNGSTEN_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.TUNGSTEN_SLAB);
        this.evenSimplerBlockItem(ModBlocks.TUNGSTEN_PRESSURE_PLATE);
        this.evenSimplerBlockItem(ModBlocks.TUNGSTEN_GATE);
        this.trapdoorItem(ModBlocks.TUNGSTEN_TRAPDOOR);
        this.handHeldItem(ModItems.TUNGSTEN_SWORD);
        this.handHeldItem(ModItems.TUNGSTEN_PICKAXE);
        this.handHeldItem(ModItems.TUNGSTEN_AXE);
        this.handHeldItem(ModItems.TUNGSTEN_SHOVEL);
        this.handHeldItem(ModItems.TUNGSTEN_HOE);
        this.trimmedArmorItem(ModItems.TUNGSTEN_HELMET);
        this.trimmedArmorItem(ModItems.TUNGSTEN_CHESTPLATE);
        this.trimmedArmorItem(ModItems.TUNGSTEN_LEGGINGS);
        this.trimmedArmorItem(ModItems.TUNGSTEN_BOOTS);
        this.simpleItem(ModItems.TURRET_UPGRADE);
        this.simpleItem(ModItems.ARMOR_UPGRADE);
        this.simpleItem(ModItems.SCANNER_UPGRADE);
        this.simpleItem(ModItems.ROBOT_DOG_SPAWN_EGG);
        this.simpleItem(ModItems.BRASS_CUP);
        this.simpleItem(ModItems.WIDE_BRASS_CUP);
        this.simpleItem(ModItems.PISTOL_CASING);
        this.simpleItem(ModItems.RIFLE_CASING);
        this.simpleItem(ModItems.GRENADE_CASING);
        this.simpleItem(ModItems.ARTILLERY_CASING);
        this.simpleItem(ModItems.SHOTGUN_CASING);
        this.simpleItem(ModItems.FILLED_PISTOL_CASING);
        this.simpleItem(ModItems.FILLED_RIFLE_CASING);
        this.simpleItem(ModItems.FILLED_GRENADE_CASING);
        this.simpleItem(ModItems.FILLED_ARTILLERY_CASING);
        this.simpleItem(ModItems.FILLED_SHOTGUN_CASING);
        this.simpleItem(ModItems.BALL_BEARINGS);
        this.simpleItem(ModItems.GRENADE);
        this.simpleItem(ModItems.TEMPLATE_UPPER_RECEIVER);
        this.simpleItem(ModItems.TEMPLATE_LOWER_RECEIVER);
        this.simpleItem(ModItems.TEMPLATE_STOCK);
        this.simpleItem(ModItems.TEMPLATE_BARREL);
        this.simpleItem(ModItems.TEMPLATE_GRIP);
        this.simpleItem(ModItems.TEMPLATE_HANDGUARD);
        this.simpleItem(ModItems.UPPER_RECEIVER_IRON);
        this.simpleItem(ModItems.LOWER_RECEIVER_IRON);
        this.simpleItem(ModItems.STOCK_IRON);
        this.simpleItem(ModItems.BARREL_IRON);
        this.simpleItem(ModItems.GRIP_IRON);
        this.simpleItem(ModItems.UPPER_RECEIVER_BRASS);
        this.simpleItem(ModItems.LOWER_RECEIVER_BRASS);
        this.simpleItem(ModItems.STOCK_BRASS);
        this.simpleItem(ModItems.BARREL_BRASS);
        this.simpleItem(ModItems.GRIP_BRASS);
        this.simpleItem(ModItems.UPPER_RECEIVER_TUNGSTEN);
        this.simpleItem(ModItems.LOWER_RECEIVER_TUNGSTEN);
        this.simpleItem(ModItems.STOCK_TUNGSTEN);
        this.simpleItem(ModItems.BARREL_TUNGSTEN);
        this.simpleItem(ModItems.GRIP_TUNGSTEN);
        this.simpleItem(ModItems.UPPER_RECEIVER_STURDY);
        this.simpleItem(ModItems.LOWER_RECEIVER_STURDY);
        this.simpleItem(ModItems.STOCK_STURDY);
        this.simpleItem(ModItems.BARREL_STURDY);
        this.simpleItem(ModItems.GRIP_STURDY);
        this.simpleItem(ModItems.STOCK_WOOD);
        this.simpleItem(ModItems.GRIP_WOOD);
    }

    private ItemModelBuilder simpleItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("createloveandwar", "item/" + item.getId().m_135815_()));
    }

    public void evenSimplerBlockItem(RegistryObject<Block> block) {
        this.withExistingParent("createloveandwar:" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.modLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_()));
    }

    public void trapdoorItem(RegistryObject<Block> block) {
        this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.modLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_() + "_bottom"));
    }

    public void fenceItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.mcLoc("block/fence_inventory"))).texture("texture", new ResourceLocation("createloveandwar", "block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).m_135815_()));
    }

    public void buttonItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.mcLoc("block/button_inventory"))).texture("texture", new ResourceLocation("createloveandwar", "block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).m_135815_()));
    }

    public void wallItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.mcLoc("block/wall_inventory"))).texture("wall", new ResourceLocation("createloveandwar", "block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).m_135815_()));
    }

    private ItemModelBuilder simpleBlockItem(RegistryObject<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("createloveandwar", "item/" + item.getId().m_135815_()));
    }

    private ItemModelBuilder handHeldItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/handheld"))).texture("layer0", new ResourceLocation("createloveandwar", "item/" + item.getId().m_135815_()));
    }

    private void trimmedArmorItem(RegistryObject<Item> itemRegistryObject) {
        String MOD_ID = "createloveandwar";
        Object object = itemRegistryObject.get();
        if (object instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)object;
            trimMaterials.entrySet().forEach(entry -> {
                ResourceKey trimMaterial = (ResourceKey)entry.getKey();
                float trimValue = ((Float)entry.getValue()).floatValue();
                String armorType = switch (armorItem.m_40402_()) {
                    case EquipmentSlot.HEAD -> "helmet";
                    case EquipmentSlot.CHEST -> "chestplate";
                    case EquipmentSlot.LEGS -> "leggings";
                    case EquipmentSlot.FEET -> "boots";
                    default -> "";
                };
                String armorItemPath = "item/" + armorItem;
                String trimPath = "trims/items/" + armorType + "_trim_" + trimMaterial.m_135782_().m_135815_();
                String currentTrimName = armorItemPath + "_" + trimMaterial.m_135782_().m_135815_() + "_trim";
                ResourceLocation armorItemResLoc = new ResourceLocation("createloveandwar", armorItemPath);
                ResourceLocation trimResLoc = new ResourceLocation(trimPath);
                ResourceLocation trimNameResLoc = new ResourceLocation("createloveandwar", currentTrimName);
                this.existingFileHelper.trackGenerated(trimResLoc, PackType.CLIENT_RESOURCES, ".png", "textures");
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(currentTrimName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", armorItemResLoc)).texture("layer1", trimResLoc);
                ((ItemModelBuilder)this.withExistingParent(itemRegistryObject.getId().m_135815_(), this.mcLoc("item/generated"))).override().model((ModelFile)new ModelFile.UncheckedModelFile(trimNameResLoc)).predicate(this.mcLoc("trim_type"), trimValue).end().texture("layer0", new ResourceLocation("createloveandwar", "item/" + itemRegistryObject.getId().m_135815_()));
            });
        }
    }

    static {
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265905_, Float.valueOf(0.1f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266000_, Float.valueOf(0.2f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265896_, Float.valueOf(0.3f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265870_, Float.valueOf(0.4f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265969_, Float.valueOf(0.5f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265937_, Float.valueOf(0.6f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266071_, Float.valueOf(0.7f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266027_, Float.valueOf(0.8f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265981_, Float.valueOf(0.9f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265872_, Float.valueOf(1.0f));
    }
}

