/*
 * Decompiled with CFR 0.152.
 */
package net.pttheta.loveandwar.compat.jei;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedBlazeBurner;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fluids.FluidStack;
import net.pttheta.loveandwar.compat.jei.animations.AnimatedFractionalColumn;
import net.pttheta.loveandwar.recipe.petrochemical.FractionalDistillationRecipe;

@ParametersAreNonnullByDefault
public class FractionalDistillationCategory
extends CreateRecipeCategory<FractionalDistillationRecipe> {
    private final AnimatedFractionalColumn fractionatingColumn = new AnimatedFractionalColumn();
    private final AnimatedBlazeBurner heater = new AnimatedBlazeBurner();
    public int shift = 60;
    int height = 0;

    public FractionalDistillationCategory(CreateRecipeCategory.Info<FractionalDistillationRecipe> info) {
        super(info);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FractionalDistillationRecipe recipe, IFocusGroup focuses) {
        if (recipe.getFluidIngredients().isEmpty()) {
            return;
        }
        FluidIngredient fluidIngredient = (FluidIngredient)recipe.getFluidIngredients().get(0);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 17, 145 - this.shift).setBackground(FractionalDistillationCategory.getRenderedSlot(), -1, -1).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, FractionalDistillationCategory.withImprovedVisibility((List)fluidIngredient.getMatchingFluidStacks()))).addRichTooltipCallback(FractionalDistillationCategory.addFluidTooltip((int)fluidIngredient.getRequiredAmount()));
        int i = 1;
        int size = recipe.getRollableResults().size() + recipe.getFluidResults().size();
        for (FluidStack fluidResult : recipe.getFluidResults()) {
            int yPosition = -23 * i + 150 - this.shift;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 130, yPosition).setBackground(FractionalDistillationCategory.getRenderedSlot(), -1, -1).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)FractionalDistillationCategory.withImprovedVisibility((FluidStack)fluidResult))).addRichTooltipCallback(FractionalDistillationCategory.addFluidTooltip((int)fluidResult.getAmount()));
            ++i;
        }
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.NONE)) {
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 134, 171 - this.shift).addItemStack(AllBlocks.BLAZE_BURNER.asStack());
        }
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.KINDLED)) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 153, 171 - this.shift).addItemStack(AllItems.BLAZE_CAKE.asStack());
        }
    }

    public void draw(FractionalDistillationRecipe recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        boolean noHeat = requiredHeat == HeatCondition.NONE;
        AllGuiTextures.JEI_ARROW.render(graphics, 40, 150 - this.shift);
        AllGuiTextures shadow = noHeat ? AllGuiTextures.JEI_SHADOW : AllGuiTextures.JEI_LIGHT;
        shadow.render(graphics, 81, 153 + (noHeat ? 10 : 30) - this.shift);
        this.fractionatingColumn.draw(graphics, 91, 142 - this.shift, recipe.getFluidResults().size());
        if (!noHeat) {
            this.heater.withHeat(requiredHeat.visualizeAsBlazeBurner()).draw(graphics, 91, 150 - this.shift);
        }
        AllGuiTextures heatBar = noHeat ? AllGuiTextures.JEI_NO_HEAT_BAR : AllGuiTextures.JEI_HEAT_BAR;
        heatBar.render(graphics, 4, 170);
        graphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)CreateLang.translateDirect((String)requiredHeat.getTranslationKey(), (Object[])new Object[0]), 9, 176 - this.shift, requiredHeat.getColor(), false);
    }
}

