/*
 * Decompiled with CFR 0.152.
 */
package net.pttheta.loveandwar.blocks.stamping;

import com.simibubi.create.AllTags;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.pttheta.loveandwar.blocks.stamping.StampingBehaviour;
import net.pttheta.loveandwar.recipe.ModRecipes;
import net.pttheta.loveandwar.recipe.stamping.StampingRecipe;
import net.pttheta.loveandwar.util.ModTags;

public class StampingPressBlockEntity
extends KineticBlockEntity
implements StampingBehaviour.StampingBehaviourSpecifics {
    private final ItemStackHandler templateHolder = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            StampingPressBlockEntity.this.m_6596_();
            if (!StampingPressBlockEntity.this.f_58857_.m_5776_()) {
                StampingPressBlockEntity.this.f_58857_.m_7260_(StampingPressBlockEntity.this.m_58899_(), StampingPressBlockEntity.this.m_58900_(), StampingPressBlockEntity.this.m_58900_(), 3);
            }
        }
    };
    private int ticksSinceSwap = 0;
    private static final Object stampingRecipesKey = new Object();
    public StampingBehaviour stampingBehaviour;
    private int tracksCreated;
    private static final RecipeWrapper pressingInv = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));

    public ItemStack getRenderStack() {
        return this.templateHolder.getStackInSlot(0);
    }

    public StampingPressBlockEntity(BlockEntityType<? extends StampingPressBlockEntity> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.stampingBehaviour = new StampingBehaviour(this);
        behaviours.add((BlockEntityBehaviour)this.stampingBehaviour);
        this.registerAwardables(behaviours, new CreateAdvancement[]{AllAdvancements.PRESS, AllAdvancements.TRACK_CRAFTING});
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82363_(0.0, -1.5, 0.0).m_82363_(0.0, 1.0, 0.0);
    }

    public void onItemDrawn(ItemStack result) {
        if (AllTags.AllBlockTags.TRACKS.matches(result)) {
            this.tracksCreated += result.m_41613_();
        }
        if (this.tracksCreated >= 1000) {
            this.award(AllAdvancements.TRACK_CRAFTING);
            this.tracksCreated = 0;
        }
    }

    public void destroy() {
        super.destroy();
        this.dropTemplate();
    }

    public void dropTemplate() {
        SimpleContainer inventory = new SimpleContainer(this.templateHolder.getSlots());
        for (int i = 0; i < this.templateHolder.getSlots(); ++i) {
            inventory.m_6836_(i, this.templateHolder.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public void templateInteract(ItemStack item, Player player, InteractionHand hand) {
        boolean isTemplate = item.m_204117_(ModTags.Items.STAMPING_TEMPLATE);
        if (this.ticksSinceSwap < 5) {
            return;
        }
        if (player.m_6144_()) {
            player.m_21008_(hand, this.templateHolder.getStackInSlot(0));
            this.templateHolder.setStackInSlot(0, item);
            this.ticksSinceSwap = 0;
        } else if (isTemplate) {
            player.m_21008_(hand, this.templateHolder.getStackInSlot(0));
            this.templateHolder.setStackInSlot(0, new ItemStack((ItemLike)item.m_41720_(), 1));
            this.ticksSinceSwap = 0;
        }
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        if (((AdvancementBehaviour)this.getBehaviour(AdvancementBehaviour.TYPE)).isOwnerPresent()) {
            compound.m_128405_("TracksCreated", this.tracksCreated);
        }
        compound.m_128365_("template", (Tag)this.templateHolder.serializeNBT());
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.tracksCreated = compound.m_128451_("TracksCreated");
        this.templateHolder.deserializeNBT(compound.m_128469_("template"));
    }

    public StampingBehaviour getStampingBehaviour() {
        return this.stampingBehaviour;
    }

    @Override
    public boolean tryProcessInWorld(ItemEntity itemEntity, boolean simulate) {
        ItemStack item = itemEntity.m_32055_();
        Optional<StampingRecipe> recipe = this.getRecipes(item, this.templateHolder.getStackInSlot(0));
        if (!recipe.isPresent()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        if (this.templateHolder.getStackInSlot(0).m_41619_()) {
            return false;
        }
        ItemStack itemCreated = ItemStack.f_41583_;
        this.stampingBehaviour.particleItems.add(item);
        if (this.canProcessInBulk() || item.m_41613_() == 1) {
            RecipeApplier.applyRecipeOn((ItemEntity)itemEntity, (Recipe)((Recipe)recipe.get()));
            itemCreated = itemEntity.m_32055_().m_41777_();
        } else {
            for (ItemStack result : RecipeApplier.applyRecipeOn((Level)this.f_58857_, (ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)item, (int)1), (Recipe)((Recipe)recipe.get()))) {
                if (itemCreated.m_41619_()) {
                    itemCreated = result.m_41777_();
                }
                ItemEntity created = new ItemEntity(this.f_58857_, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), result);
                created.m_32060_();
                created.m_20256_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)this.f_58857_.f_46441_, (float)0.05f));
                this.f_58857_.m_7967_((Entity)created);
            }
            item.m_41774_(1);
        }
        if (!itemCreated.m_41619_()) {
            this.onItemDrawn(itemCreated);
        }
        return true;
    }

    @Override
    public boolean tryProcessOnBelt(TransportedItemStack input, List<ItemStack> outputList, boolean simulate) {
        Optional<StampingRecipe> recipe = this.getRecipes(input.stack, this.templateHolder.getStackInSlot(0));
        if (!recipe.isPresent()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        if (this.templateHolder.getStackInSlot(0).m_41619_()) {
            return false;
        }
        this.stampingBehaviour.particleItems.add(input.stack);
        List outputs = RecipeApplier.applyRecipeOn((Level)this.f_58857_, (ItemStack)(this.canProcessInBulk() ? input.stack : ItemHandlerHelper.copyStackWithSize((ItemStack)input.stack, (int)1)), (Recipe)((Recipe)recipe.get()));
        for (ItemStack created : outputs) {
            if (created.m_41619_()) continue;
            this.onItemDrawn(created);
            break;
        }
        outputList.addAll(outputs);
        return true;
    }

    @Override
    public boolean canProcessInBulk() {
        return (Boolean)AllConfigs.server().recipes.bulkPressing.get();
    }

    @Override
    public void onStampingCompleted() {
    }

    public static <C extends Container> boolean canCompress(Recipe<C> recipe) {
        if (!(recipe instanceof CraftingRecipe) || !((Boolean)AllConfigs.server().recipes.allowShapedSquareInPress.get()).booleanValue()) {
            return false;
        }
        NonNullList ingredients = recipe.m_7527_();
        return (ingredients.size() == 4 || ingredients.size() == 9) && ItemHelper.matchAllIngredients((NonNullList)ingredients);
    }

    @Override
    public int getParticleAmount() {
        return 15;
    }

    @Override
    public float getKineticSpeed() {
        return this.getSpeed();
    }

    @Override
    public void setTemplate(ItemStack stack) {
        this.templateHolder.setStackInSlot(0, stack);
    }

    public void tick() {
        super.tick();
        ++this.ticksSinceSwap;
    }

    public Optional<StampingRecipe> getRecipe(ItemStack item, ItemStack template) {
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (ItemStack)item, ModRecipes.STAMPING_TYPE.get(), StampingRecipe.class);
        if (assemblyRecipe.isPresent()) {
            return assemblyRecipe;
        }
        pressingInv.m_6836_(0, item);
        pressingInv.m_6836_(1, this.templateHolder.getStackInSlot(0));
        return this.find(pressingInv, this.f_58857_);
    }

    public Optional<StampingRecipe> getRecipes(ItemStack item, ItemStack template) {
        Stream assemblyRecipe = SequencedAssemblyRecipe.getRecipes((Level)this.f_58857_, (ItemStack)item, ModRecipes.STAMPING_TYPE.get(), StampingRecipe.class);
        List recipes = this.m_58904_().m_7465_().m_44013_(ModRecipes.STAMPING_TYPE.get());
        for (StampingRecipe recipe : recipes) {
            ItemStack tem = recipe.getTemplate();
            Ingredient input = recipe.getIngredient();
            boolean test = input.test(item);
            if (tem.m_41720_() != template.m_41720_() || !recipe.getIngredient().test(item)) continue;
            return Optional.ofNullable(recipe);
        }
        if (assemblyRecipe.count() > 0L) {
            for (StampingRecipe recipe : assemblyRecipe.toList()) {
                if (recipe.getTemplate() != template) continue;
                return Optional.ofNullable(recipe);
            }
        }
        pressingInv.m_6836_(0, item);
        return this.find(pressingInv, this.f_58857_);
    }

    public Optional<StampingRecipe> find(RecipeWrapper inv, Level world) {
        Optional sequenced = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (ItemStack)inv.m_8020_(0), ModRecipes.STAMPING_TYPE.get(), StampingRecipe.class);
        if (sequenced.isPresent()) {
            return sequenced;
        }
        return world.m_7465_().m_44015_(ModRecipes.STAMPING_TYPE.get(), (Container)inv, world);
    }

    public <C extends Container, T extends Recipe<C>> Optional<StampingRecipe> getRecipeFor(RecipeType<T> pRecipeType, C pInventory, Level pLevel, ItemStack template) {
        List recipes = this.m_58904_().m_7465_().m_44013_(ModRecipes.STAMPING_TYPE.get());
        for (StampingRecipe recipe : recipes) {
            if (recipe.getTemplate() != template) continue;
            return Optional.ofNullable(recipe);
        }
        return null;
    }

    protected Object getRecipeCacheKey() {
        return stampingRecipesKey;
    }
}

