/*
 * Decompiled with CFR 0.152.
 */
package net.pttheta.loveandwar.blocks.petrochem;

import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.foundation.block.connected.CTModel;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.pttheta.loveandwar.blocks.petrochem.DistillationColumnCTBehavior;

public class DistillationColumnModel
extends CTModel {
    protected static final ModelProperty<CullData> CULL_PROPERTY = new ModelProperty();

    public DistillationColumnModel(BakedModel originalModel) {
        super(originalModel, (ConnectedTextureBehaviour)new DistillationColumnCTBehavior());
    }

    protected ModelData.Builder gatherModelData(ModelData.Builder builder, BlockAndTintGetter world, BlockPos pos, BlockState state, ModelData blockEntityData) {
        super.gatherModelData(builder, world, pos, state, blockEntityData);
        CullData cullData = new CullData();
        for (Direction d : Iterate.horizontalDirections) {
            cullData.setCulled(d, ConnectivityHandler.isConnected((BlockGetter)world, (BlockPos)pos, (BlockPos)pos.m_121945_(d)));
        }
        return builder.with(CULL_PROPERTY, (Object)cullData);
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand, ModelData extraData, RenderType renderType) {
        if (side != null) {
            return Collections.emptyList();
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (Direction d : Iterate.directions) {
            if (extraData.has(CULL_PROPERTY) && ((CullData)extraData.get(CULL_PROPERTY)).isCulled(d)) continue;
            quads.addAll(super.getQuads(state, d, rand, extraData, renderType));
        }
        quads.addAll(super.getQuads(state, null, rand, extraData, renderType));
        return quads;
    }

    private static class CullData {
        boolean[] culledFaces = new boolean[4];

        public CullData() {
            Arrays.fill(this.culledFaces, false);
        }

        void setCulled(Direction face, boolean cull) {
            if (face.m_122434_().m_122478_()) {
                return;
            }
            this.culledFaces[face.m_122416_()] = cull;
        }

        boolean isCulled(Direction face) {
            if (face.m_122434_().m_122478_()) {
                return false;
            }
            return this.culledFaces[face.m_122416_()];
        }
    }
}

