/*
 * Decompiled with CFR 0.152.
 */
package net.pttheta.loveandwar.blocks.petrochem;

import com.simibubi.create.api.boiler.BoilerHeater;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.pttheta.loveandwar.blocks.petrochem.DistillationColumnBlock;
import net.pttheta.loveandwar.recipe.RecipeRegister;
import net.pttheta.loveandwar.recipe.petrochemical.FractionalDistillationRecipe;

public class DistillationColumnBlockEntity
extends SmartBlockEntity
implements IMultiBlockEntityContainer.Fluid,
IHaveGoggleInformation {
    public int FRACTIONAL_HEIGHT = 1;
    public boolean SPEED_BOOST = true;
    private static final int MAX_SIZE = 3;
    public float progress;
    public boolean[] occludedDirections = new boolean[]{true, true, true, true};
    public int heat;
    protected LazyOptional<IFluidHandler> fluidCapability = LazyOptional.of(() -> this.tankInventory);
    protected boolean forceFluidLevelUpdate = true;
    public FluidTank tankInventory = this.createInventory();
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    protected boolean updateConnectivity = false;
    public boolean window = false;
    protected int luminosity;
    protected int width = 1;
    protected int height = 1;
    protected BlockPos bottomCPos;
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;
    private LerpedFloat fluidLevel;
    public boolean hasDistillationC;
    int processingTime = -1;
    FractionalDistillationRecipe currentRecipe;

    public DistillationColumnBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.refreshCapability();
    }

    private BlockPos getBottomControllerPos() {
        if (this.isBottom()) {
            return this.getController();
        }
        BlockEntity block = this.f_58857_.m_7702_(this.m_58899_().m_7495_());
        if (block instanceof DistillationColumnBlockEntity) {
            DistillationColumnBlockEntity be = (DistillationColumnBlockEntity)block;
            return be.getBottomControllerPos();
        }
        return this.getController();
    }

    protected SmartFluidTank createInventory() {
        return new SmartFluidTank(DistillationColumnBlockEntity.getCapacityMultiplier(), this::onFluidStackChanged);
    }

    public int updateTemperature() {
        if (this.getControllerBE() == null) {
            return 0;
        }
        int width = this.getControllerBE().width;
        int heatN = 0;
        if (this.getController() != null && width != 0) {
            for (int xOffset = 0; xOffset < width; ++xOffset) {
                for (int zOffset = 0; zOffset < width; ++zOffset) {
                    BlockPos pos = this.getController().m_7918_(xOffset, -1, zOffset);
                    BlockState blockState = this.f_58857_.m_8055_(pos);
                    float heat = BoilerHeater.findHeat((Level)this.f_58857_, (BlockPos)pos, (BlockState)blockState);
                    heatN = (int)((float)heatN + heat);
                }
            }
            return heatN / (width * width);
        }
        return 0;
    }

    public void updateConnectivity() {
        this.updateConnectivity = false;
        if (!this.f_58857_.f_46443_ && this.isController()) {
            ConnectivityHandler.formMulti((BlockEntity)this);
        }
    }

    private void startProcessing() {
        if (this.currentRecipe != null) {
            this.processingTime = this.currentRecipe.getProcessingDuration();
        }
    }

    public void tick() {
        this.bottomCPos = this.getBottomControllerPos();
        if (this.isController() && this.isBottom()) {
            int oldHeat = this.heat;
            this.heat = this.updateTemperature();
            if (oldHeat != this.heat && this.processingTime <= -1) {
                List<Recipe<?>> r = this.getMatchingRecipes();
                if (!r.isEmpty()) {
                    this.currentRecipe = (FractionalDistillationRecipe)r.get(0);
                    if (this.getHeat(this.currentRecipe.getRequiredHeat()) <= this.heat) {
                        this.startProcessing();
                    } else {
                        this.currentRecipe = null;
                    }
                } else {
                    this.currentRecipe = null;
                }
            }
            if (this.processingTime > -1 && this.currentRecipe != null) {
                boolean canFill = true;
                for (int i = 0; i < this.currentRecipe.getFluidResults().size() * this.FRACTIONAL_HEIGHT; ++i) {
                    BlockEntity block = this.f_58857_.m_7702_(this.m_58899_().m_6630_(i + 1));
                    if (block instanceof DistillationColumnBlockEntity) {
                        DistillationColumnBlockEntity be = (DistillationColumnBlockEntity)block;
                        if (be.getControllerBE().width != this.getControllerBE().width) {
                            canFill = false;
                            break;
                        }
                        if (i % this.FRACTIONAL_HEIGHT == 0 && be.getTank(0).getFluidAmount() <= DistillationColumnBlockEntity.getCapacityMultiplier() * this.width * this.width - ((FluidStack)this.currentRecipe.getFluidResults().get(i / this.FRACTIONAL_HEIGHT)).getAmount()) {
                            continue;
                        }
                        canFill = false;
                        break;
                    }
                    canFill = false;
                    break;
                }
                if (canFill) {
                    this.processingTime -= Mth.m_14045_((int)(this.SPEED_BOOST ? this.width * this.width : 1), (int)1, (int)this.processingTime);
                }
                if (this.tankInventory.getFluid().getAmount() < ((FluidIngredient)this.currentRecipe.getFluidIngredients().get(0)).getRequiredAmount() || this.getHeat(this.currentRecipe.getRequiredHeat()) > this.heat) {
                    this.currentRecipe = null;
                    this.processingTime = -1;
                    this.onFluidStackChanged(this.tankInventory.getFluid());
                }
            }
            if (this.processingTime == 0 && this.currentRecipe != null) {
                if (this.tankInventory.getFluid().getAmount() >= ((FluidIngredient)this.currentRecipe.getFluidIngredients().get(0)).getRequiredAmount() && this.getHeat(this.currentRecipe.getRequiredHeat()) <= this.heat) {
                    this.tankInventory.drain(((FluidIngredient)this.currentRecipe.getFluidIngredients().get(0)).getRequiredAmount(), IFluidHandler.FluidAction.EXECUTE);
                    if (this.currentRecipe != null) {
                        BlockEntity block;
                        for (int i = 0; i < this.currentRecipe.getFluidResults().size() * this.FRACTIONAL_HEIGHT && (block = this.f_58857_.m_7702_(this.m_58899_().m_6630_(i + 1))) instanceof DistillationColumnBlockEntity; ++i) {
                            DistillationColumnBlockEntity be = (DistillationColumnBlockEntity)block;
                            if (be.getControllerBE().width != this.getControllerBE().width) break;
                            if (i % this.FRACTIONAL_HEIGHT != 0) continue;
                            be.tankInventory.fill((FluidStack)this.currentRecipe.getFluidResults().get(i / this.FRACTIONAL_HEIGHT), IFluidHandler.FluidAction.EXECUTE);
                        }
                    }
                }
                this.currentRecipe = null;
                this.processingTime = -1;
                this.onFluidStackChanged(this.tankInventory.getFluid());
            }
            if (this.currentRecipe == null || this.width != 0 && this.currentRecipe.getProcessingDuration() != 0) {
                this.progress = this.currentRecipe != null ? (float)this.processingTime / ((float)this.currentRecipe.getProcessingDuration() / (float)(this.width * this.width)) : 0.0f;
            }
        }
        super.tick();
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.m_58899_();
        } else if (!this.lastKnownPos.equals((Object)this.f_58858_) && this.f_58858_ != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        if (this.fluidLevel != null) {
            this.fluidLevel.tickChaser();
        }
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public boolean isController() {
        return this.controller == null || this.f_58858_.m_123341_() == this.controller.m_123341_() && this.f_58858_.m_123342_() == this.controller.m_123342_() && this.f_58858_.m_123343_() == this.controller.m_123343_();
    }

    public void initialize() {
        super.initialize();
        this.sendData();
        if (this.f_58857_.f_46443_) {
            this.invalidateRenderBoundingBox();
        }
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.f_58858_;
    }

    protected List<Recipe<?>> getMatchingRecipes() {
        List list = RecipeFinder.get((Object)new Object(), (Level)this.f_58857_, recipe -> recipe.m_6671_() == RecipeRegister.FRACTIONAL_DISTILLATION.getType());
        return list.stream().filter(r -> !((FractionalDistillationRecipe)((Object)r)).getFluidIngredients().isEmpty() ? ((FluidIngredient)((FractionalDistillationRecipe)((Object)r)).getFluidIngredients().get(0)).getMatchingFluidStacks().contains(this.tankInventory.getFluid()) && this.getHeat(((FractionalDistillationRecipe)((Object)r)).getRequiredHeat()) <= this.heat : false).collect(Collectors.toList());
    }

    int getHeat(HeatCondition heatCondition) {
        if (heatCondition == HeatCondition.SUPERHEATED) {
            return 2;
        }
        return heatCondition == HeatCondition.HEATED ? 1 : 0;
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.m_58898_()) {
            return;
        }
        if (this.processingTime <= -1) {
            List<Recipe<?>> r = this.getMatchingRecipes();
            if (!r.isEmpty()) {
                this.currentRecipe = (FractionalDistillationRecipe)r.get(0);
                this.startProcessing();
            } else {
                this.currentRecipe = null;
            }
        }
        FluidType attributes = newFluidStack.getFluid().getFluidType();
        int luminosity = (int)((float)attributes.getLightLevel(newFluidStack) / 1.2f);
        boolean reversed = attributes.isLighterThanAir();
        int maxY = (int)(this.getFillState() * (float)this.height + 1.0f);
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            boolean isBright;
            boolean bl = reversed ? this.height - yOffset <= maxY : (isBright = yOffset < maxY);
            int actualLuminosity = isBright ? luminosity : (luminosity > 0 ? 1 : 0);
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockPos pos = this.f_58858_.m_7918_(xOffset, yOffset, zOffset);
                    DistillationColumnBlockEntity tankAt = (DistillationColumnBlockEntity)ConnectivityHandler.partAt((BlockEntityType)this.m_58903_(), (BlockGetter)this.f_58857_, (BlockPos)pos);
                    if (tankAt == null) continue;
                    this.f_58857_.m_46717_(pos, tankAt.m_58900_().m_60734_());
                    if (tankAt.luminosity == actualLuminosity) continue;
                    tankAt.setLuminosity(actualLuminosity);
                }
            }
        }
        if (!this.f_58857_.f_46443_) {
            this.m_6596_();
            this.sendData();
        }
        if (this.isVirtual()) {
            if (this.fluidLevel == null) {
                this.fluidLevel = LerpedFloat.linear().startWithValue((double)this.getFillState());
            }
            this.fluidLevel.chase((double)this.getFillState(), 0.5, LerpedFloat.Chaser.EXP);
        }
    }

    protected void setLuminosity(int luminosity) {
        if (!this.f_58857_.f_46443_ && this.luminosity != luminosity) {
            this.luminosity = luminosity;
            this.sendData();
        }
    }

    public DistillationColumnBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.controller);
        return blockEntity instanceof DistillationColumnBlockEntity ? (DistillationColumnBlockEntity)blockEntity : null;
    }

    public void applyFluidTankSize(int blocks) {
        this.tankInventory.setCapacity(blocks * DistillationColumnBlockEntity.getCapacityMultiplier());
        int overflow = this.tankInventory.getFluidAmount() - this.tankInventory.getCapacity();
        if (overflow > 0) {
            this.tankInventory.drain(overflow, IFluidHandler.FluidAction.EXECUTE);
        }
        this.forceFluidLevelUpdate = true;
    }

    public void removeController(boolean keepFluids) {
        if (!this.f_58857_.f_46443_) {
            this.updateConnectivity = true;
            if (!keepFluids) {
                this.applyFluidTankSize(1);
            }
            this.controller = null;
            this.width = 1;
            this.height = 1;
            this.onFluidStackChanged(this.tankInventory.getFluid());
            BlockState state = this.m_58900_();
            if (DistillationColumnBlock.isTank(state)) {
                state = (BlockState)state.m_61124_((Property)DistillationColumnBlock.BOTTOM, (Comparable)Boolean.valueOf(true));
                state = (BlockState)state.m_61124_((Property)DistillationColumnBlock.TOP, (Comparable)Boolean.valueOf(true));
                state = (BlockState)state.m_61124_(DistillationColumnBlock.SHAPE, (Comparable)(this.window ? FluidTankBlock.Shape.WINDOW : FluidTankBlock.Shape.PLAIN));
                this.m_58904_().m_7731_(this.f_58858_, state, 6);
            }
            this.refreshCapability();
            this.m_6596_();
            this.sendData();
        }
    }

    public void toggleWindows() {
        DistillationColumnBlockEntity be = this.getControllerBE();
        if (be != null) {
            be.setWindows(!be.window);
        }
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
        } else {
            super.sendData();
            this.queuedSync = false;
            this.syncCooldown = 8;
        }
    }

    public void setWindows(boolean window) {
        if (!window || this.FRACTIONAL_HEIGHT == 1 || (this.getBottomControllerPos().m_123342_() + 1 - this.f_58858_.m_123342_()) % this.FRACTIONAL_HEIGHT == 0) {
            this.window = window;
            for (int yOffset = 0; yOffset < this.height; ++yOffset) {
                for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                    for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                        BlockPos pos = this.f_58858_.m_7918_(xOffset, yOffset, zOffset);
                        BlockState blockState = this.f_58857_.m_8055_(pos);
                        if (!DistillationColumnBlock.isTank(blockState)) continue;
                        FluidTankBlock.Shape shape = FluidTankBlock.Shape.PLAIN;
                        if (window) {
                            if (this.width == 1) {
                                shape = FluidTankBlock.Shape.WINDOW;
                            }
                            if (this.width == 2) {
                                FluidTankBlock.Shape shape2 = xOffset == 0 ? (zOffset == 0 ? FluidTankBlock.Shape.WINDOW_NW : FluidTankBlock.Shape.WINDOW_SW) : (shape = zOffset == 0 ? FluidTankBlock.Shape.WINDOW_NE : FluidTankBlock.Shape.WINDOW_SE);
                            }
                            if (this.width == 3 && Math.abs(Math.abs(xOffset) - Math.abs(zOffset)) == 1) {
                                shape = FluidTankBlock.Shape.WINDOW;
                            }
                        }
                        this.f_58857_.m_7731_(pos, (BlockState)blockState.m_61124_(DistillationColumnBlock.SHAPE, (Comparable)shape), 22);
                        this.f_58857_.m_7726_().m_7827_().m_7174_(pos);
                    }
                }
            }
        }
    }

    public void setController(BlockPos controller) {
        if (!(this.f_58857_.f_46443_ && !this.isVirtual() || controller.equals((Object)this.controller))) {
            this.controller = controller;
            this.refreshCapability();
            this.m_6596_();
            this.sendData();
        }
    }

    private void refreshCapability() {
        LazyOptional<IFluidHandler> oldCap = this.fluidCapability;
        this.fluidCapability = LazyOptional.of(() -> this.handlerForCapability());
        oldCap.invalidate();
    }

    private IFluidHandler handlerForCapability() {
        return this.isController() ? this.tankInventory : (this.getControllerBE() != null ? this.getControllerBE().handlerForCapability() : new FluidTank(0));
    }

    public BlockPos getController() {
        return this.isController() ? this.f_58858_ : this.controller;
    }

    protected AABB createRenderBoundingBox() {
        return this.isController() ? super.createRenderBoundingBox().m_82363_((double)(this.width - 1), (double)(this.height - 1), (double)(this.width - 1)) : super.createRenderBoundingBox();
    }

    public DistillationColumnBlockEntity getOtherDistillationColumnBlockEntity(Direction direction) {
        BlockEntity otherBE = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
        return otherBE instanceof DistillationColumnBlockEntity ? (DistillationColumnBlockEntity)otherBE : null;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.FRACTIONAL_HEIGHT != 1 && (this.getBottomControllerPos().m_123342_() + 1 - this.f_58858_.m_123342_()) % this.FRACTIONAL_HEIGHT != 0) {
            return false;
        }
        DistillationColumnBlockEntity controllerBE = this.getControllerBE();
        return controllerBE == null ? false : this.containedFluidTooltip(tooltip, isPlayerSneaking, controllerBE.getCapability(ForgeCapabilities.FLUID_HANDLER));
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.hasDistillationC = compound.m_128471_("HasDistillationC");
        BlockPos controllerBefore = this.controller;
        int prevSize = this.width;
        int prevHeight = this.height;
        int prevLum = this.luminosity;
        this.updateConnectivity = compound.m_128441_("Uninitialized");
        this.luminosity = compound.m_128451_("Luminosity");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.m_128441_("LastKnownPos")) {
            this.lastKnownPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("LastKnownPos"));
        }
        if (compound.m_128441_("Controller")) {
            this.controller = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Controller"));
        }
        if (this.isController()) {
            this.window = compound.m_128471_("Window");
            this.width = compound.m_128451_("Size");
            this.height = compound.m_128451_("Height");
            this.tankInventory.setCapacity(this.getTotalTankSize() * DistillationColumnBlockEntity.getCapacityMultiplier());
            this.tankInventory.readFromNBT(compound.m_128469_("TankContent"));
            if (this.tankInventory.getSpace() < 0) {
                this.tankInventory.drain(-this.tankInventory.getSpace(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        if (compound.m_128441_("ForceFluidLevel") || this.fluidLevel == null) {
            this.fluidLevel = LerpedFloat.linear().startWithValue((double)this.getFillState());
        }
        if (clientPacket) {
            boolean changeOfController;
            boolean bl = controllerBefore == null ? this.controller != null : (changeOfController = !controllerBefore.equals((Object)this.controller));
            if (changeOfController || prevSize != this.width || prevHeight != this.height) {
                if (this.m_58898_()) {
                    this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 16);
                }
                if (this.isController()) {
                    this.tankInventory.setCapacity(DistillationColumnBlockEntity.getCapacityMultiplier() * this.getTotalTankSize());
                }
                this.invalidateRenderBoundingBox();
            }
            if (this.isController()) {
                float fillState = this.getFillState();
                if (compound.m_128441_("ForceFluidLevel") || this.fluidLevel == null) {
                    this.fluidLevel = LerpedFloat.linear().startWithValue((double)fillState);
                }
                this.fluidLevel.chase((double)fillState, 0.5, LerpedFloat.Chaser.EXP);
                this.processingTime = compound.m_128451_("Progress");
            }
            if (this.luminosity != prevLum && this.m_58898_()) {
                this.f_58857_.m_7726_().m_7827_().m_7174_(this.f_58858_);
            }
            if (compound.m_128441_("LazySync")) {
                this.fluidLevel.chase((double)this.fluidLevel.getChaseTarget(), 0.125, LerpedFloat.Chaser.EXP);
            }
        }
    }

    public float getFillState() {
        return (float)this.tankInventory.getFluidAmount() / (float)this.tankInventory.getCapacity();
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128379_("HasDistillationC", this.hasDistillationC);
        if (this.updateConnectivity) {
            compound.m_128379_("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.m_128365_("LastKnownPos", (Tag)NbtUtils.m_129224_((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.m_128379_("Window", this.window);
            compound.m_128365_("TankContent", (Tag)this.tankInventory.writeToNBT(new CompoundTag()));
            compound.m_128405_("Size", this.width);
            compound.m_128405_("Height", this.height);
            compound.m_128405_("Progress", this.processingTime);
        }
        compound.m_128405_("Luminosity", this.luminosity);
        super.write(compound, clientPacket);
        if (clientPacket) {
            if (this.forceFluidLevelUpdate) {
                compound.m_128379_("ForceFluidLevel", true);
            }
            if (this.queuedSync) {
                compound.m_128379_("LazySync", true);
            }
            this.forceFluidLevelUpdate = false;
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.FRACTIONAL_HEIGHT != 1 && (this.getBottomControllerPos().m_123342_() + 1 - this.f_58858_.m_123342_()) % this.FRACTIONAL_HEIGHT != 0) {
            return super.getCapability(cap, side);
        }
        if (!this.fluidCapability.isPresent()) {
            this.refreshCapability();
        }
        return cap == ForgeCapabilities.FLUID_HANDLER ? this.fluidCapability.cast() : super.getCapability(cap, side);
    }

    public void invalidate() {
        super.invalidate();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public int getTotalTankSize() {
        return this.width * this.width;
    }

    public static int getCapacityMultiplier() {
        return 500;
    }

    public LerpedFloat getFluidLevel() {
        return this.fluidLevel;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        BlockState state = this.m_58900_();
        if (DistillationColumnBlock.isTank(state)) {
            state = (BlockState)state.m_61124_((Property)DistillationColumnBlock.BOTTOM, (Comparable)Boolean.valueOf(this.getBottomConnectivity()));
            state = (BlockState)state.m_61124_((Property)DistillationColumnBlock.TOP, (Comparable)Boolean.valueOf(this.getTopConnectivity()));
            this.f_58857_.m_7731_(this.m_58899_(), state, 6);
        }
        if (this.isController()) {
            this.setWindows(this.window);
        }
        this.onFluidStackChanged(this.tankInventory.getFluid());
        this.m_6596_();
    }

    private boolean getBottomConnectivity() {
        DistillationColumnBlockEntity controllerBE;
        DistillationColumnBlockEntity be;
        DistillationColumnBlockEntity otherControllerBE;
        BlockEntity block = this.f_58857_.m_7702_(this.m_58899_().m_7495_());
        if (block instanceof DistillationColumnBlockEntity && (otherControllerBE = (be = (DistillationColumnBlockEntity)block).getControllerBE()) != null && (controllerBE = this.getControllerBE()) != null && controllerBE.m_58899_().m_7495_().equals((Object)otherControllerBE.m_58899_())) {
            return controllerBE.getWidth() != otherControllerBE.getWidth();
        }
        return true;
    }

    private boolean getTopConnectivity() {
        DistillationColumnBlockEntity controllerBE;
        DistillationColumnBlockEntity be;
        DistillationColumnBlockEntity otherControllerBE;
        BlockEntity block = this.f_58857_.m_7702_(this.m_58899_().m_7494_());
        if (block instanceof DistillationColumnBlockEntity && (otherControllerBE = (be = (DistillationColumnBlockEntity)block).getControllerBE()) != null && (controllerBE = this.getControllerBE()) != null && controllerBE.m_58899_().m_7494_().equals((Object)otherControllerBE.m_58899_())) {
            return controllerBE.getWidth() != otherControllerBE.getWidth();
        }
        return true;
    }

    public void setExtraData(@Nullable Object data) {
        if (data instanceof Boolean) {
            this.window = (Boolean)data;
        }
    }

    @Nullable
    public Object getExtraData() {
        return this.window;
    }

    public Object modifyExtraData(Object data) {
        if (data instanceof Boolean) {
            Boolean windows = (Boolean)data;
            windows = windows | this.window;
            return windows;
        }
        return data;
    }

    public Direction.Axis getMainConnectionAxis() {
        return Direction.Axis.Y;
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        return longAxis == Direction.Axis.Y ? 1 : this.getMaxWidth();
    }

    public int getMaxWidth() {
        return 3;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean hasTank() {
        return true;
    }

    public int getTankSize(int tank) {
        return DistillationColumnBlockEntity.getCapacityMultiplier();
    }

    public void setTankSize(int tank, int blocks) {
        this.applyFluidTankSize(blocks);
    }

    public IFluidTank getTank(int tank) {
        return this.tankInventory;
    }

    public FluidStack getFluid(int tank) {
        return this.tankInventory.getFluid().copy();
    }

    public void updateVerticalMulti() {
        BlockEntity block;
        BlockState state = this.m_58900_();
        if (DistillationColumnBlock.isTank(state)) {
            state = (BlockState)state.m_61124_((Property)DistillationColumnBlock.BOTTOM, (Comparable)Boolean.valueOf(this.getBottomConnectivity()));
            if ((state = (BlockState)state.m_61124_((Property)DistillationColumnBlock.TOP, (Comparable)Boolean.valueOf(this.getTopConnectivity()))) != this.m_58900_()) {
                this.f_58857_.m_7731_(this.m_58899_(), state, 3);
            }
        }
        if ((block = this.f_58857_.m_7702_(this.m_58899_().m_7495_())) instanceof DistillationColumnBlockEntity) {
            DistillationColumnBlockEntity be = (DistillationColumnBlockEntity)block;
            be.updateVerticalMulti();
        }
    }

    public boolean isBottom() {
        return !(this.f_58857_.m_7702_(this.m_58899_().m_7495_()) instanceof DistillationColumnBlockEntity);
    }
}

