/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.forge.crafting;

import com.simibubi.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import rbasamoyai.createbigcannons.crafting.boring.AbstractCannonDrillBlockEntity;
import rbasamoyai.createbigcannons.multiloader.IndexPlatform;

public class CannonDrillBlockEntity
extends AbstractCannonDrillBlockEntity {
    protected FluidTank lubricant = new SmartFluidTank(IndexPlatform.convertFluid(1000), this::onFluidStackChanged).setValidator(fs -> fs.getFluid() == Fluids.f_76193_);
    private LazyOptional<IFluidHandler> fluidOptional;

    public CannonDrillBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            Direction.Axis pipeAxis;
            Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
            boolean alongFirst = (Boolean)this.m_58900_().m_61143_((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE);
            switch (facing.m_122434_()) {
                case X: {
                    Direction.Axis axis;
                    if (alongFirst) {
                        axis = Direction.Axis.Z;
                        break;
                    }
                    axis = Direction.Axis.Y;
                    break;
                }
                case Y: {
                    Direction.Axis axis;
                    if (alongFirst) {
                        axis = Direction.Axis.Z;
                        break;
                    }
                    axis = Direction.Axis.X;
                    break;
                }
                default: {
                    Direction.Axis axis = pipeAxis = alongFirst ? Direction.Axis.Y : Direction.Axis.X;
                }
            }
            if (side != null && pipeAxis == side.m_122434_()) {
                return this.getFluidOptional().cast();
            }
        }
        return super.getCapability(cap, side);
    }

    private LazyOptional<IFluidHandler> getFluidOptional() {
        if (this.fluidOptional == null) {
            this.fluidOptional = LazyOptional.of(() -> this.lubricant);
        }
        return this.fluidOptional;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.fluidOptional != null) {
            this.fluidOptional.invalidate();
        }
    }

    protected void onFluidStackChanged(FluidStack newStack) {
        if (this.m_58898_() && !this.m_58904_().f_46443_) {
            this.notifyUpdate();
        }
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.lubricant.readFromNBT(compound.m_128469_("FluidContent"));
    }

    @Override
    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("FluidContent", (Tag)this.lubricant.writeToNBT(new CompoundTag()));
    }

    @Override
    protected boolean drainLubricant(int drainSpeed) {
        return this.lubricant.drain(drainSpeed, IFluidHandler.FluidAction.EXECUTE).getAmount() < drainSpeed;
    }

    @Override
    protected void addFluidInfoToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getFluidOptional());
    }
}

