/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.compat.curios;

import java.util.Map;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import rbasamoyai.createbigcannons.CBCTags;
import rbasamoyai.createbigcannons.equipment.gas_mask.GasMaskItem;
import rbasamoyai.createbigcannons.index.CBCItems;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CBCCuriosIntegration {
    private static Optional<Map<String, ICurioStacksHandler>> resolveCuriosMap(LivingEntity entity) {
        return entity.getCapability(CuriosCapability.INVENTORY).map(ICuriosItemHandler::getCurios);
    }

    public static void init(IEventBus modBus, IEventBus forgeBus) {
        modBus.addListener(CBCCuriosIntegration::onCommonSetup);
        modBus.addListener(CBCCuriosIntegration::onInterModEnqueue);
    }

    private static void onCommonSetup(FMLCommonSetupEvent event) {
        GasMaskItem.addIsWearingPredicate(player -> CBCCuriosIntegration.resolveCuriosMap(player).map(curiosMap -> (ICurioStacksHandler)curiosMap.get("head")).map(stacksHandler -> {
            IDynamicStackHandler stacks = stacksHandler.getStacks();
            int slots = stacksHandler.getSlots();
            for (int slot = 0; slot < slots; ++slot) {
                if (!stacks.getStackInSlot(slot).m_204117_(CBCTags.CBCItemTags.GAS_MASKS)) continue;
                return true;
            }
            return false;
        }).orElse(false));
        GasMaskItem.addOverlayDisplayPredicate(player -> CBCCuriosIntegration.resolveCuriosMap((LivingEntity)player).map(curiosMap -> (ICurioStacksHandler)curiosMap.get("head")).map(stacksHandler -> {
            IDynamicStackHandler stacks = stacksHandler.getStacks();
            int slots = stacksHandler.getSlots();
            for (int slot = 0; slot < slots; ++slot) {
                if (!stacks.getStackInSlot(slot).m_150930_((Item)CBCItems.GAS_MASK.get())) continue;
                return true;
            }
            return false;
        }).orElse(false));
    }

    private static void onInterModEnqueue(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.HEAD.getMessageBuilder().size(2).build());
    }
}

