/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.createnotouching.entity;

import net.mcreator.createnotouching.init.CreateNoTouchingModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class SharpEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)Blocks.f_50652_);

    public SharpEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType)CreateNoTouchingModEntities.SHARP.get(), world);
    }

    public SharpEntity(EntityType<? extends SharpEntity> type, Level world) {
        super(type, world);
    }

    public SharpEntity(EntityType<? extends SharpEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
    }

    public SharpEntity(EntityType<? extends SharpEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7846_() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack m_7941_() {
        return PROJECTILE_ITEM;
    }

    protected void m_7761_(LivingEntity entity) {
        super.m_7761_(entity);
        entity.m_21317_(entity.m_21234_() - 1);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_36703_) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123777_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.02, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.01, 0.0);
        } else {
            BlockPos hitPos = this.m_20183_();
            BlockState hitBlock = this.m_9236_().m_8055_(hitPos);
            if (this.isSoil(hitBlock)) {
                this.m_9236_().m_46796_(2001, hitPos, Block.m_49956_((BlockState)hitBlock));
                this.m_9236_().m_7731_(hitPos, Blocks.f_50493_.m_49966_(), 3);
            }
            this.m_146870_();
        }
    }

    private boolean isSoil(BlockState state) {
        return state.m_60713_(Blocks.f_50440_) || state.m_60713_(Blocks.f_50599_) || state.m_60713_(Blocks.f_50546_) || state.m_60713_(Blocks.f_152549_) || state.m_60713_(Blocks.f_50195_) || state.m_60713_(Blocks.f_50093_);
    }

    public static SharpEntity shoot(Level world, LivingEntity entity, RandomSource source) {
        return SharpEntity.shoot(world, entity, source, 1.0f, 5.0, 5);
    }

    public static SharpEntity shoot(Level world, LivingEntity entity, RandomSource source, float pullingPower) {
        return SharpEntity.shoot(world, entity, source, pullingPower * 1.0f, 5.0, 5);
    }

    public static SharpEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        SharpEntity entityarrow = new SharpEntity((EntityType<? extends SharpEntity>)((EntityType)CreateNoTouchingModEntities.SHARP.get()), entity, world);
        entityarrow.m_6686_(entity.m_20252_((float)1.0f).f_82479_, entity.m_20252_((float)1.0f).f_82480_, entity.m_20252_((float)1.0f).f_82481_, power * 2.0f, 0.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36762_(false);
        entityarrow.m_36781_(damage);
        entityarrow.m_36735_(knockback);
        world.m_7967_((Entity)entityarrow);
        world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.grass.hit")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.m_188501_() * 0.5f + 1.0f) + power / 2.0f);
        return entityarrow;
    }

    public static SharpEntity shoot(LivingEntity entity, LivingEntity target) {
        SharpEntity entityarrow = new SharpEntity((EntityType<? extends SharpEntity>)((EntityType)CreateNoTouchingModEntities.SHARP.get()), entity, entity.m_9236_());
        double dx = target.m_20185_() - entity.m_20185_();
        double dy = target.m_20186_() + (double)target.m_20192_() - 1.1;
        double dz = target.m_20189_() - entity.m_20189_();
        entityarrow.m_6686_(dx, dy - entityarrow.m_20186_() + Math.hypot(dx, dz) * (double)0.2f, dz, 2.0f, 12.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36781_(5.0);
        entityarrow.m_36735_(5);
        entityarrow.m_36762_(false);
        entity.m_9236_().m_7967_((Entity)entityarrow);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.grass.hit")), SoundSource.PLAYERS, 1.0f, 1.0f / (RandomSource.m_216327_().m_188501_() * 0.5f + 1.0f));
        return entityarrow;
    }
}

