/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.foundation.copycat;

import com.copycatsplus.copycats.compat.FlywheelCompat;
import com.copycatsplus.copycats.compat.Mods;
import com.copycatsplus.copycats.compat.SodiumCompat;
import com.copycatsplus.copycats.foundation.copycat.model.kinetic.WrappedRenderWorld;
import com.copycatsplus.copycats.utility.Platform;
import com.mojang.datafixers.util.Either;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;

public class CopycatMaterialStore {
    private final Map<ChunkPos, Map<BlockPos, Either<BlockState, Map<String, BlockState>>>> materialMap = new ConcurrentHashMap<ChunkPos, Map<BlockPos, Either<BlockState, Map<String, BlockState>>>>();
    private static final Map<BlockGetter, CopycatMaterialStore> STORES = Collections.synchronizedMap(new WeakHashMap());

    private void setMaterial(BlockPos pos, BlockState state) {
        ChunkPos chunkPos = new ChunkPos(pos);
        this.materialMap.computeIfAbsent(chunkPos, p -> new ConcurrentHashMap()).put(pos, Either.left((Object)state));
    }

    private void setMaterial(BlockPos pos, Map<String, BlockState> states) {
        ChunkPos chunkPos = new ChunkPos(pos);
        this.materialMap.computeIfAbsent(chunkPos, p -> new ConcurrentHashMap()).put(pos, Either.right(states));
    }

    private Either<BlockState, Map<String, BlockState>> getMaterial(BlockPos pos) {
        return this.materialMap.getOrDefault(new ChunkPos(pos), Map.of()).getOrDefault(pos, Either.left((Object)Blocks.f_50016_.m_49966_()));
    }

    public void unloadChunk(ChunkPos chunk) {
        this.materialMap.remove(chunk);
    }

    private static CopycatMaterialStore get(BlockGetter level) {
        if (Platform.Environment.CLIENT.isCurrent() && level instanceof WrappedRenderWorld) {
            WrappedRenderWorld wrapped = (WrappedRenderWorld)level;
            level = wrapped.getLevel();
        }
        if (Platform.Environment.CLIENT.isCurrent() && Mods.SODIUM.getLoaded()) {
            try {
                level = SodiumCompat.unwrapSodiumLevel(level);
            }
            catch (Exception wrapped) {
                // empty catch block
            }
        }
        if (level instanceof LevelChunk) {
            LevelChunk chunk = (LevelChunk)level;
            level = chunk.m_62953_();
        }
        if (Platform.Environment.CLIENT.isCurrent() && Mods.FLYWHEEL.getLoaded()) {
            try {
                level = FlywheelCompat.unwrapFlywheelLevel(level);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return STORES.computeIfAbsent(level, l -> new CopycatMaterialStore());
    }

    public static void setMaterial(BlockGetter level, BlockPos pos, BlockState state) {
        CopycatMaterialStore.get(level).setMaterial(pos, state);
    }

    public static void setMaterial(BlockGetter level, BlockPos pos, Map<String, BlockState> states) {
        CopycatMaterialStore.get(level).setMaterial(pos, states);
    }

    public static Either<BlockState, Map<String, BlockState>> getMaterial(BlockGetter level, BlockPos pos) {
        return CopycatMaterialStore.get(level).getMaterial(pos);
    }

    public static void unloadLevel(BlockGetter level) {
        STORES.remove(level);
    }

    public static void unloadChunk(BlockGetter level, ChunkPos chunk) {
        CopycatMaterialStore.get(level).unloadChunk(chunk);
    }
}

