/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.configurableextramobdrops_common_fabric.cmd;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.natamus.collective_common_fabric.functions.MessageFunctions;
import com.natamus.configurableextramobdrops_common_fabric.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class CommandCemd {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"cemd").requires(iCommandSender -> iCommandSender.method_9259(2))).executes(command -> {
            class_2168 source = (class_2168)command.getSource();
            CommandCemd.showUsage(source);
            return 1;
        })).then(class_2170.method_9247((String)"usage").executes(command -> {
            class_2168 source = (class_2168)command.getSource();
            CommandCemd.showUsage(source);
            return 1;
        }))).then(class_2170.method_9247((String)"list").executes(command -> {
            class_2168 source = (class_2168)command.getSource();
            ArrayList<String> mobnames = new ArrayList<String>();
            for (class_1299<?> et : Util.mobdrops.keySet()) {
                String lowerregister = class_7923.field_41177.method_10221(et).toString().toLowerCase();
                String[] nspl = lowerregister.split(":");
                if (nspl.length < 2) continue;
                String after = nspl[1];
                if (!nspl[0].equalsIgnoreCase("minecraft")) {
                    after = lowerregister.replace(":", "-");
                }
                mobnames.add(after);
            }
            Collections.sort(mobnames);
            StringBuilder output = new StringBuilder();
            for (String mobname : mobnames) {
                if (!output.toString().equals("")) {
                    output.append(", ");
                }
                output.append(mobname);
            }
            output.append(".");
            MessageFunctions.sendMessage((class_2168)source, (String)"Available entity names:", (class_124)class_124.field_1077, (boolean)true);
            MessageFunctions.sendMessage((class_2168)source, (String)output.toString(), (class_124)class_124.field_1054);
            MessageFunctions.sendMessage((class_2168)source, (String)"To add a drop: /cemd addhand <entity-name>", (class_124)class_124.field_1063);
            MessageFunctions.sendMessage((class_2168)source, (String)"Note: for modded entities use - not :", (class_124)class_124.field_1061);
            MessageFunctions.sendMessage((class_2168)source, (String)"", (class_124)class_124.field_1061);
            return 1;
        }))).then(class_2170.method_9247((String)"reload").executes(command -> {
            class_2168 source = (class_2168)command.getSource();
            try {
                Util.loadMobConfigFile();
            }
            catch (Exception ex) {
                MessageFunctions.sendMessage((class_2168)source, (String)"Something went wrong while reloading the mob drop config file.", (class_124)class_124.field_1061);
                ex.printStackTrace();
                return 0;
            }
            MessageFunctions.sendMessage((class_2168)source, (String)"Successfully loaded the mob drop config file.", (class_124)class_124.field_1077);
            return 1;
        }))).then(class_2170.method_9247((String)"addhand").then(class_2170.method_9244((String)"entity-name", (ArgumentType)StringArgumentType.word()).executes(command -> CommandCemd.processAddhand((CommandContext<class_2168>)command, 1.0))))).then(class_2170.method_9247((String)"addhand").then(class_2170.method_9244((String)"entity-name", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"drop-chance", (ArgumentType)DoubleArgumentType.doubleArg()).executes(command -> {
            class_2168 source = (class_2168)command.getSource();
            double chance = DoubleArgumentType.getDouble((CommandContext)command, (String)"drop-chance");
            if (chance < 0.0 || chance > 1.0) {
                MessageFunctions.sendMessage((class_2168)source, (String)"The chance has to be in between 0 and 1.0.", (class_124)class_124.field_1061);
                return 0;
            }
            return CommandCemd.processAddhand((CommandContext<class_2168>)command, chance);
        }))))).then(class_2170.method_9247((String)"cleardrops").then(class_2170.method_9244((String)"entity-name", (ArgumentType)StringArgumentType.word()).executes(command -> {
            class_2168 source = (class_2168)command.getSource();
            String entityname = StringArgumentType.getString((CommandContext)command, (String)"entity-name").toLowerCase().trim();
            class_1299<?> entitytype = null;
            for (class_1299<?> et : Util.mobdrops.keySet()) {
                String registrystring = class_7923.field_41177.method_10221(et).toString();
                if (!registrystring.contains(":")) continue;
                if (entityname.contains("-")) {
                    if (!registrystring.equalsIgnoreCase(entityname.replace("-", ":"))) continue;
                    entitytype = et;
                    break;
                }
                if (!registrystring.split(":")[1].equalsIgnoreCase(entityname)) continue;
                entitytype = et;
                break;
            }
            if (entitytype == null) {
                MessageFunctions.sendMessage((class_2168)source, (String)("Unable to find an entity with the name '" + entityname + "'."), (class_124)class_124.field_1061);
                CommandCemd.showList(source);
                return 0;
            }
            if (!Util.mobdrops.containsKey(entitytype)) {
                MessageFunctions.sendMessage((class_2168)source, (String)("Unable to find an entity with the name '" + entityname + "' in the drop hashmap."), (class_124)class_124.field_1061);
                CommandCemd.showList(source);
                return 0;
            }
            Util.mobdrops.put(entitytype, new CopyOnWriteArrayList());
            try {
                if (!Util.writeDropsMapToFile()) {
                    MessageFunctions.sendMessage((class_2168)source, (String)"!Something went wrong while writing the new config.", (class_124)class_124.field_1061);
                }
            }
            catch (Exception ex) {
                MessageFunctions.sendMessage((class_2168)source, (String)"Something went wrong while writing the new config.", (class_124)class_124.field_1061);
                ex.printStackTrace();
            }
            MessageFunctions.sendMessage((class_2168)source, (String)("Successfully cleared all drops for the entity '" + entitytype.method_5897().getString() + "'."), (class_124)class_124.field_1077);
            return 1;
        }))));
    }

    private static int processAddhand(CommandContext<class_2168> command, double dropchance) {
        class_3222 player;
        class_2168 source = (class_2168)command.getSource();
        try {
            player = source.method_9207();
        }
        catch (CommandSyntaxException ex) {
            MessageFunctions.sendMessage((class_2168)source, (String)"This command can only be executed as a player in-game.", (class_124)class_124.field_1061);
            return 1;
        }
        String entityname = StringArgumentType.getString(command, (String)"entity-name").toLowerCase().trim();
        class_1299<?> entitytype = null;
        for (class_1299<?> et : Util.mobdrops.keySet()) {
            String registrystring = class_7923.field_41177.method_10221(et).toString();
            if (!registrystring.contains(":")) continue;
            if (entityname.contains("-")) {
                if (!registrystring.equalsIgnoreCase(entityname.replace("-", ":"))) continue;
                entitytype = et;
                break;
            }
            if (!registrystring.split(":")[1].equalsIgnoreCase(entityname)) continue;
            entitytype = et;
            break;
        }
        if (entitytype == null) {
            MessageFunctions.sendMessage((class_2168)source, (String)("Unable to find an entity with the name '" + entityname + "'."), (class_124)class_124.field_1061);
            CommandCemd.showList(source);
            return 0;
        }
        if (!Util.mobdrops.containsKey(entitytype)) {
            MessageFunctions.sendMessage((class_2168)source, (String)("Unable to find an entity with the name '" + entityname + "' in the drop hashmap."), (class_124)class_124.field_1061);
            CommandCemd.showList(source);
            return 0;
        }
        class_1799 hand = player.method_6047();
        if (hand.method_7960()) {
            MessageFunctions.sendMessage((class_2168)source, (String)"Your hand is empty! Unable to add drop.", (class_124)class_124.field_1061);
            return 0;
        }
        class_1799 toadd = hand.method_7972();
        class_2487 nbt = toadd.method_7948();
        nbt.method_10549("dropchance", dropchance);
        toadd.method_7980(nbt);
        Util.mobdrops.get(entitytype).add(toadd.method_7972());
        try {
            if (!Util.writeDropsMapToFile()) {
                MessageFunctions.sendMessage((class_2168)source, (String)"!Something went wrong while writing the new config.", (class_124)class_124.field_1061);
            }
        }
        catch (Exception ex) {
            MessageFunctions.sendMessage((class_2168)source, (String)"Something went wrong while writing the new config.", (class_124)class_124.field_1061);
            ex.printStackTrace();
        }
        MessageFunctions.sendMessage((class_2168)source, (String)("Successfully added '" + toadd.method_7947() + " " + toadd.method_7964().getString().toLowerCase() + "' as a drop for the entity '" + entitytype.method_5897().getString() + "' with a drop chance of '" + dropchance + "'."), (class_124)class_124.field_1077);
        return 1;
    }

    private static void showUsage(class_2168 source) {
        MessageFunctions.sendMessage((class_2168)source, (String)"Configurable Extra Mob Drops Usage:", (class_124)class_124.field_1077, (boolean)true);
        MessageFunctions.sendMessage((class_2168)source, (String)" /cemd usage", (class_124)class_124.field_1077);
        MessageFunctions.sendMessage((class_2168)source, (String)"  Show this message.", (class_124)class_124.field_1063);
        MessageFunctions.sendMessage((class_2168)source, (String)" /cemd list", (class_124)class_124.field_1077);
        MessageFunctions.sendMessage((class_2168)source, (String)"  Lists available entities to add drops to.", (class_124)class_124.field_1063);
        MessageFunctions.sendMessage((class_2168)source, (String)" /cemd reload", (class_124)class_124.field_1077);
        MessageFunctions.sendMessage((class_2168)source, (String)"  Reloads the config file.", (class_124)class_124.field_1063);
        MessageFunctions.sendMessage((class_2168)source, (String)" /cemd addhand <entity-name>", (class_124)class_124.field_1077);
        MessageFunctions.sendMessage((class_2168)source, (String)"  Add your hand to the entity's drops with a 100% chance.", (class_124)class_124.field_1063);
        MessageFunctions.sendMessage((class_2168)source, (String)" /cemd addhand <entity-name> <drop-chance>", (class_124)class_124.field_1077);
        MessageFunctions.sendMessage((class_2168)source, (String)"  Add your hand to the entity's drops with drop-chance in between 0 and 1.0.", (class_124)class_124.field_1063);
        MessageFunctions.sendMessage((class_2168)source, (String)" /cemd cleardrops <entity-name>", (class_124)class_124.field_1077);
        MessageFunctions.sendMessage((class_2168)source, (String)"  Clears all drops of the specified entity.", (class_124)class_124.field_1063);
    }

    private static void showList(class_2168 source) {
        MessageFunctions.sendMessage((class_2168)source, (String)" /cemd list", (class_124)class_124.field_1077);
        MessageFunctions.sendMessage((class_2168)source, (String)"  Lists available entities to add drops to.", (class_124)class_124.field_1063);
    }
}

