/*
 * Decompiled with CFR 0.152.
 */
package net.mandalacreations.clean_tooltips.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.mandalacreations.clean_tooltips.CleanTooltips;
import net.mandalacreations.clean_tooltips.client.TooltipSection;
import net.mandalacreations.clean_tooltips.client.config.ClientConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.jetbrains.annotations.Nullable;

public class EnchantmentSection
extends TooltipSection {
    private static final Component ENCHANTMENTS = Component.m_237115_((String)"item.clean_tooltips.enchantments").m_130940_(ChatFormatting.GRAY);
    private static final MutableComponent SPACE = Component.m_237113_((String)" ");
    private final ListTag enchantmentTag;
    private final List<Component> curses = new ArrayList<Component>();
    private final boolean isEnchantedBook;

    public EnchantmentSection(List<Component> tooltip, ListTag enchantmentTag, boolean isEnchantedBook) {
        super(tooltip, ClientConfig.INSTANCE.enchantmentSectionEnabled());
        this.enchantmentTag = enchantmentTag;
        this.isEnchantedBook = isEnchantedBook;
    }

    public static boolean create(List<Component> tooltip, ListTag enchantmentTag, boolean isEnchantedBook) {
        EnchantmentSection section = new EnchantmentSection(tooltip, enchantmentTag, isEnchantedBook);
        section.create();
        return section.isEnabled();
    }

    @Override
    protected void buildSection() {
        for (int i = 0; i < this.enchantmentTag.size(); ++i) {
            CompoundTag tag = this.enchantmentTag.m_128728_(i);
            BuiltInRegistries.f_256876_.m_6612_(EnchantmentHelper.m_182446_((CompoundTag)tag)).ifPresent(enchantment -> this.handleEnchantment((Enchantment)enchantment, tag));
        }
        this.curses.forEach(this::addComponent);
    }

    private void handleEnchantment(Enchantment enchantment, CompoundTag tag) {
        int level = EnchantmentHelper.m_182438_((CompoundTag)tag);
        ChatFormatting color = this.getColor(enchantment, level);
        MutableComponent component = SPACE.m_6881_().m_7220_((Component)enchantment.m_44700_(level).m_6881_().m_130940_(color));
        if (enchantment.m_6589_()) {
            this.addComponent(enchantment, (Component)component, this.curses::add);
            return;
        }
        this.addComponent(enchantment, (Component)component, this::addComponent);
    }

    private void addComponent(Enchantment enchantment, Component component, Consumer<Component> consumer) {
        consumer.accept(component);
        if (CleanTooltips.ENCHANTMENT_DESCRIPTIONS_LOADED && this.isEnchantedBook) {
            this.getDescriptionKey(enchantment).ifPresent(key -> consumer.accept((Component)SPACE.m_6881_().m_7220_((Component)Component.m_237115_((String)key).m_130940_(ChatFormatting.DARK_GRAY))));
        }
    }

    private Optional<String> getDescriptionKey(Enchantment enchantment) {
        String key = enchantment.m_44704_() + ".desc";
        if (!I18n.m_118936_((String)key)) {
            if (!I18n.m_118936_((String)(enchantment.m_44704_() + ".description"))) {
                return Optional.empty();
            }
            key = enchantment.m_44704_() + ".description";
        }
        return Optional.of(key);
    }

    private ChatFormatting getColor(Enchantment enchantment, int level) {
        if (enchantment.m_6589_()) {
            return (ChatFormatting)ClientConfig.INSTANCE.curseEnchantmentColor().get();
        }
        return level >= enchantment.m_6586_() ? (ChatFormatting)ClientConfig.INSTANCE.maxLevelEnchantmentColor().get() : (ChatFormatting)ClientConfig.INSTANCE.normalEnchantmentColor().get();
    }

    @Override
    public boolean shouldDisplay() {
        return !this.enchantmentTag.isEmpty();
    }

    @Override
    @Nullable
    protected Component getHeader() {
        return ENCHANTMENTS;
    }
}

