/*
 * Decompiled with CFR 0.152.
 */
package net.mandalacreations.clean_tooltips.client;

import java.util.List;
import net.mandalacreations.clean_tooltips.client.TooltipSection;
import net.mandalacreations.clean_tooltips.client.config.ClientConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class DurabilitySection
extends TooltipSection {
    private static final Component DURABILITY = Component.m_237115_((String)"item.clean_tooltips.durability").m_130940_(ChatFormatting.GRAY);
    private final ItemStack stack;

    protected DurabilitySection(List<Component> tooltip, ItemStack stack) {
        super(tooltip, ClientConfig.INSTANCE.durabilitySectionEnabled());
        this.stack = stack;
    }

    public static void create(List<Component> tooltip, ItemStack stack) {
        new DurabilitySection(tooltip, stack).create();
    }

    @Override
    protected void buildSection() {
        int maxDamage = this.stack.m_41776_();
        int damage = this.stack.m_41773_();
        ChatFormatting color = ChatFormatting.GREEN;
        int remainingUses = maxDamage - damage;
        if ((double)remainingUses <= (double)maxDamage * 0.1) {
            color = ChatFormatting.RED;
        } else if ((double)remainingUses <= (double)maxDamage * 0.5) {
            color = ChatFormatting.YELLOW;
        }
        this.addComponent((Component)DURABILITY.m_6881_().m_7220_((Component)Component.m_237113_((String)(" " + remainingUses)).m_130940_(color)).m_7220_((Component)Component.m_237113_((String)(" / " + maxDamage))).m_130940_(ChatFormatting.GRAY));
    }

    @Override
    public boolean shouldDisplay() {
        return this.stack.m_41768_();
    }
}

