/*
 * Decompiled with CFR 0.152.
 */
package com.dsvv.cbcat.cluster_munition;

import com.dsvv.cbcat.cluster_munition.FuzedClusterProjectile;
import com.dsvv.cbcat.cluster_munition.FuzedClusterProjectileBlockEntity;
import com.dsvv.cbcat.cluster_munition.FuzedClusterProjectileBlockItem;
import com.dsvv.cbcat.registry.BlockEntityRegister;
import com.dsvv.cbcat.registry.BlockRegister;
import com.dsvv.cbcat.registry.EntityRegister;
import com.dsvv.cbcat.registry.ExtraDataRegister;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import rbasamoyai.createbigcannons.index.CBCItems;
import rbasamoyai.createbigcannons.munitions.big_cannon.AbstractBigCannonProjectile;
import rbasamoyai.createbigcannons.munitions.big_cannon.FuzedProjectileBlock;

public class FuzedClusterProjectileBlock
extends FuzedProjectileBlock<FuzedClusterProjectileBlockEntity, FuzedClusterProjectile> {
    public FuzedClusterProjectileBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean isBaseFuze() {
        return false;
    }

    public EntityType getAssociatedEntityType() {
        return (EntityType)EntityRegister.CLUSTER_PROJECTILE.get();
    }

    public Class getBlockEntityClass() {
        return FuzedClusterProjectileBlockEntity.class;
    }

    public BlockEntityType getBlockEntityType() {
        return (BlockEntityType)BlockEntityRegister.FUZED_CLUSTER_PROJECTILE_BLOCK_ENTITY.get();
    }

    public AbstractBigCannonProjectile getProjectile(Level level, List projectileBlocks) {
        FuzedClusterProjectile projectile = (FuzedClusterProjectile)super.getProjectile(level, projectileBlocks);
        projectile.setSecondaryFuze(FuzedClusterProjectileBlock.getSecondaryFuzesFromBlocks(projectileBlocks));
        projectile.setProjectile(FuzedClusterProjectileBlock.getProjectileFromBlocks(projectileBlocks));
        return projectile;
    }

    public AbstractBigCannonProjectile getProjectile(Level level, ItemStack itemStack) {
        FuzedClusterProjectile result = (FuzedClusterProjectile)super.getProjectile(level, itemStack);
        ItemStack[] fuzes = ((FuzedClusterProjectileBlockItem)itemStack.m_41720_()).getFuzesFromStack(itemStack);
        String projectile = ((FuzedClusterProjectileBlockItem)itemStack.m_41720_()).getProjectileFromStack(itemStack);
        result.setSecondaryFuze(fuzes);
        result.setProjectile(projectile);
        return result;
    }

    public AbstractBigCannonProjectile getProjectile(Level level, BlockPos pos, BlockState state) {
        FuzedClusterProjectile result = (FuzedClusterProjectile)super.getProjectile(level, pos, state);
        FuzedClusterProjectileBlockEntity clusterBE = (FuzedClusterProjectileBlockEntity)level.m_7702_(pos);
        ItemStack[] fuzes = clusterBE.getFuzes();
        String projectile = clusterBE.getProjectile();
        result.setSecondaryFuze(fuzes);
        result.setProjectile(projectile);
        return result;
    }

    public StructureTemplate.StructureBlockInfo getHandloadingInfo(ItemStack stack, BlockPos localPos, Direction cannonOrientation) {
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)cannonOrientation);
        CompoundTag baseTag = stack.m_41784_();
        if (baseTag.m_128441_("BlockEntityTag")) {
            CompoundTag tag = baseTag.m_128469_("BlockEntityTag").m_6426_();
            tag.m_128473_("x");
            tag.m_128473_("y");
            tag.m_128473_("z");
            return new StructureTemplate.StructureBlockInfo(localPos, state, tag);
        }
        return new StructureTemplate.StructureBlockInfo(localPos, state, baseTag);
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        ItemStack result = super.m_7397_(level, pos, state);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof FuzedClusterProjectileBlockEntity)) {
            return result;
        }
        FuzedClusterProjectileBlockEntity clusterBE = (FuzedClusterProjectileBlockEntity)blockEntity;
        CompoundTag baseTag = result.m_41784_();
        if (!baseTag.m_128441_("BlockEntityTag")) {
            baseTag.m_128365_("BlockEntityTag", (Tag)new CompoundTag());
        }
        CompoundTag tag = baseTag.m_128469_("BlockEntityTag");
        String projectile = clusterBE.getProjectile();
        ItemStack[] fuzes = clusterBE.getFuzes();
        ListTag fuzeTags = new ListTag();
        for (int i = 0; i < fuzes.length; ++i) {
            fuzeTags.add((Object)fuzes[i].m_41739_(new CompoundTag()));
        }
        tag.m_128365_("SecondaryFuzes", (Tag)fuzeTags);
        tag.m_128359_("Projectile", projectile);
        return result;
    }

    protected static ItemStack[] getSecondaryFuzesFromBlocks(List<StructureTemplate.StructureBlockInfo> blocks) {
        ItemStack[] itemStackArray;
        if (blocks.isEmpty()) {
            return new ItemStack[]{ItemStack.f_41583_};
        }
        StructureTemplate.StructureBlockInfo info = blocks.get(0);
        if (info.f_74677_() == null) {
            return new ItemStack[]{ItemStack.f_41583_};
        }
        BlockEntity load = BlockEntity.m_155241_((BlockPos)info.f_74675_(), (BlockState)info.f_74676_(), (CompoundTag)info.f_74677_());
        if (load instanceof FuzedClusterProjectileBlockEntity) {
            FuzedClusterProjectileBlockEntity clusterBE = (FuzedClusterProjectileBlockEntity)load;
            itemStackArray = clusterBE.getFuzes();
        } else {
            ItemStack[] itemStackArray2 = new ItemStack[1];
            itemStackArray = itemStackArray2;
            itemStackArray2[0] = ItemStack.f_41583_;
        }
        return itemStackArray;
    }

    protected static String getProjectileFromBlocks(List<StructureTemplate.StructureBlockInfo> blocks) {
        String string;
        if (blocks.isEmpty()) {
            return "";
        }
        StructureTemplate.StructureBlockInfo info = blocks.get(0);
        if (info.f_74677_() == null) {
            return "";
        }
        BlockEntity load = BlockEntity.m_155241_((BlockPos)info.f_74675_(), (BlockState)info.f_74676_(), (CompoundTag)info.f_74677_());
        if (load instanceof FuzedClusterProjectileBlockEntity) {
            FuzedClusterProjectileBlockEntity clusterBE = (FuzedClusterProjectileBlockEntity)load;
            string = clusterBE.getProjectile();
        } else {
            string = "";
        }
        return string;
    }

    public static ItemStack getHighExplosiveWithImpactFuze() {
        CompoundTag tag;
        ListTag fuzes = new ListTag();
        CompoundTag fuze = CBCItems.IMPACT_FUZE.asStack().m_41739_(new CompoundTag());
        fuzes.add((Object)fuze.m_6426_());
        fuzes.add((Object)fuze.m_6426_());
        fuzes.add((Object)fuze.m_6426_());
        fuzes.add((Object)fuze.m_6426_());
        ItemStack cluster = BlockRegister.CLUSTER_BLOCK.asStack();
        CompoundTag baseTag = cluster.m_41784_();
        if (!baseTag.m_128441_("BlockEntityTag")) {
            baseTag.m_128365_("BlockEntityTag", (Tag)new CompoundTag());
        }
        if ((tag = baseTag.m_128469_("BlockEntityTag")).m_128441_("SecondaryFuzes")) {
            tag.m_128473_("SecondaryFuzes");
        }
        tag.m_128365_("SecondaryFuzes", (Tag)fuzes);
        tag.m_128359_("Projectile", ExtraDataRegister.clusterPartsReverse((EntityType)EntityRegister.HA_HE_PROJECTILE.get()));
        return cluster;
    }

    public static ItemStack getHighExplosiveFragmentationWithImpactFuze() {
        CompoundTag tag;
        ListTag fuzes = new ListTag();
        CompoundTag fuze = CBCItems.IMPACT_FUZE.asStack().m_41739_(new CompoundTag());
        fuzes.add((Object)fuze.m_6426_());
        fuzes.add((Object)fuze.m_6426_());
        fuzes.add((Object)fuze.m_6426_());
        fuzes.add((Object)fuze.m_6426_());
        ItemStack cluster = BlockRegister.CLUSTER_BLOCK.asStack();
        CompoundTag baseTag = cluster.m_41784_();
        if (!baseTag.m_128441_("BlockEntityTag")) {
            baseTag.m_128365_("BlockEntityTag", (Tag)new CompoundTag());
        }
        if ((tag = baseTag.m_128469_("BlockEntityTag")).m_128441_("SecondaryFuzes")) {
            tag.m_128473_("SecondaryFuzes");
        }
        tag.m_128365_("SecondaryFuzes", (Tag)fuzes);
        tag.m_128359_("Projectile", ExtraDataRegister.clusterPartsReverse((EntityType)EntityRegister.HA_HEF_PROJECTILE.get()));
        return cluster;
    }

    public static ItemStack getHighExplosiveAntiTankWithImpactFuze() {
        CompoundTag tag;
        ListTag fuzes = new ListTag();
        CompoundTag fuze = CBCItems.IMPACT_FUZE.asStack().m_41739_(new CompoundTag());
        fuzes.add((Object)fuze.m_6426_());
        fuzes.add((Object)fuze.m_6426_());
        fuzes.add((Object)fuze.m_6426_());
        fuzes.add((Object)fuze.m_6426_());
        ItemStack cluster = BlockRegister.CLUSTER_BLOCK.asStack();
        CompoundTag baseTag = cluster.m_41784_();
        if (!baseTag.m_128441_("BlockEntityTag")) {
            baseTag.m_128365_("BlockEntityTag", (Tag)new CompoundTag());
        }
        if ((tag = baseTag.m_128469_("BlockEntityTag")).m_128441_("SecondaryFuzes")) {
            tag.m_128473_("SecondaryFuzes");
        }
        tag.m_128365_("SecondaryFuzes", (Tag)fuzes);
        tag.m_128359_("Projectile", ExtraDataRegister.clusterPartsReverse((EntityType)EntityRegister.HA_HEAT_PROJECTILE.get()));
        return cluster;
    }

    public static ItemStack getSmokeWithImpactFuze() {
        CompoundTag tag;
        ListTag fuzes = new ListTag();
        CompoundTag fuze = CBCItems.IMPACT_FUZE.asStack().m_41739_(new CompoundTag());
        fuzes.add((Object)fuze.m_6426_());
        fuzes.add((Object)fuze.m_6426_());
        fuzes.add((Object)fuze.m_6426_());
        fuzes.add((Object)fuze.m_6426_());
        ItemStack cluster = BlockRegister.CLUSTER_BLOCK.asStack();
        CompoundTag baseTag = cluster.m_41784_();
        if (!baseTag.m_128441_("BlockEntityTag")) {
            baseTag.m_128365_("BlockEntityTag", (Tag)new CompoundTag());
        }
        if ((tag = baseTag.m_128469_("BlockEntityTag")).m_128441_("SecondaryFuzes")) {
            tag.m_128473_("SecondaryFuzes");
        }
        tag.m_128365_("SecondaryFuzes", (Tag)fuzes);
        tag.m_128359_("Projectile", ExtraDataRegister.clusterPartsReverse((EntityType)EntityRegister.HA_SMOKE_PROJECTILE.get()));
        return cluster;
    }
}

