/*
 * Decompiled with CFR 0.152.
 */
package com.dsvv.cbcat.cartridge;

import com.dsvv.cbcat.cartridge.ProjectileCartridge;
import com.dsvv.cbcat.registry.ExtraDataRegister;
import com.simibubi.create.foundation.block.IBE;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBehavior;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.index.CBCEntityTypes;
import rbasamoyai.createbigcannons.index.CBCMunitionPropertiesHandlers;
import rbasamoyai.createbigcannons.munitions.big_cannon.BigCannonMunitionBlock;
import rbasamoyai.createbigcannons.munitions.big_cannon.ProjectileBlock;
import rbasamoyai.createbigcannons.munitions.big_cannon.config.BigCannonCommonShellProperties;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.AbstractFluidShellBlockEntity;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.FluidShellBlock;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.FluidShellProjectile;
import rbasamoyai.createbigcannons.munitions.big_cannon.propellant.config.BigCartridgeProperties;

public class FluidProjectileCartridgeBlock
extends FluidShellBlock
implements ProjectileCartridge,
IBE<AbstractFluidShellBlockEntity>,
BigCannonMunitionBlock {
    private boolean used;
    private boolean multipleCharges = true;
    private String name;

    public FluidProjectileCartridgeBlock(BlockBehaviour.Properties properties, String name) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)Direction.NORTH));
        this.used = false;
        this.name = name;
    }

    public FluidProjectileCartridgeBlock(BlockBehaviour.Properties properties, String name, boolean multipleCharges) {
        this(properties, name);
        this.multipleCharges = multipleCharges;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BigCannonBlock cblock;
        Direction facing = context.m_43719_();
        Player player = context.m_43723_();
        boolean flag = player != null && player.m_6144_();
        BlockState clickedState = context.m_43725_().m_8055_(context.m_8083_().m_121945_(facing.m_122424_()));
        Block block = clickedState.m_60734_();
        if (block instanceof BigCannonBlock && (cblock = (BigCannonBlock)block).getFacing(clickedState).m_122434_() == facing.m_122434_() && !flag) {
            facing = facing.m_122424_();
        } else if (clickedState.m_60734_() instanceof ProjectileBlock && ((Direction)clickedState.m_61143_((Property)ProjectileBlock.f_52588_)).m_122434_() == facing.m_122434_() && !flag) {
            facing = facing.m_122424_();
        }
        return (BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)facing);
    }

    public boolean isValidAddition(List<StructureTemplate.StructureBlockInfo> total, StructureTemplate.StructureBlockInfo self, int index, Direction dir) {
        return this.canBeIgnited(self, dir) && total.size() == 1 && total.get(0) == self && index == 0;
    }

    public boolean canBeIgnited(StructureTemplate.StructureBlockInfo data, Direction dir) {
        return data.f_74676_().m_61143_((Property)f_52588_) == dir;
    }

    public StructureTemplate.StructureBlockInfo getHandloadingInfo(ItemStack stack, BlockPos localPos, Direction cannonOrientation) {
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)cannonOrientation);
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_().m_128469_("BlockEntityTag").m_6426_();
            tag.m_128473_("x");
            tag.m_128473_("y");
            tag.m_128473_("z");
            tag.m_128405_("Power", stack.m_41784_().m_128451_("Power"));
            return new StructureTemplate.StructureBlockInfo(localPos, state, tag);
        }
        tag.m_128405_("Power", stack.m_41784_().m_128451_("Power"));
        return new StructureTemplate.StructureBlockInfo(localPos, state, tag);
    }

    public ItemStack getExtractedItem(StructureTemplate.StructureBlockInfo info) {
        ItemStack stack = ItemStack.f_41583_;
        if (!this.used) {
            stack = ExtraDataRegister.getCartridge(this.name).asStack();
            stack.m_41751_(info.f_74677_());
        }
        return stack;
    }

    public int getMaximumPowerLevels() {
        return ((BigCartridgeProperties)CBCMunitionPropertiesHandlers.BIG_CARTRIDGE.getPropertiesOf((Object)this)).maxPowerLevels() - 1;
    }

    public boolean isBaseFuze() {
        return ((BigCannonCommonShellProperties)CBCMunitionPropertiesHandlers.COMMON_SHELL_BIG_CANNON_PROJECTILE.getPropertiesOf(this.getAssociatedEntityType())).fuze().baseFuze();
    }

    public EntityType<FluidShellProjectile> getAssociatedEntityType() {
        return (EntityType)CBCEntityTypes.FLUID_SHELL.get();
    }

    public float getChargePower(StructureTemplate.StructureBlockInfo structureBlockInfo) {
        return this.multipleCharges ? 1.5f : 7.5f;
    }

    public float getChargePower(ItemStack itemStack) {
        return this.multipleCharges ? 1.5f : 7.5f;
    }

    public float getStressOnCannon(StructureTemplate.StructureBlockInfo structureBlockInfo) {
        return this.multipleCharges ? 0.5f : 1.0f;
    }

    public float getStressOnCannon(ItemStack itemStack) {
        return this.multipleCharges ? 0.5f : 1.0f;
    }

    public float getSpread(StructureTemplate.StructureBlockInfo structureBlockInfo) {
        return this.multipleCharges ? 4.0f : 10.0f;
    }

    public float getRecoil(StructureTemplate.StructureBlockInfo structureBlockInfo) {
        return this.multipleCharges ? 1.0f : 2.0f;
    }

    public void consumePropellant(BigCannonBehavior behavior) {
        this.used = true;
    }

    @Override
    public boolean allowsMultipleCharges() {
        return this.multipleCharges;
    }
}

