/*
 * Decompiled with CFR 0.152.
 */
package com.dsvv.cbcat.cannon.heavy_autocannon.qf_breech;

import com.dsvv.cbcat.cannon.heavy_autocannon.HeavyAutocannonBlock;
import com.dsvv.cbcat.cannon.heavy_autocannon.qf_breech.HeavyAutocannonQuickFireBreechBlock;
import com.dsvv.cbcat.cannon.heavy_autocannon.qf_breech.HeavyAutocannonQuickFireBreechBlockEntity;
import com.dsvv.cbcat.registry.ExtraDataRegister;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.OrientedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import rbasamoyai.createbigcannons.index.CBCAutocannonMaterials;

public class HeavyAutocannonQuickFireBreechInstance
extends AbstractBlockEntityVisual<HeavyAutocannonQuickFireBreechBlockEntity>
implements SimpleDynamicVisual {
    private final OrientedInstance breechblock;
    private final Direction blockRotation;

    public HeavyAutocannonQuickFireBreechInstance(VisualizationContext ctx, HeavyAutocannonQuickFireBreechBlockEntity blockEntity, float partialTick) {
        super(ctx, (BlockEntity)blockEntity, partialTick);
        Direction.Axis axis = HeavyAutocannonQuickFireBreechInstance.getRotationAxis(this.blockState);
        Direction facing = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61372_);
        Direction blockRotation = facing.m_175364_(axis);
        if (blockRotation == Direction.DOWN) {
            blockRotation = Direction.UP;
        }
        this.blockRotation = blockRotation;
        this.breechblock = (OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)this.getPartialModelForState(this.blockState))).createInstance();
        boolean alongFirst = (Boolean)this.blockState.m_61143_((Property)HeavyAutocannonQuickFireBreechBlock.AXIS);
        if (alongFirst) {
            this.breechblock.rotateYDegrees(90.0f);
        }
        if (facing.m_122434_().m_122479_()) {
            this.breechblock.rotateTo(Direction.NORTH, Direction.UP);
        }
        this.transformModels(partialTick);
    }

    private void transformModels(float partialTick) {
        float progress = ((HeavyAutocannonQuickFireBreechBlockEntity)this.blockEntity).getOpenProgress(partialTick);
        BlockPos visualPos = this.getVisualPosition();
        float renderedBreechblockOffset = progress / 16.0f * 13.0f;
        Vector3f normal = this.blockRotation.m_175362_(Direction.Axis.X).m_253071_();
        normal.mul(renderedBreechblockOffset);
        this.breechblock.position((Vec3i)visualPos).translatePosition(normal.x(), normal.y(), normal.z()).setChanged();
    }

    private PartialModel getPartialModelForState(BlockState state) {
        PartialModel partialModel;
        Block block = state.m_60734_();
        if (block instanceof HeavyAutocannonBlock) {
            HeavyAutocannonBlock cBlock = (HeavyAutocannonBlock)block;
            partialModel = ExtraDataRegister.heavyAutocannonBreechblockFor(cBlock.getAutocannonMaterial());
        } else {
            partialModel = ExtraDataRegister.heavyAutocannonBreechblockFor(CBCAutocannonMaterials.CAST_IRON);
        }
        return partialModel;
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept((Instance)this.breechblock);
    }

    public void updateLight(float v) {
        this.relight(this.pos, new FlatLit[]{this.breechblock});
    }

    protected void _delete() {
        this.breechblock.delete();
    }

    public void beginFrame(DynamicVisual.Context context) {
        this.transformModels(context.partialTick());
    }

    private static Direction.Axis getRotationAxis(BlockState state) {
        boolean flag = (Boolean)state.m_61143_((Property)HeavyAutocannonQuickFireBreechBlock.AXIS);
        return switch (((Direction)state.m_61143_((Property)HeavyAutocannonQuickFireBreechBlock.f_52588_)).m_122434_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> {
                if (flag) {
                    yield Direction.Axis.Y;
                }
                yield Direction.Axis.Z;
            }
            case Direction.Axis.Y -> {
                if (flag) {
                    yield Direction.Axis.X;
                }
                yield Direction.Axis.Z;
            }
            case Direction.Axis.Z -> flag ? Direction.Axis.X : Direction.Axis.Y;
        };
    }
}

