/*
 * Decompiled with CFR 0.152.
 */
package com.dsvv.cbcat.base;

import com.dsvv.cbcat.base.IBigCannonBlockPhysics;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import rbasamoyai.createbigcannons.munitions.big_cannon.propellant.BigCannonPropellantBlock;
import rbasamoyai.createbigcannons.munitions.big_cannon.propellant.IntegratedPropellantProjectile;
import rbasamoyai.createbigcannons.munitions.config.BigCannonPropellantCompatibilities;
import rbasamoyai.createbigcannons.munitions.config.BigCannonPropellantCompatibilityHandler;

public class CustomPropellantContext {
    public float chargesUsed = 0.0f;
    public float drag = 0.0f;
    public float explosionGas = 0.0f;
    public float recoil = 0.0f;
    public float stress = 0.0f;
    public float smokeScale = 1.0f;
    public float spread = 0.0f;
    public float volume = 1.0f;
    public List<StructureTemplate.StructureBlockInfo> propellantBlocks = new ArrayList<StructureTemplate.StructureBlockInfo>();
    private float velocity;
    private boolean doomedToFail = false;

    public void isDoomedToFail() {
        this.doomedToFail = true;
    }

    public boolean getDoomedToFail() {
        return this.doomedToFail;
    }

    public boolean addPropellant(BigCannonPropellantBlock propellant, StructureTemplate.StructureBlockInfo info, Direction initialOrientation) {
        this.propellantBlocks.add(info);
        if (!CustomPropellantContext.safeLoad((List<StructureTemplate.StructureBlockInfo>)ImmutableList.copyOf(this.propellantBlocks), initialOrientation)) {
            return false;
        }
        float power = Math.max(0.0f, propellant.getChargePower(info));
        this.chargesUsed += power;
        this.explosionGas += 0.8f * power;
        this.recoil += power * 0.8f;
        this.smokeScale += power;
        this.stress += propellant.getStressOnCannon(info);
        this.spread += propellant.getSpread(info);
        return true;
    }

    public void addBarrel(IBigCannonBlockPhysics cannonBlock) {
        CustomPropellantContext newCtx = cannonBlock.applyBarrelPhysic(this);
        this.explosionGas = newCtx.explosionGas;
        this.drag = newCtx.drag;
        this.recoil = newCtx.recoil;
        this.stress = newCtx.stress;
        this.smokeScale = newCtx.smokeScale;
        this.spread = newCtx.spread;
        this.volume = newCtx.volume;
        this.recoil += Math.max(0.0f, this.explosionGas) * 0.75f;
        this.velocity += Math.max(0.0f, this.explosionGas);
    }

    public boolean addIntegratedPropellant(IntegratedPropellantProjectile propellant, StructureTemplate.StructureBlockInfo firstInfo, Direction initialOrientation) {
        ImmutableList copy = ImmutableList.builder().addAll(this.propellantBlocks).add((Object)firstInfo).build();
        if (!CustomPropellantContext.safeLoad((List<StructureTemplate.StructureBlockInfo>)copy, initialOrientation)) {
            return false;
        }
        this.explosionGas += 1.0f;
        float power = Math.max(0.0f, propellant.getChargePower());
        this.chargesUsed += power;
        this.smokeScale += power;
        this.recoil += power * 0.8f;
        this.stress += propellant.getStressOnCannon();
        this.spread += propellant.getSpread();
        return true;
    }

    public float getVelocity() {
        return Math.max(0.0f, this.velocity + this.chargesUsed - this.drag);
    }

    public static boolean safeLoad(List<StructureTemplate.StructureBlockInfo> propellant, Direction orientation) {
        HashMap<Block, Integer> allowedCounts = new HashMap<Block, Integer>();
        HashMap<Block, Integer> actualCounts = new HashMap<Block, Integer>();
        ListIterator<StructureTemplate.StructureBlockInfo> iter = propellant.listIterator();
        while (iter.hasNext()) {
            BigCannonPropellantBlock cpropel;
            int index = iter.nextIndex();
            StructureTemplate.StructureBlockInfo info = iter.next();
            Block block = info.f_74676_().m_60734_();
            if (!(block instanceof BigCannonPropellantBlock) || !(cpropel = (BigCannonPropellantBlock)block).isValidAddition(info, index, orientation)) {
                return false;
            }
            if (actualCounts.containsKey(block)) {
                actualCounts.put(block, (Integer)actualCounts.get(block) + 1);
            } else {
                actualCounts.put(block, 1);
            }
            BigCannonPropellantCompatibilities compatibilities = BigCannonPropellantCompatibilityHandler.getCompatibilities((Block)block);
            for (Map.Entry entry : compatibilities.validPropellantCounts().entrySet()) {
                Block block1 = (Block)entry.getKey();
                int oldCount = allowedCounts.getOrDefault(block1, -1);
                int newCount = (Integer)entry.getValue();
                if (newCount < 0 || oldCount >= 0 && newCount >= oldCount) continue;
                allowedCounts.put(block1, newCount);
            }
        }
        for (Map.Entry entry : actualCounts.entrySet()) {
            Block block = (Block)entry.getKey();
            if (!allowedCounts.containsKey(block) || (Integer)allowedCounts.get(block) >= (Integer)entry.getValue()) continue;
            return false;
        }
        return true;
    }
}

