/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.common.entity.animal;

import com.google.common.collect.Lists;
import com.teamabnormals.caverns_and_chasms.common.entity.ai.goal.RatDevourRottenFleshGoal;
import com.teamabnormals.caverns_and_chasms.core.other.tags.CCItemTags;
import com.teamabnormals.caverns_and_chasms.core.registry.CCItems;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.ShoulderRidingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.eventbus.api.Event;

public class Rat
extends ShoulderRidingEntity {
    private static final Predicate<Rat> FRIEND_RATS = entity -> !entity.m_6162_() && entity.m_6084_();
    private static final Predicate<ItemEntity> ALLOWED_ITEMS = entity -> !entity.m_32063_() && entity.m_6084_();
    private static final Predicate<Entity> AVOID_PLAYERS = entity -> !entity.m_20163_() && EntitySelector.f_20406_.test(entity);
    private static final EntityDataAccessor<Integer> RAT_TYPE = SynchedEntityData.m_135353_(Rat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> COLLAR_COLOR = SynchedEntityData.m_135353_(Rat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> TRUSTING = SynchedEntityData.m_135353_(Rat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RUNNING_AWAY = SynchedEntityData.m_135353_(Rat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private List<Rat> group = Lists.newArrayList();
    private int eatTicks;
    private Player tamer;

    public Rat(EntityType<? extends Rat> type, Level worldIn) {
        super(type, worldIn);
        this.m_21553_(true);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.f_21345_.m_25352_(3, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new RatTemptGoal());
        this.f_21345_.m_25352_(6, (Goal)new RatJumpOnOwnersShoulderGoal());
        this.f_21345_.m_25352_(6, (Goal)new RatDevourRottenFleshGoal(this, 1.25, 16, 4));
        this.f_21345_.m_25352_(7, (Goal)new RatStayInGroupGoal());
        this.f_21345_.m_25352_(8, (Goal)new RatFollowParentGoal());
        this.f_21345_.m_25352_(9, new RatAvoidEntityGoal<Player>(Player.class, 10.0f, 1.0, 1.2f, AVOID_PLAYERS::test));
        this.f_21345_.m_25352_(10, (Goal)new RatRandomStrollGoal());
        this.f_21345_.m_25352_(11, (Goal)new RatFindItemsGoal());
        this.f_21345_.m_25352_(12, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(12, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new RatStopAttackingGoal());
        this.f_21346_.m_25352_(4, (Goal)new RatHurtByTargetGoal().m_26044_(new Class[0]));
        this.f_21346_.m_25352_(5, new RatRandomTargetGoal<Player>(Player.class, true, null));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RAT_TYPE, (Object)0);
        this.f_19804_.m_135372_(COLLAR_COLOR, (Object)DyeColor.RED.m_41060_());
        this.f_19804_.m_135372_(TRUSTING, (Object)false);
        this.f_19804_.m_135372_(RUNNING_AWAY, (Object)false);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22281_, 1.0);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11944_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11948_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11946_;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Type", this.getRatType());
        compound.m_128344_("CollarColor", (byte)this.getCollarColor().m_41060_());
        compound.m_128379_("Trusting", this.isTrusting());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setRatType(compound.m_128451_("Type"));
        if (compound.m_128425_("CollarColor", 99)) {
            this.setCollarColor(DyeColor.m_41053_((int)compound.m_128451_("CollarColor")));
        }
        this.setTrusting(compound.m_128471_("Trusting"));
    }

    private void setRatType(int id) {
        this.f_19804_.m_135381_(RAT_TYPE, (Object)id);
    }

    public int getRatType() {
        return (Integer)this.f_19804_.m_135370_(RAT_TYPE);
    }

    public DyeColor getCollarColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(COLLAR_COLOR)));
    }

    public void setCollarColor(DyeColor color) {
        this.f_19804_.m_135381_(COLLAR_COLOR, (Object)color.m_41060_());
    }

    boolean isTrusting() {
        return (Boolean)this.f_19804_.m_135370_(TRUSTING);
    }

    private void setTrusting(boolean trusting) {
        this.f_19804_.m_135381_(TRUSTING, (Object)trusting);
    }

    boolean isRunningAway() {
        return (Boolean)this.f_19804_.m_135370_(RUNNING_AWAY);
    }

    private void setRunningAway(boolean runningAway) {
        this.f_19804_.m_135381_(RUNNING_AWAY, (Object)runningAway);
    }

    public void m_8107_() {
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.m_21515_()) {
            ++this.eatTicks;
            ItemStack itemstack = this.m_21205_();
            if (this.canEatItem(itemstack)) {
                if (this.eatTicks > 600) {
                    ItemStack itemstack1 = itemstack.m_41671_(this.m_9236_(), (LivingEntity)this);
                    if (!itemstack1.m_41619_()) {
                        this.m_8061_(EquipmentSlot.MAINHAND, itemstack1);
                    }
                    this.eatTicks = 0;
                } else if (this.eatTicks > 560 && this.f_19796_.m_188501_() < 0.1f) {
                    this.m_5496_(this.m_7866_(itemstack), 1.0f, 1.0f);
                    this.m_9236_().m_7605_((Entity)this, (byte)45);
                }
            }
            List rats = this.m_9236_().m_6443_(Rat.class, this.m_20191_().m_82377_(8.0, 4.0, 8.0), FRIEND_RATS.and(entity -> entity.m_21824_() == this.m_21824_()));
            rats.sort(Comparator.comparing(arg_0 -> ((Rat)this).m_20280_(arg_0)));
            this.group = rats.stream().limit(4L).collect(Collectors.toList());
        }
        super.m_8107_();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (this.m_21824_()) {
            if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                this.m_142075_(player, hand, itemstack);
                this.m_5634_(item.m_41473_().m_38744_());
                this.m_146852_(GameEvent.f_157806_, (Entity)this);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (item instanceof DyeItem) {
                DyeColor dyecolor = ((DyeItem)item).m_41089_();
                if (dyecolor == this.getCollarColor()) return super.m_6071_(player, hand);
                this.setCollarColor(dyecolor);
                this.m_142075_(player, hand, itemstack);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            InteractionResult interactionresult = super.m_6071_(player, hand);
            if (interactionresult.m_19077_() || !this.m_21830_((LivingEntity)player)) return interactionresult;
            this.f_20899_ = false;
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            this.m_21839_(!this.m_21827_());
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (!this.isTrusting() && (this.m_5448_() == player || this.isRunningAway()) || !itemstack.m_204117_(CCItemTags.RAT_TAME_ITEMS)) return super.m_6071_(player, hand);
        this.m_142075_(player, hand, itemstack);
        if (this.m_9236_().f_46443_) return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
            this.m_21828_(player);
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            this.m_21839_(true);
            this.m_9236_().m_7605_((Entity)this, (byte)7);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        } else {
            this.m_9236_().m_7605_((Entity)this, (byte)6);
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    public void setTamer(Player entity) {
        this.tamer = entity;
    }

    public Player getTamer() {
        return this.tamer;
    }

    public List<Rat> getGroup() {
        return this.group;
    }

    public int getFriendAmount() {
        int size = this.group.size();
        return this.m_6162_() ? size : size - 1;
    }

    public boolean isSurroundedByFriends() {
        return this.getFriendAmount() > 0;
    }

    public boolean trustsPlayers() {
        return this.isTrusting() || this.m_21824_();
    }

    public boolean shouldAttack(LivingEntity target) {
        if (this.getFriendAmount() > 1 && this.tamer == null) {
            if (target instanceof Player) {
                return !this.trustsPlayers();
            }
            return true;
        }
        return false;
    }

    public boolean shouldRunAway() {
        return !this.trustsPlayers() && this.getFriendAmount() <= 1;
    }

    public Vec3 findGroupCenter(List<Rat> groupIn) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (Rat friend : groupIn) {
            x += friend.m_20185_();
            y += friend.m_20186_();
            z += friend.m_20189_();
        }
        return new Vec3(x / (double)groupIn.size(), y / (double)groupIn.size(), z / (double)groupIn.size());
    }

    public float getTailWagAmount() {
        if (this.m_21824_()) {
            float f = Mth.m_14036_((float)(1.0f - (this.m_21233_() - this.m_21223_()) / this.m_21233_()), (float)0.0f, (float)1.0f);
            return this.m_20069_() ? f : f * 1.5f;
        }
        return this.m_20069_() ? 1.0f : 1.5f;
    }

    protected void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        if (random.m_188501_() < 0.2f) {
            float f = random.m_188501_();
            ItemStack itemstack = f < 0.05f ? new ItemStack((ItemLike)Items.f_42415_) : (f < 0.2f ? (random.m_188499_() ? new ItemStack((ItemLike)Items.f_151053_) : new ItemStack((ItemLike)CCItems.RAW_SILVER.get())) : (f < 0.4f ? (random.m_188499_() ? new ItemStack((ItemLike)Items.f_42534_) : new ItemStack((ItemLike)CCItems.SPINEL.get())) : (f < 0.6f ? new ItemStack((ItemLike)Items.f_42451_) : (f < 0.8f ? new ItemStack((ItemLike)Items.f_42518_) : new ItemStack((ItemLike)Items.f_42500_)))));
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack);
        }
    }

    public boolean m_6898_(ItemStack itemstack) {
        return itemstack.m_204117_(CCItemTags.RAT_FOOD);
    }

    private boolean canEatItem(ItemStack itemStackIn) {
        return itemStackIn.m_41720_().m_41472_() && this.m_5448_() == null && this.m_20096_();
    }

    public boolean m_7066_(ItemStack itemstackIn) {
        EquipmentSlot equipmentslottype = Mob.m_147233_((ItemStack)itemstackIn);
        if (!this.m_6844_(equipmentslottype).m_41619_()) {
            return false;
        }
        return equipmentslottype == EquipmentSlot.MAINHAND && super.m_7066_(itemstackIn);
    }

    public boolean m_7252_(ItemStack stack) {
        Item item = stack.m_41720_();
        ItemStack itemstack = this.m_21205_();
        return itemstack.m_41619_() || this.eatTicks > 0 && item.m_41472_() && !itemstack.m_41720_().m_41472_();
    }

    private void spitOutItem(ItemStack stackIn) {
        if (!stackIn.m_41619_() && !this.m_9236_().f_46443_) {
            ItemEntity itementity = new ItemEntity(this.m_9236_(), this.m_20185_() + this.m_20154_().f_82479_, this.m_20186_() + 1.0, this.m_20189_() + this.m_20154_().f_82481_, stackIn);
            itementity.m_32010_(40);
            itementity.m_32052_(this.m_20148_());
            this.m_5496_(SoundEvents.f_11952_, 1.0f, 1.0f);
            this.m_9236_().m_7967_((Entity)itementity);
        }
    }

    private void spawnItem(ItemStack stackIn) {
        ItemEntity itementity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), stackIn);
        this.m_9236_().m_7967_((Entity)itementity);
    }

    protected void m_7581_(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.m_32055_();
        if (this.m_7252_(itemstack)) {
            int i = itemstack.m_41613_();
            if (i > 1) {
                this.spawnItem(itemstack.m_41620_(i - 1));
            }
            this.spitOutItem(this.m_21205_());
            this.m_21053_(itemEntity);
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_41620_(1));
            this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = 2.0f;
            this.m_7938_((Entity)itemEntity, itemstack.m_41613_());
            itemEntity.m_146870_();
            this.eatTicks = 0;
        }
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.5f;
    }

    public void m_7105_(boolean tamed) {
        super.m_7105_(tamed);
        if (tamed) {
            this.m_21051_(Attributes.f_22276_).m_22100_(10.0);
            this.m_21153_(10.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(4.0);
        }
    }

    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        if (this.getFriendAmount() < 2) {
            return false;
        }
        if (!(target instanceof Creeper) && !(target instanceof Ghast)) {
            if (target instanceof Wolf) {
                Wolf wolf = (Wolf)target;
                return !wolf.m_21824_() || wolf.m_269323_() != owner;
            }
            if (target instanceof Player && owner instanceof Player && !((Player)owner).m_7099_((Player)target)) {
                return false;
            }
            if (target instanceof AbstractHorse && ((AbstractHorse)target).m_30614_()) {
                return false;
            }
            return !(target instanceof TamableAnimal) || !((TamableAnimal)target).m_21824_();
        }
        return false;
    }

    public void m_27563_(ServerLevel level, Animal otherParent) {
        Rat firstbaby = null;
        int babies = this.f_19796_.m_188503_(4) + 1;
        boolean babyspawned = false;
        for (int i = 0; i < babies; ++i) {
            Rat ageablemob = this.getBreedOffspring(level, (AgeableMob)otherParent);
            BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((Mob)this, (Mob)otherParent, (AgeableMob)ageablemob);
            boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)event);
            ageablemob = event.getChild();
            if (cancelled) {
                this.m_146762_(6000);
                otherParent.m_146762_(6000);
                this.m_27594_();
                otherParent.m_27594_();
                return;
            }
            if (ageablemob == null) continue;
            babyspawned = true;
            if (firstbaby == null) {
                firstbaby = ageablemob;
            }
            ageablemob.m_6863_(true);
            ageablemob.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
            level.m_47205_((Entity)ageablemob);
            level.m_7605_((Entity)this, (byte)18);
        }
        if (babyspawned) {
            ServerPlayer serverplayer = this.m_27592_();
            if (serverplayer == null && otherParent.m_27592_() != null) {
                serverplayer = otherParent.m_27592_();
            }
            if (serverplayer != null) {
                serverplayer.m_36220_(Stats.f_12937_);
                CriteriaTriggers.f_10581_.m_147278_(serverplayer, (Animal)this, otherParent, firstbaby);
            }
            this.m_146762_(6000);
            otherParent.m_146762_(6000);
            this.m_27594_();
            otherParent.m_27594_();
            if (level.m_46469_().m_46207_(GameRules.f_46135_)) {
                level.m_7967_((Entity)new ExperienceOrb((Level)level, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_217043_().m_188503_(7) + 1));
            }
        }
    }

    public Rat getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return this;
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction function) {
        super.m_7332_(passenger);
        float f = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        function.m_20372_(passenger, this.m_20185_() + (double)(0.1f * f), this.m_20227_(0.5) + passenger.m_6049_() + 0.0, this.m_20189_() - (double)(0.1f * f1));
        if (passenger instanceof LivingEntity) {
            ((LivingEntity)passenger).f_20883_ = this.f_20883_;
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficulty, reason, spawnDataIn, dataTag);
        float chance = this.f_19796_.m_188501_();
        RatType type = chance < 0.05f ? RatType.WHITE : (chance < 0.3f ? RatType.BROWN : (chance < 0.65f ? RatType.GRAY : RatType.BLUE));
        this.setRatType(type.getId());
        this.m_213945_(this.f_19796_, difficulty);
        return super.m_6518_(worldIn, difficulty, reason, spawnDataIn, dataTag);
    }

    class RatTemptGoal
    extends TemptGoal {
        public RatTemptGoal() {
            super((PathfinderMob)Rat.this, 1.0, Ingredient.m_204132_(CCItemTags.RAT_FOOD), false);
        }

        public boolean m_8036_() {
            return Rat.this.trustsPlayers() && super.m_8036_();
        }
    }

    class RatJumpOnOwnersShoulderGoal
    extends Goal {
        private ServerPlayer owner;

        public RatJumpOnOwnersShoulderGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return !Rat.this.m_21827_() && Rat.this.m_29897_() && this.shouldJumpOnShoulder();
        }

        public void m_8056_() {
            this.owner = (ServerPlayer)Rat.this.m_269323_();
        }

        public void m_8041_() {
            this.owner = null;
        }

        public void m_8037_() {
            if (!Rat.this.m_21825_() && !Rat.this.m_21523_() && Rat.this.m_20191_().m_82381_(this.owner.m_20191_())) {
                Rat.this.m_29895_(this.owner);
            } else {
                Rat.this.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)Rat.this.m_8132_());
                Rat.this.m_21573_().m_5624_((Entity)this.owner, 1.0);
            }
        }

        private boolean shouldJumpOnShoulder() {
            ServerPlayer owner = (ServerPlayer)Rat.this.m_269323_();
            return owner != null && owner.m_6047_() && !owner.m_5833_() && !owner.m_150110_().f_35935_ && !owner.m_20069_() && !owner.f_146808_;
        }
    }

    class RatStayInGroupGoal
    extends Goal {
        private Vec3 groupCenter;
        private int timeToRecalcPath;

        public RatStayInGroupGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!Rat.this.m_21824_() && !Rat.this.m_6162_() && Rat.this.isSurroundedByFriends()) {
                this.setGroupCenter();
                return Rat.this.m_20238_(this.groupCenter) > 16.0;
            }
            return false;
        }

        public boolean m_8045_() {
            double d0 = Rat.this.m_20238_(this.groupCenter);
            return !(d0 < 9.0) && !(d0 > 256.0);
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
        }

        public void m_8041_() {
            if (Rat.this.f_19796_.m_188499_()) {
                Rat.this.m_21573_().m_26573_();
            }
        }

        public void m_8037_() {
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.m_183277_(10);
                this.setGroupCenter();
                Rat.this.m_21573_().m_26519_(this.groupCenter.f_82479_, this.groupCenter.f_82480_, this.groupCenter.f_82481_, 1.0);
            }
        }

        private void setGroupCenter() {
            this.groupCenter = Rat.this.findGroupCenter(Rat.this.getGroup());
        }
    }

    class RatFollowParentGoal
    extends FollowParentGoal {
        public RatFollowParentGoal() {
            super((Animal)Rat.this, 1.2);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }
    }

    class RatAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        public RatAvoidEntityGoal(Class<T> avoidClass, float maxDist, double walkSpeedModifier, double sprintSpeedModifier, Predicate<LivingEntity> predicate) {
            super((PathfinderMob)Rat.this, avoidClass, maxDist, walkSpeedModifier, sprintSpeedModifier, predicate);
        }

        public boolean m_8036_() {
            return Rat.this.shouldRunAway() && super.m_8036_();
        }

        public void m_8056_() {
            super.m_8056_();
            Rat.this.setRunningAway(true);
        }

        public void m_8041_() {
            super.m_8041_();
            Rat.this.setRunningAway(false);
        }
    }

    class RatRandomStrollGoal
    extends WaterAvoidingRandomStrollGoal {
        public RatRandomStrollGoal() {
            super((PathfinderMob)Rat.this, 1.0);
        }

        @Nullable
        protected Vec3 m_7037_() {
            if (Rat.this.m_20072_()) {
                Vec3 vec3 = LandRandomPos.m_148488_((PathfinderMob)Rat.this, (int)15, (int)7);
                return vec3 == null ? super.m_7037_() : vec3;
            }
            boolean flag = Rat.this.m_21824_() || Rat.this.isSurroundedByFriends();
            int max = flag ? 6 : 10;
            int min = flag ? 3 : 7;
            return this.f_25725_.m_217043_().m_188501_() >= this.f_25985_ ? LandRandomPos.m_148488_((PathfinderMob)this.f_25725_, (int)max, (int)min) : DefaultRandomPos.m_148403_((PathfinderMob)this.f_25725_, (int)max, (int)min);
        }
    }

    class RatFindItemsGoal
    extends Goal {
        public RatFindItemsGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!Rat.this.m_21205_().m_41619_()) {
                return false;
            }
            if (Rat.this.m_5448_() == null && Rat.this.m_21188_() == null) {
                if (Rat.this.m_217043_().m_188503_(10) != 0) {
                    return false;
                }
                List list = Rat.this.m_9236_().m_6443_(ItemEntity.class, Rat.this.m_20191_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
                return !list.isEmpty() && Rat.this.m_21205_().m_41619_();
            }
            return false;
        }

        public void m_8037_() {
            List list = Rat.this.m_9236_().m_6443_(ItemEntity.class, Rat.this.m_20191_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            ItemStack itemstack = Rat.this.m_21205_();
            if (itemstack.m_41619_() && !list.isEmpty()) {
                Rat.this.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
            }
        }

        public void m_8056_() {
            List list = Rat.this.m_9236_().m_6443_(ItemEntity.class, Rat.this.m_20191_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            if (!list.isEmpty()) {
                Rat.this.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
            }
        }
    }

    class RatStopAttackingGoal
    extends Goal {
        public RatStopAttackingGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            return !Rat.this.m_21824_() && !Rat.this.shouldAttack(Rat.this.m_5448_());
        }

        public boolean m_8045_() {
            return !Rat.this.m_21824_() && !Rat.this.shouldAttack(Rat.this.m_5448_());
        }

        public void m_8056_() {
            Rat.this.m_6710_(null);
        }
    }

    class RatHurtByTargetGoal
    extends HurtByTargetGoal {
        public RatHurtByTargetGoal() {
            super((PathfinderMob)Rat.this, new Class[0]);
        }

        public boolean m_8036_() {
            return Rat.this.shouldAttack(Rat.this.m_21188_()) && super.m_8036_();
        }

        protected void m_5766_(Mob mob, LivingEntity target) {
            if (mob instanceof Rat && ((Rat)mob).shouldAttack(this.f_26137_)) {
                super.m_5766_(mob, target);
            }
        }
    }

    class RatRandomTargetGoal<T extends LivingEntity>
    extends NonTameRandomTargetGoal<T> {
        public RatRandomTargetGoal(Class<T> targetType, boolean mustReach, Predicate<LivingEntity> predicate) {
            super((TamableAnimal)Rat.this, targetType, mustReach, predicate);
        }

        public boolean m_8036_() {
            return super.m_8036_() && Rat.this.shouldAttack(this.f_26050_);
        }

        public void m_8056_() {
            for (Rat friend : Rat.this.getGroup()) {
                if (friend == Rat.this || !friend.shouldAttack(this.f_26050_) || friend.m_5448_() != null) continue;
                friend.m_6710_(this.f_26050_);
            }
            super.m_8056_();
        }
    }

    public static enum RatType {
        BLUE(0),
        GRAY(1),
        BROWN(2),
        WHITE(3);

        private static final RatType[] VALUES;
        private final int id;
        private final LazyLoadedValue<ResourceLocation> textureLocation = new LazyLoadedValue(() -> new ResourceLocation("caverns_and_chasms", "textures/entity/rat/rat_" + this.name().toLowerCase(Locale.ROOT) + ".png"));

        private RatType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public ResourceLocation getTextureLocation() {
            return (ResourceLocation)this.textureLocation.m_13971_();
        }

        public static RatType byId(int id) {
            if (id < 0 || id >= VALUES.length) {
                id = 0;
            }
            return VALUES[id];
        }

        static {
            VALUES = (RatType[])Arrays.stream(RatType.values()).sorted(Comparator.comparingInt(RatType::getId)).toArray(RatType[]::new);
        }
    }
}

