/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.common.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class InductorBlock
extends Block {
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty COOLDOWN = BooleanProperty.m_61465_((String)"cooldown");
    public static final IntegerProperty INDUCTION_POWER = IntegerProperty.m_61631_((String)"induction_power", (int)0, (int)5);

    public InductorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)COOLDOWN, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_7820_().m_122424_();
        boolean powered = context.m_43725_().m_276867_(context.m_8083_());
        return (BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)FACING, (Comparable)direction)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!level.m_5776_() && ((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            this.induceNearbyCoils(level, pos);
        }
    }

    public int m_6378_(BlockState state, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Integer)state.m_61143_((Property)INDUCTION_POWER) * 3;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean powered = level.m_276867_(pos);
        if (powered != (Boolean)state.m_61143_((Property)POWERED) && !((Boolean)state.m_61143_((Property)COOLDOWN)).booleanValue() && !this.hasInductionSignal(state)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 3);
            this.induceNearbyCoils(level, pos);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.hasInductionSignal(state)) {
            level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)COOLDOWN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)INDUCTION_POWER, (Comparable)Integer.valueOf(0)), 3);
            level.m_186460_(pos, state.m_60734_(), 4);
        } else if (((Boolean)state.m_61143_((Property)COOLDOWN)).booleanValue()) {
            boolean powered = level.m_276867_(pos);
            level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)COOLDOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        }
    }

    private void induceNearbyCoils(Level level, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.m_121976_((int)(pos.m_123341_() - 8), (int)(pos.m_123342_() - 8), (int)(pos.m_123343_() - 8), (int)(pos.m_123341_() + 8), (int)(pos.m_123342_() + 8), (int)(pos.m_123343_() + 8))) {
            BlockState blockstate = level.m_8055_(blockpos);
            if (blockpos.equals((Object)pos) || !blockstate.m_60713_((Block)this)) continue;
            int xdist = Math.abs(blockpos.m_123341_() - pos.m_123341_());
            int ydist = Math.abs(blockpos.m_123342_() - pos.m_123342_());
            int zdist = Math.abs(blockpos.m_123343_() - pos.m_123343_());
            int power = Math.min(5, 9 - Math.max(Math.max(xdist, ydist), zdist));
            this.induceCoil(level, blockstate, blockpos, power);
        }
    }

    private void induceCoil(Level level, BlockState state, BlockPos pos, int power) {
        if (!(((Boolean)state.m_61143_((Property)POWERED)).booleanValue() || ((Boolean)state.m_61143_((Property)COOLDOWN)).booleanValue() || this.hasInductionSignal(state))) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)INDUCTION_POWER, (Comparable)Integer.valueOf(power)), 3);
            level.m_186460_(pos, state.m_60734_(), 8);
        }
    }

    private boolean hasInductionSignal(BlockState state) {
        return (Integer)state.m_61143_((Property)INDUCTION_POWER) > 0;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_57407_) {
        p_57407_.m_61104_(new Property[]{FACING, POWERED, COOLDOWN, INDUCTION_POWER});
    }
}

