/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.registrate.builder;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.Builder;
import com.tterrag.registrate.builders.BuilderCallback;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import com.tterrag.registrate.providers.RegistrateProvider;
import com.tterrag.registrate.providers.RegistrateTagsProvider;
import com.tterrag.registrate.util.entry.LazyRegistryEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagKey;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.ApiStatus;
import xyz.apex.forge.apexcore.registrate.CoreRegistrate;

public abstract class AbstractBuilder<OWNER extends CoreRegistrate<OWNER>, TYPE, VALUE extends TYPE, PARENT, BUILDER extends AbstractBuilder<OWNER, TYPE, VALUE, PARENT, BUILDER, ENTRY>, ENTRY extends RegistryEntry<VALUE>>
implements Builder<TYPE, VALUE, PARENT, BUILDER> {
    protected final BUILDER self = this;
    protected final OWNER owner;
    protected final PARENT parent;
    protected final String name;
    private final BuilderCallback callback;
    private final ResourceKey<Registry<TYPE>> registryType;
    private final Multimap<ProviderType<? extends RegistrateTagsProvider<?>>, TagKey<?>> tagsByType = HashMultimap.create();
    private final LazyRegistryEntry<VALUE> safeSupplier = new LazyRegistryEntry((NonNullSupplier)this);
    private final BiFunction<OWNER, RegistryObject<VALUE>, ENTRY> registryEntryFactory;
    private final Function<RegistryEntry<VALUE>, ENTRY> registryEntryCaster;

    protected AbstractBuilder(OWNER owner, PARENT parent, String name, BuilderCallback callback, ResourceKey<Registry<TYPE>> registryType, BiFunction<OWNER, RegistryObject<VALUE>, ENTRY> registryEntryFactory, Function<RegistryEntry<VALUE>, ENTRY> registryEntryCaster) {
        this.owner = owner;
        this.parent = parent;
        this.name = name;
        this.callback = callback;
        this.registryType = registryType;
        this.registryEntryFactory = registryEntryFactory;
        this.registryEntryCaster = registryEntryCaster;
    }

    protected abstract VALUE createEntry();

    public final BUILDER tag(ProviderType<? extends RegistrateTagsProvider<TYPE>> providerType, TagKey<TYPE> ... tags) {
        if (!this.tagsByType.containsKey(providerType)) {
            this.setData((ProviderType)providerType, (ctx, provider) -> this.tagsByType.get((Object)providerType).stream().map(tag -> tag).map(arg_0 -> ((RegistrateTagsProvider)provider).addTag(arg_0)).forEach(tag -> tag.add(TagEntry.m_215925_((ResourceLocation)new ResourceLocation(((CoreRegistrate)this.owner).modId, this.name)))));
        }
        this.tagsByType.putAll(providerType, Arrays.asList(tags));
        return this.self;
    }

    public final BUILDER removeTag(ProviderType<? extends RegistrateTagsProvider<TYPE>> providerType, TagKey<TYPE> ... tags) {
        if (this.tagsByType.containsKey(providerType)) {
            for (TagKey<TYPE> tag : tags) {
                this.tagsByType.remove(providerType, tag);
            }
        }
        return this.self;
    }

    public final BUILDER lang(NonNullFunction<VALUE, String> translationKeyProvider) {
        return this.lang(translationKeyProvider, (RegistrateLangProvider provider, NonNullSupplier<? extends VALUE> value) -> provider.getAutomaticName(value, this.registryType));
    }

    public final BUILDER lang(NonNullFunction<VALUE, String> translationKeyProvider, String name) {
        return this.lang(translationKeyProvider, (RegistrateLangProvider provider, NonNullSupplier<? extends VALUE> value) -> name);
    }

    public final BUILDER lang(NonNullFunction<VALUE, String> translationKeyProvider, BiFunction<RegistrateLangProvider, NonNullSupplier<? extends VALUE>, String> translationValueProvider) {
        return (BUILDER)this.setData(ProviderType.LANG, (ctx, provider) -> provider.add((String)translationKeyProvider.apply(ctx.get()), (String)translationValueProvider.apply((RegistrateLangProvider)provider, (NonNullSupplier)ctx)));
    }

    public final <PROVIDER extends RegistrateProvider> BUILDER clearData(ProviderType<? extends PROVIDER> providerType) {
        return (BUILDER)this.setData((ProviderType)providerType, NonNullBiConsumer.noop());
    }

    public final ENTRY register() {
        return (ENTRY)((RegistryEntry)this.registryEntryCaster.apply(this.callback.accept(this.name, this.registryType, (Builder)this, this::createEntry, delegate -> (RegistryEntry)this.registryEntryFactory.apply(this.owner, (RegistryObject<VALUE>)delegate))));
    }

    public final NonNullSupplier<VALUE> asSupplier() {
        return this.safeSupplier;
    }

    public final ENTRY get() {
        return (ENTRY)super.get();
    }

    public final VALUE getEntry() {
        return (VALUE)super.getEntry();
    }

    public final <PROVIDER extends RegistrateProvider> BUILDER setData(ProviderType<? extends PROVIDER> type, NonNullBiConsumer<DataGenContext<TYPE, VALUE>, PROVIDER> cons) {
        return (BUILDER)((AbstractBuilder)super.setData(type, cons));
    }

    public final <PROVIDER extends RegistrateProvider> BUILDER addMiscData(ProviderType<? extends PROVIDER> type, NonNullConsumer<? extends PROVIDER> cons) {
        return (BUILDER)((AbstractBuilder)super.addMiscData(type, cons));
    }

    public final BUILDER onRegister(NonNullConsumer<? super VALUE> callback) {
        return (BUILDER)((AbstractBuilder)super.onRegister(callback));
    }

    public final <OR> BUILDER onRegisterAfter(ResourceKey<? extends Registry<OR>> dependencyType, NonNullConsumer<? super VALUE> callback) {
        return (BUILDER)((AbstractBuilder)super.onRegisterAfter(dependencyType, callback));
    }

    public final <TYPE2, VALUE2 extends TYPE2, PARENT2, BUILDER2 extends Builder<TYPE2, VALUE2, PARENT2, BUILDER2>> BUILDER2 transform(NonNullFunction<BUILDER, BUILDER2> func) {
        return (BUILDER2)super.transform(func);
    }

    public final PARENT build() {
        return (PARENT)super.build();
    }

    public final OWNER getRegistrate() {
        return this.owner;
    }

    @Deprecated
    @ApiStatus.Internal
    public final AbstractRegistrate<?> getOwner() {
        return ((CoreRegistrate)this.owner).backend;
    }

    public final PARENT getParent() {
        return this.parent;
    }

    public final String getName() {
        return this.name;
    }

    public final ResourceKey<? extends Registry<TYPE>> getRegistryKey() {
        return this.registryType;
    }
}

