/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.container;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.util.function.QuadFunction;

public class BaseMenu
extends AbstractContainerMenu {
    public final Player player;
    public final BlockPos pos;

    public BaseMenu(@Nullable MenuType<? extends BaseMenu> menuType, int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        super(menuType, windowId);
        this.player = playerInventory.f_35978_;
        this.pos = buffer.m_130135_();
    }

    @Nullable
    protected IItemHandler getItemHandler() {
        return null;
    }

    protected void onInventoryChanges() {
    }

    public final void setBlockEntityChanged() {
        BlockEntity blockEntity = this.player.m_9236_().m_7702_(this.pos);
        if (blockEntity != null) {
            blockEntity.m_6596_();
        }
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        if (this.f_38839_.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot.m_6657_()) {
            ItemStack stack1 = slot.m_7993_();
            stack = stack1.m_41777_();
            IItemHandler itemHandler = this.getItemHandler();
            if (itemHandler != null && itemHandler.getSlots() > 0) {
                int itemStart = 0;
                int itemEnd = itemHandler.getSlots() - 1;
                int playerStart = itemEnd + 1;
                int playerEnd = playerStart + 27 - 1;
                int hotStart = playerEnd + 1;
                int hotEnd = hotStart + 8;
                if (slotIndex >= itemStart && slotIndex <= itemEnd ? !this.m_38903_(stack1, playerStart, hotEnd, false) : (slotIndex >= playerStart && slotIndex <= playerEnd ? !this.m_38903_(stack1, itemStart, itemEnd, false) && !this.m_38903_(stack1, hotStart, hotEnd, false) : slotIndex >= hotStart && slotIndex <= hotEnd && !this.m_38903_(stack1, itemStart, itemEnd, false) && !this.m_38903_(stack1, playerStart, playerEnd, false))) {
                    return ItemStack.f_41583_;
                }
            } else {
                int playerStart = 0;
                int playerEnd = playerStart + 27 - 1;
                int hotStart = playerEnd + 1;
                int hotEnd = hotStart + 8;
                if (slotIndex >= playerStart && slotIndex <= playerEnd ? !this.m_38903_(stack1, hotStart, hotEnd, false) : slotIndex >= hotStart && slotIndex <= hotEnd && !this.m_38903_(stack1, playerStart, playerEnd, false)) {
                    return ItemStack.f_41583_;
                }
            }
            if (stack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (stack1.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stack1);
            this.m_38946_();
        }
        return stack;
    }

    public boolean m_6875_(Player player) {
        return player.m_6084_() && player.f_36096_ == this;
    }

    public void m_38946_() {
        super.m_38946_();
        this.onInventoryChanges();
    }

    protected static LazyOptional<IItemHandler> getItemHandlerFromBlockEntity(BlockEntity blockEntity, @Nullable Direction side) {
        return blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, side);
    }

    protected static LazyOptional<IItemHandler> getItemHandlerFromBlockEntity(BlockEntity blockEntity) {
        return BaseMenu.getItemHandlerFromBlockEntity(blockEntity, null);
    }

    public static void bindItemHandlerSlots(BaseMenu menu, IItemHandler itemHandler, int rows, int cols, int x, int y, QuadFunction<IItemHandler, Integer, Integer, Integer, SlotItemHandler> slotFactory) {
        for (int j = 0; j < rows; ++j) {
            for (int k = 0; k < cols; ++k) {
                menu.m_38897_((Slot)slotFactory.apply(itemHandler, k + j * cols, x + k * 18, y + j * 18));
            }
        }
    }

    public static void bindItemHandlerSlots(BaseMenu menu, IItemHandler itemHandler, int rows, int cols, int x, int y) {
        BaseMenu.bindItemHandlerSlots(menu, itemHandler, rows, cols, x, y, SlotItemHandler::new);
    }

    public static void bindPlayerInventory(BaseMenu menu) {
        BaseMenu.bindPlayerInventory(menu, Slot::new);
    }

    public static void bindPlayerInventory(BaseMenu menu, int x, int y) {
        BaseMenu.bindPlayerInventory(menu, x, y, Slot::new);
    }

    public static void bindPlayerInventory(BaseMenu menu, QuadFunction<Container, Integer, Integer, Integer, Slot> factory) {
        BaseMenu.bindPlayerInventory(menu, 8, 84, factory);
    }

    public static void bindPlayerInventory(BaseMenu menu, int x, int y, QuadFunction<Container, Integer, Integer, Integer, Slot> factory) {
        int i;
        Inventory playerInventory = menu.player.m_150109_();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                menu.m_38897_(factory.apply((Container)playerInventory, j + i * 9 + 9, x + j * 18, y + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            menu.m_38897_(factory.apply((Container)playerInventory, i, x + i * 18, y + 58));
        }
    }
}

