/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.allurement.common.dispenser;

import com.teamabnormals.allurement.core.AllurementConfig;
import com.teamabnormals.blueprint.core.util.BlockUtil;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class IronIngotDispenseBehavior
extends OptionalDispenseItemBehavior {
    protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
        BlockPos facingPos;
        ServerLevel level = source.m_7727_();
        BlockState facingState = level.m_8055_(facingPos = BlockUtil.offsetPos((BlockSource)source));
        if (facingState.m_60713_(Blocks.f_50323_)) {
            IronIngotDispenseBehavior.repairAnvil(Blocks.f_50322_, (Level)level, facingPos);
        }
        if (facingState.m_60713_(Blocks.f_50324_)) {
            IronIngotDispenseBehavior.repairAnvil(Blocks.f_50323_, (Level)level, facingPos);
        }
        this.m_123573_(true);
        stack.m_41774_(1);
        return stack;
    }

    public static void playSound(SoundEvent soundEvent, Level level, BlockPos pos) {
        level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public static void spawnParticles(SimpleParticleType particleType, RandomSource random, BlockPos pos) {
        for (int i = 0; i < 12; ++i) {
            double d2 = random.m_188583_() * 0.02;
            double d3 = random.m_188583_() * 0.02;
            double d4 = random.m_188583_() * 0.02;
            double d6 = (double)pos.m_123341_() + random.m_188500_();
            double d7 = (double)pos.m_123342_() + 1.0 + random.m_188500_() * 0.1;
            double d8 = (double)pos.m_123343_() + random.m_188500_();
            NetworkUtil.spawnParticle((String)particleType.m_5942_(), (double)d6, (double)d7, (double)d8, (double)d2, (double)d3, (double)d4);
        }
    }

    public static void repairAnvil(Block result, Level level, BlockPos facingPos) {
        RandomSource random = level.m_213780_();
        if (!level.m_5776_()) {
            if (random.m_188503_(((Integer)AllurementConfig.COMMON.ingotRepairChance.get()).intValue()) == 0) {
                level.m_7731_(facingPos, BlockUtil.transferAllBlockStates((BlockState)level.m_8055_(facingPos), (BlockState)result.m_49966_()), 3);
                IronIngotDispenseBehavior.spawnParticles(ParticleTypes.f_123815_, random, facingPos);
            } else {
                IronIngotDispenseBehavior.spawnParticles(ParticleTypes.f_123762_, random, facingPos);
            }
        }
        IronIngotDispenseBehavior.playSound(SoundEvents.f_11669_, level, facingPos);
    }

    public static boolean canBeRepaired(BlockState state) {
        return state.m_60713_(Blocks.f_50323_) || state.m_60713_(Blocks.f_50324_);
    }
}

