/*
 * Decompiled with CFR 0.152.
 */
package net.undeadunleashed.init;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.undeadunleashed.entity.FireBreathEntity;
import net.undeadunleashed.entity.FlamebreatherEntity;
import net.undeadunleashed.entity.HaunterEntity;
import net.undeadunleashed.entity.HaunterNaturalSpawningPlaceholderEntity;
import net.undeadunleashed.entity.HaunterSoulsandValleySpawnerEntity;
import net.undeadunleashed.entity.KnightEntity;
import net.undeadunleashed.entity.MoonlightArcEntity;
import net.undeadunleashed.entity.ShadewraithEntity;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class UndeadUnleashedModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"undead_unleashed");
    public static final RegistryObject<EntityType<HaunterEntity>> HAUNTER = UndeadUnleashedModEntities.register("haunter", EntityType.Builder.m_20704_(HaunterEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(HaunterEntity::new).m_20699_(0.6f, 2.0f));
    public static final RegistryObject<EntityType<HaunterNaturalSpawningPlaceholderEntity>> HAUNTER_NATURAL_SPAWNING_PLACEHOLDER = UndeadUnleashedModEntities.register("haunter_natural_spawning_placeholder", EntityType.Builder.m_20704_(HaunterNaturalSpawningPlaceholderEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(HaunterNaturalSpawningPlaceholderEntity::new).m_20719_().m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<KnightEntity>> DREADKNIGHT = UndeadUnleashedModEntities.register("dreadknight", EntityType.Builder.m_20704_(KnightEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(KnightEntity::new).m_20699_(0.7f, 2.2f));
    public static final RegistryObject<EntityType<FlamebreatherEntity>> FLAMEBREATHER = UndeadUnleashedModEntities.register("flamebreather", EntityType.Builder.m_20704_(FlamebreatherEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(FlamebreatherEntity::new).m_20719_().m_20699_(1.0f, 2.0f));
    public static final RegistryObject<EntityType<FireBreathEntity>> FIRE_BREATH = UndeadUnleashedModEntities.register("fire_breath", EntityType.Builder.m_20704_(FireBreathEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(FireBreathEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<ShadewraithEntity>> SHADEWRAITH = UndeadUnleashedModEntities.register("shadewraith", EntityType.Builder.m_20704_(ShadewraithEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(ShadewraithEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<MoonlightArcEntity>> MOONLIGHT_ARC = UndeadUnleashedModEntities.register("moonlight_arc", EntityType.Builder.m_20704_(MoonlightArcEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(MoonlightArcEntity::new).m_20719_().m_20699_(0.2f, 0.2f));
    public static final RegistryObject<EntityType<HaunterSoulsandValleySpawnerEntity>> HAUNTER_SOULSAND_VALLEY_SPAWNER = UndeadUnleashedModEntities.register("haunter_soulsand_valley_spawner", EntityType.Builder.m_20704_(HaunterSoulsandValleySpawnerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(HaunterSoulsandValleySpawnerEntity::new).m_20719_().m_20699_(0.6f, 1.8f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            HaunterEntity.init();
            HaunterNaturalSpawningPlaceholderEntity.init();
            KnightEntity.init();
            FlamebreatherEntity.init();
            ShadewraithEntity.init();
            MoonlightArcEntity.init();
            HaunterSoulsandValleySpawnerEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)HAUNTER.get(), HaunterEntity.createAttributes().m_22265_());
        event.put((EntityType)HAUNTER_NATURAL_SPAWNING_PLACEHOLDER.get(), HaunterNaturalSpawningPlaceholderEntity.createAttributes().m_22265_());
        event.put((EntityType)DREADKNIGHT.get(), KnightEntity.createAttributes().m_22265_());
        event.put((EntityType)FLAMEBREATHER.get(), FlamebreatherEntity.createAttributes().m_22265_());
        event.put((EntityType)SHADEWRAITH.get(), ShadewraithEntity.createAttributes().m_22265_());
        event.put((EntityType)MOONLIGHT_ARC.get(), MoonlightArcEntity.createAttributes().m_22265_());
        event.put((EntityType)HAUNTER_SOULSAND_VALLEY_SPAWNER.get(), HaunterSoulsandValleySpawnerEntity.createAttributes().m_22265_());
    }
}

