/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.animated_flywheel;

import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.mixin_interfaces.ICarriageFlywheel;
import com.railwayteam.railways.mixin_interfaces.IDistanceTravelled;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.kinetics.flywheel.FlywheelBlockEntity;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class FlywheelMovementBehaviour
implements MovementBehaviour {
    public boolean isActive(MovementContext context) {
        return true;
    }

    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        if (!((Boolean)CRConfigs.client().animatedFlywheels.get()).booleanValue()) {
            return;
        }
        if (!context.world.f_46443_ || Minecraft.m_91087_().m_91104_()) {
            return;
        }
        Contraption contraption = context.contraption;
        if (!(contraption instanceof CarriageContraption)) {
            return;
        }
        CarriageContraption carriageContraption = (CarriageContraption)contraption;
        AbstractContraptionEntity abstractContraptionEntity = carriageContraption.entity;
        if (!(abstractContraptionEntity instanceof CarriageContraptionEntity)) {
            return;
        }
        CarriageContraptionEntity carriageContraptionEntity = (CarriageContraptionEntity)abstractContraptionEntity;
        Object v = context.contraption.presentBlockEntities.get(context.localPos);
        if (!(v instanceof FlywheelBlockEntity)) {
            return;
        }
        FlywheelBlockEntity flywheelBlockEntity = (FlywheelBlockEntity)v;
        if (((Direction.Axis)flywheelBlockEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_61365_)).m_122478_()) {
            return;
        }
        Direction dir = carriageContraption.getAssemblyDirection();
        Direction.Axis flwAxis = (Direction.Axis)flywheelBlockEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_61365_);
        switch (dir) {
            case NORTH: 
            case SOUTH: {
                if (flwAxis != Direction.Axis.Z) break;
                return;
            }
            case EAST: 
            case WEST: {
                if (flwAxis != Direction.Axis.X) break;
                return;
            }
        }
        ICarriageFlywheel flywheel = (ICarriageFlywheel)flywheelBlockEntity;
        double distanceTravelled = ((IDistanceTravelled)carriageContraptionEntity).railways$getDistanceTravelled();
        double angleDiff = 360.0 * (distanceTravelled / (double)AnimationTickHolder.getPartialTicks()) / 8.835729338221293;
        if (dir == Direction.SOUTH || dir == Direction.WEST) {
            angleDiff = -angleDiff;
        }
        float newWheelAngle = (float)((double)flywheel.railways$getAngle() + angleDiff % 360.0);
        flywheel.railways$setAngle(newWheelAngle);
    }
}

