/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.foundation.ui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.gui.NavigatableSimiScreen;
import net.createmod.catnip.gui.ScreenOpener;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.AbstractRenderElement;
import net.createmod.catnip.gui.element.BoxElement;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.createmod.catnip.gui.widget.BoxWidget;
import net.createmod.catnip.lang.ClientFontHelper;
import net.createmod.catnip.layout.LayoutHelper;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.Ponder;
import net.createmod.ponder.foundation.PonderChapter;
import net.createmod.ponder.foundation.PonderIndex;
import net.createmod.ponder.foundation.PonderTag;
import net.createmod.ponder.foundation.ui.AbstractPonderScreen;
import net.createmod.ponder.foundation.ui.PonderButton;
import net.createmod.ponder.foundation.ui.PonderUI;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class PonderTagScreen
extends AbstractPonderScreen {
    private final PonderTag tag;
    protected final List<ItemEntry> items = new ArrayList<ItemEntry>();
    private final double itemXmult = 0.5;
    @Nullable
    protected Rect2i itemArea;
    protected final List<PonderChapter> chapters = new ArrayList<PonderChapter>();
    private final double chapterXmult = 0.5;
    private final double chapterYmult = 0.75;
    @Nullable
    protected Rect2i chapterArea;
    private final double mainYmult = 0.15;
    private ItemStack hoveredItem = ItemStack.f_41583_;

    public PonderTagScreen(ResourceLocation tag) {
        this.tag = PonderIndex.getTagAccess().getRegisteredTag(tag);
    }

    public PonderTagScreen(PonderTag tag) {
        this.tag = tag;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.items.clear();
        PonderIndex.getTagAccess().getItems(this.tag).stream().map(key -> new ItemEntry(CatnipServices.REGISTRIES.getItemOrBlock((ResourceLocation)key), (ResourceLocation)key)).filter(entry -> entry.item != null).forEach(this.items::add);
        if (!this.tag.getMainItem().m_41619_()) {
            this.items.removeIf(entry -> entry.item == this.tag.getMainItem().m_41720_());
        }
        int rowCount = Mth.m_14045_((int)((int)Math.ceil((double)this.items.size() / 11.0)), (int)1, (int)3);
        LayoutHelper layout = LayoutHelper.centeredHorizontal(this.items.size(), rowCount, 28, 28, 8);
        this.itemArea = layout.getArea();
        int itemCenterX = (int)((double)this.f_96543_ * 0.5);
        int itemCenterY = this.getItemsY();
        for (ItemEntry entry2 : this.items) {
            Object b = new PonderButton(itemCenterX + layout.getX() + 4, itemCenterY + layout.getY() + 4).showing(new ItemStack(entry2.item));
            if (PonderIndex.getSceneAccess().doScenesExistForId(entry2.key)) {
                ((AbstractSimiWidget)b).withCallback((mouseX, mouseY) -> {
                    this.centerScalingOn((int)mouseX, (int)mouseY);
                    ScreenOpener.transitionTo(PonderUI.of(new ItemStack(entry.item), this.tag));
                });
            } else {
                ((BoxWidget)((BoxWidget)b).withBorderColors(entry2.key.m_135827_().equals("minecraft") ? PonderUI.MISSING_VANILLA_ENTRY : PonderUI.MISSING_MODDED_ENTRY)).animateColors(false);
            }
            this.m_142416_((GuiEventListener)b);
            layout.next();
        }
        if (!this.tag.getMainItem().m_41619_()) {
            ResourceLocation registryName = CatnipServices.REGISTRIES.getKeyOrThrow(this.tag.getMainItem().m_41720_());
            Object b = new PonderButton(itemCenterX - layout.getTotalWidth() / 2 - 48, itemCenterY - 10).showing(this.tag.getMainItem());
            if (PonderIndex.getSceneAccess().doScenesExistForId(registryName)) {
                ((AbstractSimiWidget)b).withCallback((mouseX, mouseY) -> {
                    this.centerScalingOn((int)mouseX, (int)mouseY);
                    ScreenOpener.transitionTo(PonderUI.of(this.tag.getMainItem(), this.tag));
                });
            } else {
                ((BoxWidget)((BoxWidget)b).withBorderColors(registryName.m_135827_().equals("minecraft") ? PonderUI.MISSING_VANILLA_ENTRY : PonderUI.MISSING_MODDED_ENTRY)).animateColors(false);
            }
            this.m_142416_((GuiEventListener)b);
        }
    }

    @Override
    protected void initBackTrackIcon(BoxWidget backTrack) {
        backTrack.showing(this.tag);
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        ++PonderUI.ponderTicks;
        this.hoveredItem = ItemStack.f_41583_;
        Window w = this.f_96541_.m_91268_();
        int mX = (int)(this.f_96541_.f_91067_.m_91589_() * (double)w.m_85445_() / (double)w.m_85443_());
        int mY = (int)(this.f_96541_.f_91067_.m_91594_() * (double)w.m_85446_() / (double)w.m_85444_());
        for (GuiEventListener child : this.m_6702_()) {
            PonderButton button;
            if (child == this.backTrack || !(child instanceof PonderButton) || !(button = (PonderButton)child).m_5953_(mX, mY)) continue;
            this.hoveredItem = button.getItem();
        }
    }

    @Override
    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWindow(graphics, mouseX, mouseY, partialTicks);
        this.renderItems(graphics, mouseX, mouseY, partialTicks);
        this.renderChapters(graphics, mouseX, mouseY, partialTicks);
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85837_((double)(this.f_96543_ / 2 - 120), (double)this.f_96544_ * 0.15 - 40.0, 0.0);
        poseStack.m_85836_();
        int x = 59;
        int y = 31;
        String title = this.tag.getTitle();
        int streakHeight = 35;
        UIRenderHelper.streak(graphics, 0.0f, x - 4, y - 12 + streakHeight / 2, streakHeight, 240);
        ((AbstractRenderElement)((BoxElement)new BoxElement().withBackground(PonderUI.BACKGROUND_FLAT)).gradientBorder(PonderUI.COLOR_IDLE)).at(21.0f, 21.0f, 100.0f).withBounds(30, 30).render(graphics);
        graphics.m_280614_(this.f_96547_, (Component)Ponder.lang().translate("ui.pondering", new Object[0]).component(), x, y - 6, ((Color)UIRenderHelper.COLOR_TEXT_DARKER.getFirst()).getRGB(), false);
        poseStack.m_252880_((float)(x += 0), (float)(y += 8), 0.0f);
        poseStack.m_252880_(0.0f, 0.0f, 5.0f);
        graphics.m_280056_(this.f_96547_, title, 0, 0, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB(), false);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_252880_(23.0f, 23.0f, 10.0f);
        poseStack.m_85841_(1.66f, 1.66f, 1.66f);
        this.tag.render(graphics, 0, 0);
        poseStack.m_85849_();
        poseStack.m_85849_();
        poseStack.m_85836_();
        int w = (int)((double)this.f_96543_ * 0.45);
        x = (this.f_96543_ - w) / 2;
        y = this.getItemsY() - 10 + Math.max(this.itemArea.m_110091_(), 48);
        String desc = this.tag.getDescription();
        int h = this.f_96547_.m_92920_(desc, w);
        ((AbstractRenderElement)((BoxElement)new BoxElement().withBackground(PonderUI.BACKGROUND_FLAT)).gradientBorder(PonderUI.COLOR_IDLE)).at(x - 3, y - 3, 90.0f).withBounds(w + 6, h + 6).render(graphics);
        poseStack.m_252880_(0.0f, 0.0f, 100.0f);
        ClientFontHelper.drawSplitString(poseStack, this.f_96547_, desc, x, y, w, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        poseStack.m_85849_();
    }

    protected void renderItems(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.items.isEmpty()) {
            return;
        }
        int x = (int)((double)this.f_96543_ * 0.5);
        int y = this.getItemsY();
        String relatedTitle = Ponder.lang().translate("ui.associated", new Object[0]).string();
        int stringWidth = this.f_96547_.m_92895_(relatedTitle);
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)x, (float)y, 0.0f);
        ((AbstractRenderElement)((BoxElement)new BoxElement().withBackground(PonderUI.BACKGROUND_FLAT)).gradientBorder(PonderUI.COLOR_IDLE)).at((float)(this.windowWidth - stringWidth) / 2.0f - 5.0f, this.itemArea.m_110086_() - 21, 100.0f).withBounds(stringWidth + 10, 10).render(graphics);
        poseStack.m_252880_(0.0f, 0.0f, 200.0f);
        graphics.m_280137_(this.f_96547_, relatedTitle, this.windowWidth / 2, this.itemArea.m_110086_() - 20, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        poseStack.m_252880_(0.0f, 0.0f, -200.0f);
        UIRenderHelper.streak(graphics, 0.0f, 0, 0, this.itemArea.m_110091_() + 10, this.itemArea.m_110090_() / 2 + 75);
        UIRenderHelper.streak(graphics, 180.0f, 0, 0, this.itemArea.m_110091_() + 10, this.itemArea.m_110090_() / 2 + 75);
        poseStack.m_85849_();
    }

    public int getItemsY() {
        return (int)(0.15 * (double)this.f_96544_ + 85.0);
    }

    protected void renderChapters(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.chapters.isEmpty()) {
            return;
        }
        int chapterX = (int)((double)this.f_96543_ * 0.5);
        int chapterY = (int)((double)this.f_96544_ * 0.75);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)chapterX, (float)chapterY, 0.0f);
        UIRenderHelper.streak(graphics, 0.0f, this.chapterArea.m_110085_() - 10, this.chapterArea.m_110086_() - 20, 20, 220);
        graphics.m_280056_(this.f_96547_, "More Topics to Ponder about", this.chapterArea.m_110085_() - 5, this.chapterArea.m_110086_() - 25, ((Color)UIRenderHelper.COLOR_TEXT_ACCENT.getFirst()).getRGB(), false);
        graphics.m_280168_().m_85849_();
    }

    @Override
    protected void renderWindowForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.disableDepthTest();
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 200.0f);
        if (!this.hoveredItem.m_41619_()) {
            graphics.m_280153_(this.f_96547_, this.hoveredItem, mouseX, mouseY);
        }
        poseStack.m_85849_();
        RenderSystem.enableDepthTest();
    }

    @Override
    protected String getBreadcrumbTitle() {
        return this.tag.getTitle();
    }

    public ItemStack getHoveredTooltipItem() {
        return this.hoveredItem;
    }

    @Override
    public boolean isEquivalentTo(NavigatableSimiScreen other) {
        if (other instanceof PonderTagScreen) {
            return this.tag == ((PonderTagScreen)other).tag;
        }
        return super.isEquivalentTo(other);
    }

    @Override
    public boolean m_7043_() {
        return true;
    }

    public PonderTag getTag() {
        return this.tag;
    }

    public void m_7861_() {
        super.m_7861_();
        this.hoveredItem = ItemStack.f_41583_;
    }

    public record ItemEntry(@Nullable ItemLike item, ResourceLocation key) {
    }
}

