/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.foundation.element;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.ponder.api.element.MinecartElement;
import net.createmod.ponder.api.level.PonderLevel;
import net.createmod.ponder.foundation.PonderScene;
import net.createmod.ponder.foundation.element.AnimatedSceneElementBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.phys.Vec3;

public class MinecartElementImpl
extends AnimatedSceneElementBase
implements MinecartElement {
    private final Vec3 location;
    private final LerpedFloat rotation;
    @Nullable
    private AbstractMinecart entity;
    private final MinecartElement.MinecartConstructor constructor;
    private final float initialRotation;

    public MinecartElementImpl(Vec3 location, float rotation, MinecartElement.MinecartConstructor constructor) {
        this.initialRotation = rotation;
        this.location = location.m_82520_(0.0, 0.0625, 0.0);
        this.constructor = constructor;
        this.rotation = LerpedFloat.angular().startWithValue(rotation);
    }

    @Override
    public void reset(PonderScene scene) {
        super.reset(scene);
        this.entity.m_20343_(0.0, 0.0, 0.0);
        this.entity.f_19854_ = 0.0;
        this.entity.f_19855_ = 0.0;
        this.entity.f_19856_ = 0.0;
        this.entity.f_19790_ = 0.0;
        this.entity.f_19791_ = 0.0;
        this.entity.f_19792_ = 0.0;
        this.rotation.startWithValue(this.initialRotation);
    }

    @Override
    public void tick(PonderScene scene) {
        super.tick(scene);
        if (this.entity == null) {
            this.entity = this.constructor.create(scene.getWorld(), 0.0, 0.0, 0.0);
        }
        ++this.entity.f_19797_;
        this.entity.m_6853_(true);
        this.entity.f_19854_ = this.entity.m_20185_();
        this.entity.f_19855_ = this.entity.m_20186_();
        this.entity.f_19856_ = this.entity.m_20189_();
        this.entity.f_19790_ = this.entity.m_20185_();
        this.entity.f_19791_ = this.entity.m_20186_();
        this.entity.f_19792_ = this.entity.m_20189_();
    }

    @Override
    public void setPositionOffset(Vec3 position, boolean immediate) {
        if (this.entity == null) {
            return;
        }
        this.entity.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
        if (!immediate) {
            return;
        }
        this.entity.f_19854_ = position.f_82479_;
        this.entity.f_19855_ = position.f_82480_;
        this.entity.f_19856_ = position.f_82481_;
    }

    @Override
    public void setRotation(float angle, boolean immediate) {
        if (this.entity == null) {
            return;
        }
        this.rotation.setValue(angle);
        if (!immediate) {
            return;
        }
        this.rotation.startWithValue(angle);
    }

    @Override
    public Vec3 getPositionOffset() {
        return this.entity != null ? this.entity.m_20182_() : Vec3.f_82478_;
    }

    @Override
    public Vec3 getRotation() {
        return new Vec3(0.0, (double)this.rotation.getValue(), 0.0);
    }

    @Override
    public void renderLast(PonderLevel world, MultiBufferSource buffer, GuiGraphics graphics, float fade, float pt) {
        PoseStack poseStack = graphics.m_280168_();
        EntityRenderDispatcher entityrenderermanager = Minecraft.m_91087_().m_91290_();
        if (this.entity == null) {
            this.entity = this.constructor.create(world, 0.0, 0.0, 0.0);
        }
        poseStack.m_85836_();
        poseStack.m_85837_(this.location.f_82479_, this.location.f_82480_, this.location.f_82481_);
        poseStack.m_85837_(Mth.m_14139_((double)pt, (double)this.entity.f_19854_, (double)this.entity.m_20185_()), Mth.m_14139_((double)pt, (double)this.entity.f_19855_, (double)this.entity.m_20186_()), Mth.m_14139_((double)pt, (double)this.entity.f_19856_, (double)this.entity.m_20189_()));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(this.rotation.getValue(pt)));
        entityrenderermanager.m_114384_((Entity)this.entity, 0.0, 0.0, 0.0, 0.0f, pt, poseStack, buffer, this.lightCoordsFromFade(fade));
        poseStack.m_85849_();
    }
}

