/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.foundation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Pair;
import net.createmod.ponder.api.registration.StoryBoardEntry;
import net.createmod.ponder.foundation.PonderChapter;
import net.minecraft.resources.ResourceLocation;

public class PonderChapterRegistry {
    private final Map<ResourceLocation, Pair<PonderChapter, List<StoryBoardEntry>>> chapters = new HashMap<ResourceLocation, Pair<PonderChapter, List<StoryBoardEntry>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PonderChapter addChapter(@Nonnull PonderChapter chapter) {
        Map<ResourceLocation, Pair<PonderChapter, List<StoryBoardEntry>>> map = this.chapters;
        synchronized (map) {
            this.chapters.put(chapter.getId(), Pair.of(chapter, new ArrayList()));
        }
        return chapter;
    }

    @Nullable
    PonderChapter getChapter(ResourceLocation id) {
        Pair<PonderChapter, List<StoryBoardEntry>> pair = this.chapters.get(id);
        if (pair == null) {
            return null;
        }
        return pair.getFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStoriesToChapter(@Nonnull PonderChapter chapter, StoryBoardEntry ... entries) {
        List<StoryBoardEntry> entryList;
        List<StoryBoardEntry> list = entryList = this.chapters.get(chapter.getId()).getSecond();
        synchronized (list) {
            Collections.addAll(entryList, entries);
        }
    }

    public List<PonderChapter> getAllChapters() {
        return this.chapters.values().stream().map(Pair::getFirst).collect(Collectors.toList());
    }

    public List<StoryBoardEntry> getStories(PonderChapter chapter) {
        Pair<PonderChapter, List<StoryBoardEntry>> chapterPair = this.chapters.get(chapter.getId());
        if (chapterPair == null) {
            return List.of();
        }
        return chapterPair.getSecond();
    }
}

