/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.render;

import java.util.Objects;
import javax.annotation.Nullable;
import net.createmod.catnip.render.StitchedSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;

public class SpriteShiftEntry {
    @Nullable
    protected StitchedSprite original;
    @Nullable
    protected StitchedSprite target;

    public void set(ResourceLocation originalLocation, ResourceLocation targetLocation) {
        this.original = new StitchedSprite(originalLocation);
        this.target = new StitchedSprite(targetLocation);
    }

    public ResourceLocation getOriginalResourceLocation() {
        Objects.requireNonNull(this.original);
        return this.original.getLocation();
    }

    public ResourceLocation getTargetResourceLocation() {
        Objects.requireNonNull(this.target);
        return this.target.getLocation();
    }

    public TextureAtlasSprite getOriginal() {
        Objects.requireNonNull(this.original);
        return this.original.get();
    }

    public TextureAtlasSprite getTarget() {
        Objects.requireNonNull(this.target);
        return this.target.get();
    }

    public float getTargetU(float localU) {
        return this.getTarget().m_118367_((double)SpriteShiftEntry.getUnInterpolatedU(this.getOriginal(), localU));
    }

    public float getTargetV(float localV) {
        return this.getTarget().m_118393_((double)SpriteShiftEntry.getUnInterpolatedV(this.getOriginal(), localV));
    }

    public static float getUnInterpolatedU(TextureAtlasSprite sprite, float u) {
        float f = sprite.m_118410_() - sprite.m_118409_();
        return (u - sprite.m_118409_()) / f * 16.0f;
    }

    public static float getUnInterpolatedV(TextureAtlasSprite sprite, float v) {
        float f = sprite.m_118412_() - sprite.m_118411_();
        return (v - sprite.m_118411_()) / f * 16.0f;
    }
}

