/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.engine_room.flywheel.lib.util.ShadersModHelper;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.platform.CatnipClientServices;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.render.TemplateMesh;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.mixin.client.accessor.RenderSystemAccessor;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ShadeSeparatingSuperByteBuffer
implements SuperByteBuffer {
    private static final Long2IntMap WORLD_LIGHT_CACHE = new Long2IntOpenHashMap();
    private final TemplateMesh template;
    private final int[] shadeSwapVertices;
    private final PoseStack transforms = new PoseStack();
    private int vertexColor;
    private boolean disableDiffuse;
    @Nullable
    private SuperByteBuffer.SpriteShiftFunc spriteShiftFunc;
    private boolean hasCustomOverlay;
    private int overlay;
    private boolean hasCustomLight;
    private int packedLight;
    private boolean useLevelLight;
    @Nullable
    private BlockAndTintGetter levelWithLight;
    @Nullable
    private Matrix4f lightTransform;
    private final Matrix4f modelMat = new Matrix4f();
    private final Matrix3f normalMat = new Matrix3f();
    private final Vector4f pos = new Vector4f();
    private final Vector3f normal = new Vector3f();
    private final Vector3f lightDir0 = new Vector3f();
    private final Vector3f lightDir1 = new Vector3f();
    private final SuperByteBuffer.ShiftOutput shiftOutput = new SuperByteBuffer.ShiftOutput();
    private final Vector3f lightPos = new Vector3f();

    public ShadeSeparatingSuperByteBuffer(TemplateMesh template, int[] shadeSwapVertices) {
        this.template = template;
        this.shadeSwapVertices = shadeSwapVertices;
        this.reset();
    }

    public ShadeSeparatingSuperByteBuffer(TemplateMesh template) {
        this(template, new int[0]);
    }

    public void renderIntoImpl(PoseStack input, VertexConsumer builder) {
        Matrix4f modelMat = this.modelMat.set((Matrix4fc)input.m_85850_().m_252922_());
        Matrix4f localTransforms = this.transforms.m_85850_().m_252922_();
        modelMat.mul((Matrix4fc)localTransforms);
        Matrix3f normalMat = this.normalMat.set((Matrix3fc)input.m_85850_().m_252943_());
        Matrix3f localNormalTransforms = this.transforms.m_85850_().m_252943_();
        normalMat.mul((Matrix3fc)localNormalTransforms);
        Vector4f pos = this.pos;
        Vector3f normal = this.normal;
        SuperByteBuffer.ShiftOutput shiftOutput = this.shiftOutput;
        Vector3f lightDir0 = this.lightDir0;
        Vector3f lightDir1 = this.lightDir1;
        Vector3f lightPos = this.lightPos;
        boolean applyDiffuse = !this.disableDiffuse && !ShadersModHelper.isShaderPackInUse();
        boolean shaded = true;
        int shadeSwapIndex = 0;
        int nextShadeSwapVertex = shadeSwapIndex < this.shadeSwapVertices.length ? this.shadeSwapVertices[shadeSwapIndex] : -1;
        int unshadedDiffuse = 255;
        if (applyDiffuse) {
            lightDir0.set((Vector3fc)RenderSystemAccessor.catnip$getShaderLightDirections()[0]).normalize();
            lightDir1.set((Vector3fc)RenderSystemAccessor.catnip$getShaderLightDirections()[1]).normalize();
            if (this.shadeSwapVertices.length > 0) {
                normal.set(0.0f, 1.0f, 0.0f);
                unshadedDiffuse = (int)(255.0f * ShadeSeparatingSuperByteBuffer.calculateDiffuse((Vector3fc)normal, (Vector3fc)lightDir0, (Vector3fc)lightDir1));
            }
        }
        int vertexCount = this.template.vertexCount();
        for (int i = 0; i < vertexCount; ++i) {
            if (i == nextShadeSwapVertex) {
                shaded = !shaded;
                nextShadeSwapVertex = ++shadeSwapIndex < this.shadeSwapVertices.length ? this.shadeSwapVertices[shadeSwapIndex] : -1;
            }
            float x = this.template.x(i);
            float y = this.template.y(i);
            float z = this.template.z(i);
            pos.set(x, y, z, 1.0f);
            pos.mul((Matrix4fc)modelMat);
            int packedNormal = this.template.normal(i);
            float normalX = (float)((byte)(packedNormal & 0xFF)) / 127.0f;
            float normalY = (float)((byte)(packedNormal >>> 8 & 0xFF)) / 127.0f;
            float normalZ = (float)((byte)(packedNormal >>> 16 & 0xFF)) / 127.0f;
            normal.set(normalX, normalY, normalZ);
            normal.mul((Matrix3fc)normalMat);
            int quadColor = this.template.color(i);
            int r = (quadColor & 0xFF) * (this.vertexColor & 0xFF) + 255 >>> 8;
            int g = (quadColor >>> 8 & 0xFF) * (this.vertexColor >>> 8 & 0xFF) + 255 >>> 8;
            int b = (quadColor >>> 16 & 0xFF) * (this.vertexColor >>> 16 & 0xFF) + 255 >>> 8;
            int a = (quadColor >>> 24 & 0xFF) * (this.vertexColor >>> 24 & 0xFF) + 255 >>> 8;
            if (applyDiffuse) {
                int factor = shaded ? (int)(255.0f * ShadeSeparatingSuperByteBuffer.calculateDiffuse((Vector3fc)normal, (Vector3fc)lightDir0, (Vector3fc)lightDir1)) : unshadedDiffuse;
                r = r * factor + 255 >>> 8;
                g = g * factor + 255 >>> 8;
                b = b * factor + 255 >>> 8;
            }
            int color = a << 24 | r << 16 | g << 8 | b;
            float u = this.template.u(i);
            float v = this.template.v(i);
            if (this.spriteShiftFunc != null) {
                this.spriteShiftFunc.shift(u, v, shiftOutput);
                u = shiftOutput.u;
                v = shiftOutput.v;
            }
            int overlay = this.hasCustomOverlay ? this.overlay : this.template.overlay(i);
            int light = this.template.light(i);
            if (this.hasCustomLight) {
                light = SuperByteBuffer.maxLight(light, this.packedLight);
            }
            if (this.useLevelLight) {
                lightPos.set((x - 0.5f) * 15.0f / 16.0f + 0.5f, (y - 0.5f) * 15.0f / 16.0f + 0.5f, (z - 0.5f) * 15.0f / 16.0f + 0.5f);
                light = SuperByteBuffer.maxLight(light, this.getLight(lightPos));
            }
            builder.m_5483_((double)pos.x, (double)pos.y, (double)pos.z).m_193479_(color).m_7421_(u, v).m_86008_(overlay).m_85969_(light).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        }
    }

    @Override
    public void renderInto(PoseStack input, VertexConsumer builder) {
        if (this.isEmpty()) {
            return;
        }
        if (CatnipClientServices.EXTERNAL_RENDER_HELPER.renderInto(this, input, builder)) {
            this.reset();
            return;
        }
        this.renderIntoImpl(input, builder);
        this.reset();
    }

    public SuperByteBuffer reset() {
        while (!this.transforms.m_85851_()) {
            this.transforms.m_85849_();
        }
        this.transforms.m_85836_();
        this.vertexColor = -1;
        this.disableDiffuse = false;
        this.spriteShiftFunc = null;
        this.hasCustomOverlay = false;
        this.overlay = OverlayTexture.f_118083_;
        this.hasCustomLight = false;
        this.packedLight = 0;
        this.useLevelLight = false;
        this.levelWithLight = null;
        this.lightTransform = null;
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.template.isEmpty();
    }

    @Override
    public PoseStack getTransforms() {
        return this.transforms;
    }

    public boolean isDisableDiffuse() {
        return this.disableDiffuse;
    }

    public int getVertexColor() {
        return this.vertexColor;
    }

    public TemplateMesh getTemplateMesh() {
        return this.template;
    }

    public int[] getShadeSwapVertices() {
        return this.shadeSwapVertices;
    }

    @Nullable
    public SuperByteBuffer.SpriteShiftFunc getSpriteShiftFunc() {
        return this.spriteShiftFunc;
    }

    public boolean hasCustomOverlay() {
        return this.hasCustomOverlay;
    }

    public int getOverlay() {
        return this.overlay;
    }

    public boolean hasCustomLight() {
        return this.hasCustomLight;
    }

    public int getPackedLight() {
        return this.packedLight;
    }

    public boolean isUsingLevelLight() {
        return this.useLevelLight;
    }

    public SuperByteBuffer scale(float factorX, float factorY, float factorZ) {
        this.transforms.m_85841_(factorX, factorY, factorZ);
        return this;
    }

    public SuperByteBuffer rotate(Quaternionfc quaternion) {
        PoseStack.Pose last = this.transforms.m_85850_();
        last.m_252922_().rotate(quaternion);
        last.m_252943_().rotate(quaternion);
        return this;
    }

    public SuperByteBuffer translate(float x, float y, float z) {
        this.transforms.m_252880_(x, y, z);
        return this;
    }

    public SuperByteBuffer mulPose(Matrix4fc pose) {
        this.transforms.m_85850_().m_252922_().mul(pose);
        return this;
    }

    public SuperByteBuffer mulNormal(Matrix3fc normal) {
        this.transforms.m_85850_().m_252943_().mul(normal);
        return this;
    }

    public SuperByteBuffer pushPose() {
        this.transforms.m_85836_();
        return this;
    }

    public SuperByteBuffer popPose() {
        this.transforms.m_85849_();
        return this;
    }

    public SuperByteBuffer color(float r, float g, float b, float a) {
        this.color((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), (int)(a * 255.0f));
        return this;
    }

    public SuperByteBuffer color(int r, int g, int b, int a) {
        this.vertexColor = (a & 0xFF) << 24 | (b & 0xFF) << 16 | (g & 0xFF) << 8 | r & 0xFF;
        return this;
    }

    public SuperByteBuffer color(int color) {
        this.vertexColor = 0xFF000000 | (color & 0xFF) << 16 | color & 0xFF00 | (color & 0xFF0000) >>> 16;
        return this;
    }

    public SuperByteBuffer color(Color c) {
        return this.color(c.getRGB());
    }

    public SuperByteBuffer disableDiffuse() {
        this.disableDiffuse = true;
        return this;
    }

    public SuperByteBuffer shiftUV(SpriteShiftEntry entry) {
        this.spriteShiftFunc = (u, v, output) -> output.accept(entry.getTargetU(u), entry.getTargetV(v));
        return this;
    }

    public SuperByteBuffer shiftUVScrolling(SpriteShiftEntry entry, float scrollV) {
        return this.shiftUVScrolling(entry, 0.0f, scrollV);
    }

    public SuperByteBuffer shiftUVScrolling(SpriteShiftEntry entry, float scrollU, float scrollV) {
        this.spriteShiftFunc = (u, v, output) -> {
            float targetU = u - entry.getOriginal().m_118409_() + entry.getTarget().m_118409_() + scrollU;
            float targetV = v - entry.getOriginal().m_118411_() + entry.getTarget().m_118411_() + scrollV;
            output.accept(targetU, targetV);
        };
        return this;
    }

    public SuperByteBuffer shiftUVtoSheet(SpriteShiftEntry entry, float uTarget, float vTarget, int sheetSize) {
        this.spriteShiftFunc = (u, v, output) -> {
            float targetU = entry.getTarget().m_118367_((double)(SpriteShiftEntry.getUnInterpolatedU(entry.getOriginal(), u) / (float)sheetSize + uTarget * 16.0f));
            float targetV = entry.getTarget().m_118393_((double)(SpriteShiftEntry.getUnInterpolatedV(entry.getOriginal(), v) / (float)sheetSize + vTarget * 16.0f));
            output.accept(targetU, targetV);
        };
        return this;
    }

    public SuperByteBuffer overlay(int overlay) {
        this.hasCustomOverlay = true;
        this.overlay = overlay;
        return this;
    }

    public SuperByteBuffer light(int packedLight) {
        this.hasCustomLight = true;
        this.packedLight = packedLight;
        return this;
    }

    public SuperByteBuffer useLevelLight(BlockAndTintGetter level) {
        this.useLevelLight = true;
        this.levelWithLight = level;
        return this;
    }

    public SuperByteBuffer useLevelLight(BlockAndTintGetter level, Matrix4f lightTransform) {
        this.useLevelLight = true;
        this.levelWithLight = level;
        this.lightTransform = lightTransform;
        return this;
    }

    public static float calculateDiffuse(Vector3fc normal, Vector3fc lightDir0, Vector3fc lightDir1) {
        float light0 = Math.max(0.0f, lightDir0.dot(normal));
        float light1 = Math.max(0.0f, lightDir1.dot(normal));
        return Math.min(1.0f, (light0 + light1) * 0.6f + 0.4f);
    }

    public static int getLight(BlockAndTintGetter world, Vector3f lightPos) {
        BlockPos pos = BlockPos.m_274561_((double)lightPos.x(), (double)lightPos.y(), (double)lightPos.z());
        return WORLD_LIGHT_CACHE.computeIfAbsent(pos.m_121878_(), $ -> LevelRenderer.m_109541_((BlockAndTintGetter)world, (BlockPos)pos));
    }

    public int getLight(Vector3f lightPos) {
        return ShadeSeparatingSuperByteBuffer.getLight(this.levelWithLight, this.lightTransform == null ? lightPos : lightPos.mulPosition((Matrix4fc)this.lightTransform));
    }
}

